/**
* @file Platform/Win32/ForSimRobXP/TimeInfo.cpp
*
* Implementation of class TimeInfo
*
* @author <a href="mailto:roefer.tzi.de">Thomas Rfer</a>
*/

#include "TimeInfo.h"

void TimeInfo::reset()
{
  for(int i = 0; i < Stopwatch::numberOfStopwatchEventIDs; ++i)
    reset(Stopwatch::StopwatchEventID(i));
}

void TimeInfo::reset(Stopwatch::StopwatchEventID id)
{
  startTime[id].init();
  endTime[id].init();
  counter[id].init();
  lastReceived[id] = 0;
}

bool TimeInfo::handleMessage(InMessage& message)
{
  if(message.getMessageID() == idStopwatch)
  {
    unsigned long time1, time2, counter1;
    char id;

    message.bin >> id >> time1 >> time2 >> counter1;
    
    if(SystemCall::getTimeSince(lastReceived[id]) > 2000)
      reset(Stopwatch::StopwatchEventID(id));
    startTime[id].add(time1);
    endTime[id].add(time2);
    counter[id].add(counter1);
    lastReceived[id] = SystemCall::getCurrentSystemTime();
    return true;
  }
  else
    return false;
}

bool TimeInfo::getStatistics(Stopwatch::StopwatchEventID id, double& minTime, double& maxTime, double& avgTime, double& freq) const
{
  if(SystemCall::getTimeSince(lastReceived[id]) < 1000 && startTime[id].getNumberOfEntries() > 1)
  {
    int last = startTime[id].getNumberOfEntries() - 1;
    freq = 1000 * double(counter[id][0] - counter[id][last]) / double(startTime[id][0] - startTime[id][last]);
    minTime = maxTime = avgTime = endTime[id][0] - startTime[id][0];
    for(int i = 1; i <= last; ++i)
    {
      unsigned long duration = endTime[id][i] - startTime[id][i];
      if(duration < minTime)
        minTime = duration;
      if(duration > maxTime)
        maxTime = duration;
      avgTime += duration;
    }
    avgTime /= last + 1;
    return true;
  }
  else
    return false;
}

/*
 * Change log :
 * 
 * $Log: TimeInfo.cpp,v $
 * Revision 1.2  2004/04/14 14:50:03  roefer
 * Forget timing if last measurement is older than 2 seconds
 *
 * Revision 1.1  2004/04/09 18:55:16  roefer
 * Better structure for views
 * cp command added
 * Timing view added
 *
 */
