/**
* @file Xabsl2View.h
*
* Declaration of class Xabsl2View
*
* @author <a href="mailto:roefer.tzi.de">Thomas Rfer</a>
*/

#ifndef __Xabsl2View_h_
#define __Xabsl2View_h_

#include "RobotConsole.h"

/**
* @class Xabsl2View 
* 
* A class to represent a view with information about a Xabsl2 behavior.
*
* @author <a href="mailto:roefer.tzi.de">Thomas Rfer</a>
*/
class Xabsl2View : public DirectView
{
  private:
    RobotConsole& console; /**< A reference to the console object. */
    const Xabsl2Info& info; /**< The Xabsl2 info structure. */
    static double leftOfColumnPercent[10]; /**< Ratios for the beginning of the columns. */
    CFont normalFont, /**< Normal font. */
          boldFont; /**< Bold font. */
    CDC* dc; /**< The current device context. */
    int line, /**< A line counter in pixels. */
        width, /**< The width of the view in pixels. */
        lineHeight; /**< The height of a line in pixels. */
  
    /**
    * The function prints a string to a certain column in the view.
    * @param s The string.
    * @param column A column index.
    * @param bold Should the string be printed in boldface?
    */    
    void print(const std::string& s, int column, bool bold = false);

    /**
    * The function sets the print position to the next line.
    * @param drawLine Should a line be drawn between the lines?
    */
    void newLine(bool drawLine = false);

  public:
    /**
    * Constructor.
    * @param c The console object.
    * @param i The Xabs2 info object to be visualized.
    */
    Xabsl2View(RobotConsole& c, const Xabsl2Info& i);

    /**
    * Destructor.
    */
    ~Xabsl2View();

    /**
    * The function is called to draw the view.
    * @param dc The device context to draw to.
    */
    void draw(CDC& dc);
};

#endif //__Xabsl2View_h_

/*
 * Change log :
 * 
 * $Log: Xabsl2View.h,v $
 * Revision 1.3  2003/10/25 11:52:20  roefer
 * Simulator is SimRobXP now
 *
 * Revision 1.2  2003/10/20 14:05:53  roefer
 * Views and buttons
 *
 * Revision 1.1  2003/10/14 07:34:16  roefer
 * Support files for SimRobXP added, not finished yet
 *
 * Revision 1.1  2003/10/07 10:07:00  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1  2003/09/26 11:34:08  juengel
 * no message
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2003/04/03 21:13:25  roefer
 * Xabsl2 view added
 *
 *
 */
