/**
 * @file Platform/Win32/GTAssert.h
 *
 * This file contains macros for low level debugging.
 *
 * @author Thomas Rfer
 */
#ifndef __GTAssert_h_
#define __GTAssert_h_

#include <afx.h>
#include <assert.h>

#undef ASSERT
#undef VERIFY

#ifdef NDEBUG
#define ASSERT(cond) ((void)0)
#define VERIFY(cond) ((void)(cond))
#define PRINT(text) ((void)0)

#else

/**
 * ASSERT prints a message if cond is false and NDEBUG is not defined.
 * ASSERT does not evaluate cond if NDEBUG is defined.
 * Note that printf will not work in early stages of the creation of an Aperios
 * process. Therefore, you will not get any feedback in such a case. If you are
 * not sure whether an assertion failure will be reported at a certain position
 * in the code, try ASSERT(false).
 * @param c The condition to be checked.
 */

#define ASSERT(c) assert(c)

/**
 * VERIFY prints a message if cond is false and NDEBUG is not defined.
 * VERIFY does evaluate cond even if NDEBUG is defined.
 * Note that printf will not work in early stages of the creation of an Aperios
 * process. Therefore, you will not get any feedback in such a case. If you are
 * not sure whether an assertion failure will be reported at a certain position
 * in the code, try ASSERT(false).
 * @param c The condition to be checked.
 */
#define VERIFY(c) assert(c)

/**
 * PRINT prints a text directly to the output if and NDEBUG is not defined.
 * PRINT does not evaluate the parameter if NDEBUG is defined.
 * @param text The text that will be printed.
 */
#define PRINT(text) {OutputDebugString(text); OutputDebugString("\n");}

#endif

#endif //__GTAssert_h_

/*
 * Change log :
 * 
 * $Log: GTAssert.h,v $
 * Revision 1.3  2003/11/30 01:53:18  loetzsch
 * prepared RobotControl port to Visual C++ .Net
 *
 * Revision 1.2  2003/10/25 11:52:20  roefer
 * Simulator is SimRobXP now
 *
 * Revision 1.1  2003/10/07 10:06:59  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/26 11:34:07  juengel
 * no message
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2002/12/18 16:22:55  dueffert
 * doxygen docu corrected
 *
 * Revision 1.1  2002/09/10 15:40:04  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1  2002/07/23 13:35:49  loetzsch
 * - renamed Debugging.h to GTAssert.h
 * - removed #include "Oracle.h" in Win32 version
 *
 * Revision 1.1.1.1  2002/05/10 12:40:18  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.7  2002/01/25 15:40:09  roefer
 * The Oracle
 *
 * Revision 1.6  2002/01/17 15:13:14  roefer
 * Views and debug output in SimGT2002
 *
 * Revision 1.5  2001/12/30 14:48:37  roefer
 * Portable macro PRINT() for direct console output inserted
 *
 * Revision 1.4  2001/12/10 17:47:08  risler
 * change log added
 *
 */
