/**
 * @file Platform/Win32/Robot.cpp
 *
 * This file implements the class Robot.
 *
 * @author <A href=mailto:roefer@tzi.de>Thomas Rfer</A>
 */
#include "Platform/Win32/ForRobotControl/OVirtualRobotComm.h"
#include "Robot.h"

Robot::Robot(const char* name,SIM3DOBJECT obj[5])
: name(name)
{
  for(int j = 0; j < 5; ++j)
    this->obj[j] = obj[j];
  
  // connect additional senders and receivers
  connect(getSender(".Sender.OdometryData.S"),getReceiver("OVirtualRobotComm.Receiver.OdometryData.O"));

  connect(getSender("Debug.Sender.MessageQueue.S"),getReceiver("OVirtualRobotComm.Receiver.MessageQueue.O"));
  connect(getSender("OVirtualRobotComm.Sender.MessageQueue.S"),getReceiver("Debug.Receiver.MessageQueue.O"));

  robotProcess = 0;
  for(ProcessList::Pos i = getFirst(); i && !robotProcess; ++i)
    robotProcess = (OVirtualRobotComm*) (*this)[i].getProcess("OVirtualRobotComm");
  ASSERT(robotProcess);

}

void Robot::update()
{
  robotProcess->update();
}

void Robot::activateSwitch(SensorData::sensors sensor,bool activate)
{
  robotProcess->activateSwitch(sensor,activate);
}

bool Robot::isSwitchActivated(SensorData::sensors sensor) const
{
  return robotProcess->isSwitchActivated(sensor);
}

void Robot::connect(SenderList* sender,ReceiverList* receiver)
{
  if(sender && receiver)
    sender->add(receiver);
}

SenderList* Robot::getSender(const char* senderName)
{
  char name[NAME_LENGTH_MAX];
  for(ProcessList::Pos i = getFirst(); i; ++i)
  {
    if(senderName[0] == '.')
      strcpy(name,(*this)[i].getName());
    else
      name[0] = 0;
    strcat(name,senderName);
    SenderList* sender = (*this)[i].lookupSender(name);
    if(sender)
      return sender;
  }
  OutputDebugString(senderName);
  OutputDebugString(" not found\n");
  return 0;
}

ReceiverList* Robot::getReceiver(const char* receiverName)
{
  for(ProcessList::Pos i = getFirst(); i; ++i)
  {
    ReceiverList* receiver = (*this)[i].lookupReceiver(receiverName);
    if(receiver)
      return receiver;
  }
  OutputDebugString(receiverName);
  OutputDebugString(" not found\n");
  return 0;
}

/*
 * Changelog:
 * 
 * $Log: Robot.cpp,v $
 * Revision 1.2  2003/10/26 08:57:15  roefer
 * Symbol SIMROBXP removed
 *
 * Revision 1.1  2003/10/07 10:06:59  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/26 11:34:07  juengel
 * no message
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.5  2003/04/18 15:21:25  roefer
 * Robot name handling changed
 *
 * Revision 1.4  2002/12/16 14:51:21  dueffert
 * changelog added
 *
 */
