/**
 * @file Platform/Win32/Robot2.cpp
 *
 * This file implements the class Robot.
 *
 * @author <A href=mailto:roefer@tzi.de>Thomas Rfer</A>
 */
#include "ForSimRobXP/OVirtualRobotComm.h"
#include "Robot2.h"

Robot::Robot(const char* name, SimObject* obj, RobotDesign::Design design)
: name(name)
{
  this->obj = obj;
  robotDesign = design;

  // connect additional senders and receivers
  connect(getSender(".Sender.OdometryData.S"),getReceiver("OVirtualRobotComm.Receiver.OdometryData.O"));

  connect(getSender("Debug.Sender.MessageQueue.S"),getReceiver("OVirtualRobotComm.Receiver.MessageQueue.O"));
  connect(getSender("OVirtualRobotComm.Sender.MessageQueue.S"),getReceiver("Debug.Receiver.MessageQueue.O"));

  robotProcess = 0;
  for(ProcessList::Pos i = getFirst(); i && !robotProcess; ++i)
    robotProcess = (OVirtualRobotComm*) (*this)[i].getProcess("OVirtualRobotComm");
  ASSERT(robotProcess);
}

void Robot::update()
{
  robotProcess->update();
}

void Robot::connect(SenderList* sender, ReceiverList* receiver)
{
  if(sender && receiver)
    sender->add(receiver);
}

SenderList* Robot::getSender(const char* senderName)
{
  char name[NAME_LENGTH_MAX];
  for(ProcessList::Pos i = getFirst(); i; ++i)
  {
    if(senderName[0] == '.')
      strcpy(name,(*this)[i].getName());
    else
      name[0] = 0;
    strcat(name,senderName);
    SenderList* sender = (*this)[i].lookupSender(name);
    if(sender)
      return sender;
  }
  OutputDebugString(senderName);
  OutputDebugString(" not found\n");
  return 0;
}

ReceiverList* Robot::getReceiver(const char* receiverName)
{
  for(ProcessList::Pos i = getFirst(); i; ++i)
  {
    ReceiverList* receiver = (*this)[i].lookupReceiver(receiverName);
    if(receiver)
      return receiver;
  }
  OutputDebugString(receiverName);
  OutputDebugString(" not found\n");
  return 0;
}

/*
 * Changelog:
 * 
 * $Log: Robot2.cpp,v $
 * Revision 1.4  2004/03/10 23:55:28  roefer
 * ERS7 support for log files
 *
 * Revision 1.3  2004/01/17 19:19:18  roefer
 * Simulator calculates robot pose based on class Kinematics now
 *
 * Revision 1.2  2003/10/20 14:05:53  roefer
 * Views and buttons
 *
 * Revision 1.1  2003/10/14 07:34:16  roefer
 * Support files for SimRobXP added, not finished yet
 *
 */
