/**
 * @file Platform/Win32/RouterCtrl.cpp
 *
 * This file implements the class RouterCtrl.
 *
 * @author <A href=mailto:roefer@tzi.de>Thomas Rfer</A>
 */
#include "RouterCtrl.h"
#include "File.h"

void RouterCtrl::start(const char* params)
{
  char command[200];
  sprintf(command,"bash.exe %s/Bin/start.bash ",File::getGTDir());
  ASSERT(strlen(command) + strlen(params) < sizeof(command));
  strcat(command,params);

  hRouter = NULL;
  HANDLE hWriteToParent = NULL;
  HANDLE hWriteToParent2 = NULL;
  SECURITY_ATTRIBUTES sa = 
  {
    sizeof(SECURITY_ATTRIBUTES),
    NULL,
    TRUE
  };

  VERIFY(CreatePipe(&hRouter,&hWriteToParent,&sa,0));
  VERIFY(DuplicateHandle(GetCurrentProcess(),hWriteToParent,GetCurrentProcess(),
                         &hWriteToParent2,0,TRUE,DUPLICATE_SAME_ACCESS));

  STARTUPINFO startup;
  PROCESS_INFORMATION procinfo;
  ZeroMemory(&startup,sizeof(startup));
  startup.cb = sizeof(startup);
  startup.dwFlags = STARTF_USESHOWWINDOW | STARTF_USESTDHANDLES;
  startup.wShowWindow = SW_HIDE; // hidden console window
  startup.hStdInput = NULL; // not used
  startup.hStdOutput = hWriteToParent;
  startup.hStdError = hWriteToParent2;
  VERIFY(DuplicateHandle(GetCurrentProcess(),hRouter,GetCurrentProcess(),
                         NULL,0,FALSE,DUPLICATE_SAME_ACCESS));
  VERIFY(CreateProcess(NULL,command,NULL,NULL,TRUE,0,NULL,NULL,&startup,&procinfo));

  CloseHandle(hWriteToParent);
  CloseHandle(hWriteToParent2);
     
  Thread<RouterCtrl>::start(this,main);
}

void RouterCtrl::stop()
{
  if(isRunning())
  {
  	char s[1024];
  	sprintf(s,"bash.exe %s/Bin/stop.bash",File::getGTDir());
    WinExec(s,SW_HIDE);
    Thread<RouterCtrl>::stop();
  }
}

void RouterCtrl::main()
{
  char buffer[1000],
       line[1000];
  DWORD bytesRead;
  *line = 0;

  while(::ReadFile(hRouter,buffer,sizeof(buffer) - 1,&bytesRead,NULL) && bytesRead)
	{
    buffer[bytesRead] = 0;
    char* p = buffer;
    bool endOfBuffer;
    do
    {
      // run up to end of buffer or end of line
      char* p2 = p;
      while(*p2 && *p2 != '\n')
        ++p2;

      endOfBuffer = !*p2; // remember whether it was the end of buffer

      // terminate string and add string to line
      *p2 = 0;
      ASSERT(strlen(line) + strlen(p) < sizeof(line));
      strcat(line,p);

      if(!endOfBuffer)
      { 
        // remove '\r'
        if(*line && line[strlen(line) - 1] == '\r')
          line[strlen(line) - 1] = 0;
        onLineReceived(line); // add line
        *line = 0; // empty line buffer
        p = p2 + 1; // advance pointer behind string
      }
    }
    while(!endOfBuffer);
	}

  if(*line)
  {
    // remove '\r'
    if(line[strlen(line) - 1] == '\r')
      line[strlen(line) - 1] = 0;
    onLineReceived(line); // add line
  }

  CloseHandle(hRouter);
}

/*
 * Change log :
 *
 * $Log: RouterCtrl.cpp,v $
 * Revision 1.2  2003/10/25 11:52:20  roefer
 * Simulator is SimRobXP now
 *
 * Revision 1.1  2003/10/07 10:06:59  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.6  2003/04/16 07:00:16  roefer
 * Bremen GO checkin
 *
 * Revision 1.6  2003/04/08 19:11:28  roefer
 * Errors in starting router from SimGT2003 corrected
 *
 * Revision 1.5  2002/11/21 16:08:39  dueffert
 * doxygen comments corrected
 *
 * Revision 1.4  2002/11/20 13:37:30  dueffert
 * missing or wrong doxygen file corrected
 *
 * Revision 1.3  2002/11/18 17:32:35  dueffert
 * RobotControl should be startable in any path now
 *
 * Revision 1.2  2002/09/18 06:29:27  roefer
 * 2002 -> 2003
 *
 * Revision 1.1  2002/09/10 15:40:05  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1  2002/08/01 12:52:26  roefer
 * RouterCtrl and TcpConnection added
 *
 *
 */
