/** 
* @file Logger.h
* 
* Declaration of class Logger.
*
* @author Max Risler
*/

#ifndef __Logger_h_
#define __Logger_h_

#include "Tools/Process.h"
#include "Tools/Debugging/QueueFillRequest.h"

#include "Platform/Sensors.h"

/**
* @class Logger
* 
* A process for logging sensor data.
*
* Messages from the PC are processed and sensor data can be sent to the PC or saved
* to the stick.
*
* @author Max Risler
*/
class Logger : public Process, public Sensors
{
private:
  DEBUGGING;
  RECEIVER(SensorDataBuffer);

public:
  /** Constructor */
  Logger();

  /** Destructor */
  ~Logger();
  
  /** The main function of the process */
  int main();

  /** Is called before the first main() */
  virtual void init();

  /** 
  * Is called for every incoming debug message.
  * @param message the message to handle
  * @return if the message was handled
  */
  virtual bool handleMessage(InMessage& message);

  /**
  * The QueueFillMode for the outgoing Queue
  */
  QueueFillRequest::QueueFillMode mode;
	
  /**
  * The time when the outgoing queue is written to the stick or allowed to be accessed via wlan
  */
  unsigned long saveOrSendTime;

private:
  /**
  * this is used to read messages from a file called requests.dat
  */
  InBinaryFile* fin;

  /** If true, a message was received from the WLan or OVirtualRobotComm */
  bool messageWasReceived;
};

#endif // __Logger_h_

/*
 * Change log :
 * 
 * $Log: Logger.h,v $
 * Revision 1.1  2003/10/07 10:07:01  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/26 11:41:17  juengel
 * - sorted tools
 * - clean-up in DataTypes
 *
 * Revision 1.1  2003/07/24 13:33:15  risler
 * new process logger
 *
 */
