/**
* @file PackageCognitionMotion.cpp
*
* Implementation of class PackageCognitionMotion.
*
* @author Matthias Jngel
*/

#include "PackageCognitionMotion.h"

PackageCognitionMotion::PackageCognitionMotion()
: teamColor(getPlayer().getTeamColor()),walkParameterTimeStamp(0),wLanStatus(0),timeStamp(0)
{
  ERS7WalkingParameters p;
  invKinWalkingParameters = p;
  udParameters = p;
}

In& operator>>(In& stream, PackageCognitionMotion& packageCognitionMotion)
{
  int teamColor;
  stream
    >> packageCognitionMotion.landmarksState
    >> packageCognitionMotion.robotPose
    >> packageCognitionMotion.ballModel
    >> packageCognitionMotion.playerPoseCollection
    >> packageCognitionMotion.robotState
    >> packageCognitionMotion.motionRequest
    >> packageCognitionMotion.headControlMode
    >> packageCognitionMotion.ledRequest
    >> packageCognitionMotion.soundRequest
    >> teamColor
    >> packageCognitionMotion.invKinWalkingParameters
    >> packageCognitionMotion.udParameters
    >> packageCognitionMotion.walkParameterTimeStamp
    >> packageCognitionMotion.wLanStatus
    >> packageCognitionMotion.timeStamp
    >> packageCognitionMotion.specialPercept;
  packageCognitionMotion.teamColor = (Player::teamColor) teamColor;
  return stream;
}

Out& operator<<(Out& stream, const PackageCognitionMotion& packageCognitionMotion)
{
  stream 
    << packageCognitionMotion.landmarksState
    << packageCognitionMotion.robotPose
    << packageCognitionMotion.ballModel
    << packageCognitionMotion.playerPoseCollection
    << packageCognitionMotion.robotState
    << packageCognitionMotion.motionRequest
    << packageCognitionMotion.headControlMode
    << packageCognitionMotion.ledRequest
    << packageCognitionMotion.soundRequest
    << (int) packageCognitionMotion.teamColor
    << packageCognitionMotion.invKinWalkingParameters
    << packageCognitionMotion.udParameters
    << packageCognitionMotion.walkParameterTimeStamp
    << packageCognitionMotion.wLanStatus
    << packageCognitionMotion.timeStamp
    << packageCognitionMotion.specialPercept;


  return stream;
}

/*
* Change Log:
*
* $Log: PackageCognitionMotion.cpp,v $
* Revision 1.14  2004/06/20 15:51:28  dueffert
* backport to fix initialization bug
*
* Revision 1.13  2004/06/03 16:10:53  kerdels
* added new headcontrolmode
*
* Revision 1.12  2004/05/24 19:40:06  goehring
* ballPosition to ballModel renamed
*
* Revision 1.11  2004/05/14 14:12:08  wachter
* - Added communication support for 5 robots
* - rewrote parts of team-communication to be faster and more stable
*
* Revision 1.10  2004/04/11 18:49:45  roefer
* Team color is sent again from Cognition to Motion.
* Otherwise, messages sent by Motion may contain the wrong team color.
*
* Revision 1.9  2004/04/07 13:00:47  risler
* ddd checkin after go04 - second part
*
* Revision 1.2  2004/04/01 19:52:44  Charlie
* added LandmarkState
*
* Revision 1.1.1.1  2004/03/29 08:28:46  Administrator
* initial transfer from tamara
*
* Revision 1.8  2004/03/30 11:48:51  dueffert
* memory hole fixed
*
* Revision 1.7  2004/03/27 14:45:08  loetzsch
* removed team color from PackageCognitionMotion
*
* Revision 1.6  2004/03/10 12:17:50  roefer
* Player bug fixed
*
* Revision 1.5  2004/03/08 15:29:11  tim
* Sending the Player object to the Motion process
*
* Revision 1.4  2004/03/04 10:05:28  jhoffman
* - motion process now uses odometry to propagate the robot pose while no new robot pose is being sent (this makes headcontrol a little better)
* - removed headcontrol member variable "propagatedPose" from headcontrol and cognition->motion-sender
*
* Revision 1.3  2004/02/16 17:57:43  dueffert
* packageCognitionMotion extended with invkin parameters
*
* Revision 1.2  2003/11/24 15:31:20  dueffert
* SpecialPercept removed from PackageCognition
*
* Revision 1.1  2003/10/07 10:07:01  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.5  2003/06/15 22:42:22  loetzsch
* no message
*
* Revision 1.4  2002/11/28 14:44:04  jhoffman
* added a special percept for the motion detector
*
* Revision 1.3  2002/10/02 13:31:16  loetzsch
* now all elements are streamed
*
* Revision 1.2  2002/09/17 23:55:22  loetzsch
* - unraveled several datatypes
* - changed the WATCH macro
* - completed the process restructuring
*
* Revision 1.1  2002/09/12 14:20:05  juengel
* Created a package for all data sent from Cognition to Motion.
*
*
*/
