/**
* @file PackageCognitionMotion.h
*
* Definition of class PackageCognitionMotion.
*
* @author Matthias Jngel
*/

#ifndef __PackageCognitionMotion_h_
#define __PackageCognitionMotion_h_

#include "Representations/Cognition/LandmarksState.h"
#include "Representations/Cognition/RobotPose.h"
#include "Representations/Cognition/BallModel.h"
#include "Representations/Cognition/PlayerPoseCollection.h"
#include "Representations/Cognition/ObstaclesModel.h"
#include "Representations/Cognition/RobotState.h"
#include "Representations/Motion/MotionRequest.h"
#include "Representations/Motion/HeadControlMode.h"
#include "Representations/Motion/LEDRequest.h"
#include "Representations/Motion/OdometryData.h"
#include "Representations/Sound/SoundRequest.h"
#include "Representations/Perception/SpecialPercept.h"
#include "Tools/Player.h"

#include "Modules/WalkingEngine/InvKinWalkingParameterSets.h"
#include "Modules/WalkingEngine/UDParameterSet.h"

/**
* @class PackageCognitionMotion
*
* Contains all data that are sent from the Cognition process to the Motion process
* in the CMD process layout.
*
* @author Matthias Jngel
*/
class PackageCognitionMotion
{
public:
  /** The seen landmarks */
  LandmarksState landmarksState;

  /** The robots position and orientation */
  RobotPose robotPose;
  
  /** The position and the speed of the ball */
  BallModel ballModel;
  
  /** The positions of the own and opponent players */
  PlayerPoseCollection playerPoseCollection;
  
  /** The positions of the obstacles */
  ObstaclesModel obstaclesModel;

  /** Pressed switches and fall downs */
  RobotState robotState;
  
  /** Motions requested by the behavior */
  MotionRequest motionRequest;

  /** The head control mode*/
  HeadControlMode headControlMode;
  
  /** The ledRequest*/
  LEDRequest ledRequest;
  
  /** The SoundRequest */
  SoundRequest soundRequest;

  /** An instance of the current player object*/
  Player::teamColor teamColor;

  /** The SpecialPercept - needed for the OpenChallenge 2004 */
  SpecialPercept specialPercept;

  /** walking parameter sets to be used by the WalkingEngine, eg calculated by evolution behavior */
  InvKinWalkingParameters invKinWalkingParameters;
  UDParameters udParameters;
  unsigned long walkParameterTimeStamp;

  /** The status of the WLan connection (one bit for every dog) */
  int wLanStatus;
  
  /** The time when the package was sent */
  unsigned long timeStamp;

  /** Constructor */
  PackageCognitionMotion();
};

/**
* Streaming operator that reads a PackageCognitionMotion from a stream.
* @param stream The stream from which is read.
* @param packageCognitionMotion The PackageCognitionMotion object.
* @return The stream.
*/ 
In& operator>>(In& stream, PackageCognitionMotion& packageCognitionMotion);

/**
* Streaming operator that writes a PackageCognitionMotion to a stream.
* @param stream The stream to write on.
* @param packageCognitionMotion The PackageCognitionMotion object.
* @return The stream.
*/ 
Out& operator<<(Out& stream, const PackageCognitionMotion& packageCognitionMotion);


#endif //__PackageCognitionMotion_h_

/*
* Change Log:
*
* $Log: PackageCognitionMotion.h,v $
* Revision 1.15  2004/06/03 16:10:53  kerdels
* added new headcontrolmode
*
* Revision 1.14  2004/05/24 19:40:06  goehring
* ballPosition to ballModel renamed
*
* Revision 1.13  2004/05/14 14:12:08  wachter
* - Added communication support for 5 robots
* - rewrote parts of team-communication to be faster and more stable
*
* Revision 1.12  2004/04/11 18:49:45  roefer
* Team color is sent again from Cognition to Motion.
* Otherwise, messages sent by Motion may contain the wrong team color.
*
* Revision 1.11  2004/04/07 14:42:56  risler
* moved LandsmarksState to Cognition directory, generated by SelfLocator
*
* Revision 1.10  2004/04/07 13:00:47  risler
* ddd checkin after go04 - second part
*
* Revision 1.2  2004/04/01 19:52:44  Charlie
* added LandmarkState
*
* Revision 1.1.1.1  2004/03/29 08:28:46  Administrator
* initial transfer from tamara
*
* Revision 1.9  2004/03/27 14:45:08  loetzsch
* removed team color from PackageCognitionMotion
*
* Revision 1.8  2004/03/16 10:26:16  dueffert
* invKinWalkingParameters in package initialized
*
* Revision 1.7  2004/03/10 12:17:50  roefer
* Player bug fixed
*
* Revision 1.6  2004/03/08 15:29:11  tim
* Sending the Player object to the Motion process
*
* Revision 1.5  2004/03/04 10:05:28  jhoffman
* - motion process now uses odometry to propagate the robot pose while no new robot pose is being sent (this makes headcontrol a little better)
* - removed headcontrol member variable "propagatedPose" from headcontrol and cognition->motion-sender
*
* Revision 1.4  2004/02/16 17:57:43  dueffert
* packageCognitionMotion extended with invkin parameters
*
* Revision 1.3  2004/02/03 13:19:49  spranger
* renamed all references to  class BallPosition to BallModel
*
* Revision 1.2  2003/11/24 21:03:37  loetzsch
* removed specialPercept
*
* Revision 1.1  2003/10/07 10:07:01  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/09/26 15:30:39  juengel
* Renamed DataTypes to representations.
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.5  2003/06/15 22:42:22  loetzsch
* no message
*
* Revision 1.4  2003/03/10 13:59:48  juengel
* Added obstaclesModel
*
* Revision 1.3  2002/11/28 14:44:04  jhoffman
* added a special percept for the motion detector
*
* Revision 1.2  2002/09/17 23:55:22  loetzsch
* - unraveled several datatypes
* - changed the WATCH macro
* - completed the process restructuring
*
* Revision 1.1  2002/09/12 14:20:05  juengel
* Created a package for all data sent from Cognition to Motion.
*
*
*/
