/**
 * @file RobotState.cpp
 *
 * Implementation of class RobotState.
 */

#include "RobotState.h"

RobotState::RobotState()
{
  state = undefined;
  switches = nothingPressed;
  switchDuration = 0;
  
  collisionFrontLeft = false;
  collisionFrontRight = false;
  collisionHindLeft = false;
  collisionHindRight = false;
  collisionHead = false;
  collisionAggregate = false;

  consecutiveCollisionTimeFrontLeft = 0;
  consecutiveCollisionTimeFrontRight = 0;
  consecutiveCollisionTimeHindLeft = 0;
  consecutiveCollisionTimeHindRight = 0;
  consecutiveCollisionTimeHead = 0;
  consecutiveCollisionTimeAggregate = 0;
  
  acceleration = Vector3<double>(0,0,0);
}

RobotState::~RobotState()
{
}

void RobotState::operator=(const RobotState& other)
{
  state = other.state;
}

In& operator>>(In& stream,RobotState& robotState)
{
  stream >> robotState.frameNumber;
  stream.read(&robotState,sizeof(RobotState));
  return stream;
}

Out& operator<<(Out& stream, const RobotState& robotState)
{
  stream << robotState.frameNumber;
  stream.write(&robotState,sizeof(RobotState));
  return stream;
}

/*
 * Change log :
 * 
 * $Log: RobotState.cpp,v $
 * Revision 1.3  2004/02/10 11:12:08  dueffert
 * acceleration added; frameNumber is unsigned long everywhere
 *
 * Revision 1.2  2003/11/14 19:02:25  goehring
 * frameNumber added
 *
 * Revision 1.1  2003/10/07 10:07:01  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2003/06/20 10:31:59  goehring
 * Added CollisionStates
 *
 * Revision 1.1  2002/09/10 15:26:39  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.6  2002/04/06 02:29:26  loetzsch
 * added switchDuration = 0; to the constructor
 *
 * Revision 1.5  2002/03/28 15:19:20  risler
 * implemented switch messages in RobotStateDetector
 *
 * Revision 1.4  2002/02/23 16:37:15  risler
 * State in RobotState like BodyPercept state
 *
 * Revision 1.3  2001/12/10 17:47:06  risler
 * change log added
 *
 */
