/**
 * @file HeadMotionRequest.cpp
 * 
 * Based on old implementation of HeadMotionRequestStruct from GT2001
 *
 * Implementation of class HeadMotionRequest
 * Stores MotionRequests for the Head 
 * 
 * @author Matthias Juengel
 * @author Nils Koschmieder
 */ 

#include "Tools/Streams/InOut.h"
#include "HeadMotionRequest.h"

HeadMotionRequest::HeadMotionRequest() : tilt(0), pan(0), roll(0), mouth(0)
{
}

HeadMotionRequest::~HeadMotionRequest()
{
}


In& operator>>(In& stream,HeadMotionRequest& headMotionRequest)
{
  stream >> headMotionRequest.tilt 
    >> headMotionRequest.pan 
    >> headMotionRequest.roll
    >> headMotionRequest.mouth;
  return stream;
}

Out& operator<<(Out& stream,const HeadMotionRequest& headMotionRequest)
{
  stream << headMotionRequest.tilt 
    << headMotionRequest.pan 
    << headMotionRequest.roll
    << headMotionRequest.mouth;
  return stream;
}


/*
 * Change log :
 * 
 * $Log: HeadMotionRequest.cpp,v $
 * Revision 1.1  2003/10/07 10:07:01  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2003/04/01 17:43:37  roefer
 * Mouth added to HeadMotionRequest
 *
 * Revision 1.1  2002/09/10 15:26:40  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.2  2002/08/30 13:33:05  dueffert
 * removed unused includes
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.6  2001/12/10 17:47:05  risler
 * change log added
 *
 */
