/**
 * @file HeadMotionRequest.h
 * 
 * Declaration of class HeadMotionRequest
 * 
 * @author Matthias Juengel
 * @author Martin Ltzsch
 * @author Nils Koschmieder
 */ 

#ifndef __HeadMotionRequest_h_
#define __HeadMotionRequest_h_

#include "Tools/Streams/InOut.h"

/** 
* @class HeadMotionRequest 
*
* Represents a motion request for the head.
*/
class HeadMotionRequest
{
public:
  /** requested head joint angles */
  signed long tilt,pan,roll,mouth;

  /** constructor */
  HeadMotionRequest();

  /** destructor */
  ~HeadMotionRequest();

  /** copies another HeadMotionRequest to this one */
  void operator=(HeadMotionRequest& other);
};


/**
 * Streaming operator that reads a HeadMotionRequest from a stream.
 * @param stream The stream from which is read.
 * @param headMotionRequest The HeadMotionRequest object.
 * @return The stream.
 */ 
In& operator>>(In& stream,HeadMotionRequest& headMotionRequest);
 
/**
 * Streaming operator that writes a HeadMotionRequest to a stream.
 * @param stream The stream to write on.
 * @param headMotionRequest The HeadMotionRequest object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const HeadMotionRequest& headMotionRequest);



#endif //__HeadMotionRequest_h_

/*
 * Change log :
 * 
 * $Log: HeadMotionRequest.h,v $
 * Revision 1.1  2003/10/07 10:07:01  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2003/04/01 17:43:37  roefer
 * Mouth added to HeadMotionRequest
 *
 * Revision 1.1  2002/09/10 15:26:40  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.2  2002/07/23 13:32:57  loetzsch
 * new streaming classes
 *
 * removed many #include statements
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.6  2001/12/10 17:47:05  risler
 * change log added
 *
 */
