/**
 * @file HeadState.cpp
 * 
 * Implementation of class HeadState
 *
 * @author <A href=mailto:dueffert@informatik.hu-berlin.de>Uwe Dffert</A>
 * Implementation of the HeadState class
 */ 

#include "HeadState.h"

HeadState::HeadState()
: neckHeight(165), 
  bodyTilt(0),
  bodyRoll(0),
  stableMotion(true),
  headBlocked(false),
  calculated(false)
{
}

HeadState::~HeadState()
{
}

In& operator>>(In& stream,HeadState& headState)
{
  stream.read(&headState,sizeof(HeadState));
  return stream;
}
 
Out& operator<<(Out& stream, const HeadState& headState)
{
  stream.write(&headState,sizeof(HeadState));
  return stream;
}


/*
 * Change log :
 * 
 * $Log: HeadState.cpp,v $
 * Revision 1.2  2004/03/20 09:55:27  roefer
 * Preparation for improved odometry
 *
 * Revision 1.1  2003/10/07 10:07:01  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2002/11/19 15:43:02  dueffert
 * doxygen comments corrected
 *
 * Revision 1.1  2002/09/10 15:26:40  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.1  2002/04/23 14:08:03  risler
 * renamed headOdometry to headState
 *
 * Revision 1.3  2002/04/18 10:25:31  roefer
 * Bremen GO
 *
 * Revision 1.2  2001/12/01 21:21:59  roefer
 * HeadOdometry used in simulation
 *
 * Revision 1.2  2002/04/08 17:49:40  risler
 * removed body tilt from odometry
 *
 * Revision 1.1  2002/04/02 13:10:18  dueffert
 * big change: odometryData and cameraMatrix in image now, old logfiles may be obsolete
 *
 * 
 */
