/**
* @file JointData.cpp
*
* Implementation of class JointData
* 
* @author Martin Ltzsch
* @author Max Risler
*/

#include "JointData.h"
#include <string.h>

JointData::JointData(
    long headTiltValue,
    long headPanValue,
    long headRollValue,
    long mouthValue,
    long earLValue, 
    long earRValue,
    long legFR1Value,
    long legFR2Value,
    long legFR3Value,
    long legFL1Value,
    long legFL2Value,
    long legFL3Value,
    long legHR1Value,
    long legHR2Value,
    long legHR3Value,
    long legHL1Value,
    long legHL2Value,
    long legHL3Value,
    long tailPanValue,
    long tailTiltValue
  )
{
  data[headTilt] = headTiltValue;
  data[headPan] = headPanValue;
  data[headRoll] = headRollValue;
  data[mouth] = mouthValue;
  data[earL] = earLValue; 
  data[earR] = earRValue;
  data[legFR1] = legFR1Value;
  data[legFR2] = legFR2Value;
  data[legFR3] = legFR3Value;
  data[legFL1] = legFL1Value;
  data[legFL2] = legFL2Value;
  data[legFL3] = legFL3Value;
  data[legHR1] = legHR1Value;
  data[legHR2] = legHR2Value;
  data[legHR3] = legHR3Value;
  data[legHL1] = legHL1Value;
  data[legHL2] = legHL2Value;
  data[legHL3] = legHL3Value;
  data[tailPan] = tailPanValue;
  data[tailTilt] = tailTiltValue;
}

JointData& JointData::operator=(const JointData& other)
{
  for (int i = 0; i < numOfJoint; i++)
    data[i] = other.data[i];
  return *this;
}

JointData::JointData(const JointData& other)
{
  *this = other;
}

JointData::JointID JointData::getIDFromName(const char* jointName)
{
  if(strcmp(jointName, "headTilt") == 0 || strcmp(jointName, "headTilt1") == 0)
    return headTilt;
  else if(strcmp(jointName, "headRoll") == 0 || strcmp(jointName, "headTilt2") == 0)
    return headRoll;
  else
  {
    for (int i=0;i<JointData::numOfJoint;i++)
      if (strcmp(jointName,getJointName((JointID)i))==0)
        return (JointID)i;
    return numOfJoint;
  }
}

In& operator>>(In& stream,JointData& jointData)
{
  stream.read(jointData.data,sizeof(jointData.data));
  return stream;
}
 
Out& operator<<(Out& stream, const JointData& jointData)
{
  stream.write(jointData.data,sizeof(jointData.data));
  return stream;
}

/*
 * Change log :
 * 
 * $Log: JointData.cpp,v $
 * Revision 1.4  2004/02/02 13:01:08  dueffert
 * GreenHills compatibility restored
 *
 * Revision 1.3  2003/12/31 16:58:44  roefer
 * Joints and LEDs for ERS-7
 *
 * Revision 1.2  2003/12/16 18:52:55  loetzsch
 * added a function for retrieving the id for as string.
 *
 * Revision 1.1  2003/10/07 10:07:01  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2002/09/10 15:26:40  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.1.1.1  2002/05/10 12:40:13  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.4  2002/02/21 18:02:13  risler
 * now thats a constructor
 *
 * Revision 1.3  2001/12/10 17:47:05  risler
 * change log added
 *
 */
