/** 
* @file CameraParameters.cpp
* Implementation of class CameraParameters.
*
* @author <A href=mailto:bach@informatik.hu-berlin.de>Joscha Bach</A>
*/

#include "Tools/Streams/InOut.h"
#include "CameraParameters.h"

CameraParameters::CameraParameters():theWhiteBalance(wb_fl_mode), 
                                     theGain(gain_mid),
                                     theShutterSpeed(shutter_fast) {}

In& operator>>(In& stream,CameraParameters& cameraParameters)
{
  int whiteBalance;
  int shutterSpeed;
  int gain;

  stream >> whiteBalance >> shutterSpeed >> gain;
  
  cameraParameters.theWhiteBalance = (CameraParameters::whiteBalance)whiteBalance;
  cameraParameters.theShutterSpeed = (CameraParameters::shutterSpeed)shutterSpeed;
  cameraParameters.theGain = (CameraParameters::gain)gain;

  return stream;
}

Out& operator<<(Out& stream, const CameraParameters& cameraParameters)
{
  stream << (int) cameraParameters.theWhiteBalance <<
            (int) cameraParameters.theShutterSpeed <<
            (int) cameraParameters.theGain;
  return stream;
}

/*
 * Changelog:
 * 
 * $Log: CameraParameters.cpp,v $
 * Revision 1.1  2003/10/07 10:09:36  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2003/03/06 11:07:15  dueffert
 * re-order warning removed
 *
 * Revision 1.2  2002/12/16 14:54:03  dueffert
 * changelog added
 *
 */
