/** 
* @file CameraParameters.h
* Declaration of class CameraParameters.
*
* @author <A href=mailto:bach@informatik.hu-berlin.de>Joscha Bach</A>
*/

#ifndef _CameraParameters_h_
#define _CameraParameters_h_

#include "Tools/Streams/InOut.h"


/**
* @class CameraParameters
* Adjust parameters for built-in camera of Sony robot
*
* @author Joscha Bach
*/
class CameraParameters
{
public:
CameraParameters();
  
  enum whiteBalance
  {
    wb_indoor_mode, wb_outdoor_mode, wb_fl_mode
  };
 /**
  * Returns a description for an indexed whiteBalance.
  */
  static const char* getWhiteBalanceName(whiteBalance whiteBalance)
  {
    switch (whiteBalance) 
    {
    case wb_indoor_mode: return "wb_indoor_mode";
    case wb_fl_mode: return "wb_fl_mode";
    case wb_outdoor_mode: return "wb_outdoor_mode";
    default: return "check available WhiteBalance types";
    }
  }  
  static const char* getShortWhiteBalanceName(whiteBalance whiteBalance)
  {
    switch (whiteBalance) 
    {
    case wb_indoor_mode: return "indoor";
    case wb_fl_mode: return "fluorescent";
    case wb_outdoor_mode: return "outdoor";
    default: return "check available WhiteBalance types";
    }
  }  
  enum gain
  {
    gain_low, gain_mid, gain_high
  };
   /**
  * Returns a description for an indexed gain.
  */
  static const char* getGainName(gain gain)
  {
    switch (gain) 
    {
    case gain_low: return "gain_low";
    case gain_mid: return "gain_mid";
    case gain_high: return "gain_high";
    default: return "check available gain types";
    }
  }  
  static const char* getShortGainName(gain gain)
  {
    switch (gain) 
    {
    case gain_low: return "low";
    case gain_mid: return "mid";
    case gain_high: return "high";
    default: return "check available gain types";
    }
  }  

  enum shutterSpeed
  {
    shutter_slow, shutter_mid, shutter_fast
  };
   /**
  * Returns a description for an indexed shutterSpeed.
  */
  static const char* getShutterSpeedName(shutterSpeed shutterSpeed)
  {
    switch (shutterSpeed) 
    {
    case shutter_slow: return "shutter_slow";
    case shutter_mid: return "shutter_mid";
    case shutter_fast: return "shutter_fast";
    default: return "check available shutterSpeed types";
    }
  }  
  static const char* getShortShutterSpeedName(shutterSpeed shutterSpeed)
  {
    switch (shutterSpeed) 
    {
    case shutter_slow: return "slow";
    case shutter_mid: return "mid";
    case shutter_fast: return "fast";
    default: return "check available shutterSpeed types";
    }
  }  

  whiteBalance theWhiteBalance;
  gain theGain;
  shutterSpeed theShutterSpeed;
};

/**
 * Streaming operator that reads CameraParameters from a stream.
 * @param stream The stream from which is read.
 * @param cameraParameters The CameraParameters object.
 * @return The stream.
 */ 
In& operator>>(In& stream,CameraParameters& cameraParameters);
 
/**
 * Streaming operator that writes CameraParameters to a stream.
 * @param stream The stream to write on.
 * @param cameraParameters The CameraParameters object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const CameraParameters& cameraParameters);




#endif   //  _CameraParameters_h_

/*
 * Changelog:
 * 
 * $Log: CameraParameters.h,v $
 * Revision 1.2  2004/02/23 15:29:45  jhoffman
 * bug removed
 *
 * Revision 1.1  2003/10/07 10:09:36  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2002/12/16 14:54:03  dueffert
 * changelog added
 *
 */
