/**
* @file ColorClassImage.h
*
* Declaration of class ColorClassImage
*
* @author Martin Ltzsch
*/

#ifndef __ColorClassImage_h_
#define __ColorClassImage_h_

#include "Tools/ColorClasses.h"
#include "Tools/Streams/InOut.h"

#include "Image.h"

/**
* Represents a color segmented image. This doesn't have to be used by
* image processors, because they might be faster without generating a 
* representation like ColorClassImage, but it is needed for visualizing
* how color tables segment images.
*
* @author Martin Ltzsch
*/
class ColorClassImage
{
public:
  /** Constructor */
  ColorClassImage();

  unsigned char getClassifiedColorAGILO(unsigned long index);

  void convertToImage(Image& image);

  /** A bitmap containing the color class for every pixel in the orignial image */
  unsigned char image[cameraResolutionHeight_ERS7 * 2][cameraResolutionWidth_ERS7 * 2];

  /** the height of the image */
  int height;

  /**  the width of the image  */
  int width;
};

/**
 * Streaming operator that writes a ColorClassImage to a stream.
 * @param stream The stream to write on.
 * @param colorClassImage The ColorClassImage object.
 * @return The stream.
 */ 
Out& operator << (Out& stream, const ColorClassImage& colorClassImage);

/**
 * Streaming operator that reads a ColorClassImage from a stream.
 * @param stream The stream from which is read.
 * @param colorClassImage The ColorClassImage object.
 * @return The stream.
 */ 
In& operator>>(In& stream,ColorClassImage& colorClassImage);


#endif //__ColorClassImage_h_

/*
* $Log: ColorClassImage.h,v $
* Revision 1.3  2004/04/07 13:00:44  risler
* ddd checkin after go04 - second part
*
* Revision 1.2  2004/04/02 14:46:18  risler
* added segmented high resolution image
* colortable dialog supports high resolution images
*
* Revision 1.1.1.1  2004/03/29 08:28:45  Administrator
* initial transfer from tamara
*
* Revision 1.2  2003/12/30 23:55:01  roefer
* Image size is now 208 x 160. Smaller images are placed in the upper left corner
*
* Revision 1.1  2003/10/07 10:09:36  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/07/21 13:42:47  juengel
* Added convertToImage
*
* Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.3  2003/01/09 14:11:05  jhoffman
* added some stuff needed for ISL
*
* Revision 1.2  2002/09/20 23:28:34  juengel
* Moved instance of DebugDrawingManager to RobotControlMainFrame.
*
* Revision 1.1  2002/09/10 15:26:40  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed Challenge Code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
*/
