/** 
* @file ColorTable.h
* Declaration of class ColorTable.
*
* @author <A href=mailto:robocup@andreosterhues.de>Andr Osterhues</A>
*/

#ifndef _ColorTable_h_
#define _ColorTable_h_

// forward declaration
class ColorTable;
class ColorClassImage;

#include "Image.h"
#include "ColorClassImage.h"

/**
* @class ColorTable
*
* Base class of ColorTable64 and ColorTableTSL.
*/
class ColorTable
{
public:
  /** Constructor */
    ColorTable() {}

  /** Destructor */
  ~ColorTable() {}

  /** 
  * Calculates the color class of a pixel.
  * @param y the y value of the pixel
  * @param u the u value of the pixel
  * @param v the v value of the pixel
  * @return the color class
  */
  virtual colorClass getColorClass(
    const unsigned char y, 
    const unsigned char u, 
    const unsigned char v) const {return noColor;}

  /**
  * Segments an image to an color class image.
  * 
  * This doesn't need to used in the image processor, but is needed for visualisation
  * of color tables.
  * @param image A reference to the image to be segmented
  * @param colorClassImage A reference to the color class image to be created
  * @return A reference to the created color class image.
  */
  virtual void generateColorClassImage(
    const Image& image, 
    ColorClassImage& colorClassImage) const
    {}

  /**
  * Segments an image to an color class image using the high resolution y values.
  * 
  * This doesn't need to used in the image processor, but is needed for visualisation
  * of color tables.
  * @param image A reference to the image to be segmented
  * @param colorClassImage A reference to the color class image to be created
  * @return A reference to the created color class image.
  */
  virtual void generateHighResColorClassImage(
    const Image& image, 
    ColorClassImage& colorClassImage) const
    {}
};

#endif   //  _ColorTable_h_

/*
 * Change log :
 * 
 * $Log: ColorTable.h,v $
 * Revision 1.3  2004/04/07 13:00:44  risler
 * ddd checkin after go04 - second part
 *
 * Revision 1.2  2004/04/02 14:46:18  risler
 * added segmented high resolution image
 * colortable dialog supports high resolution images
 *
 * Revision 1.1.1.1  2004/03/29 08:28:45  Administrator
 * initial transfer from tamara
 *
 * Revision 1.2  2004/02/16 16:22:57  dueffert
 * allow instantiation of ColorTable. Only useful to have an empty but initialized one
 *
 * Revision 1.1  2003/10/07 10:09:36  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/07/21 13:43:51  juengel
 * generateColorClassImage returns void
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2003/02/18 21:36:12  osterhues
 * Introduction of the new base class ColorTable
 *
 *
 */
