/**
 * @file JPEGImage.h
 * 
 * Declaration of class JPEGImage
 */ 

#ifndef __JPEGImage_h_
#define __JPEGImage_h_

#include "Image.h"
#include <stdio.h>

// INT32 and FAR conflict with any other header files...
#define INT32 _INT32
#undef FAR
#include "Tools/JPEGlib/jpeglib.h"
#undef INT32
#undef FAR

class JPEGImage;

/**
 * Streaming operator that writes a JPEGImage to a stream.
 * @param stream The stream to write on.
 * @param image The JPEGImage object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream,const JPEGImage& image);

/**
 * Streaming operator that reads a JPEGImage from a stream.
 * @param stream The stream to read from.
 * @param image The JPEGImage object.
 * @return The stream.
 */ 
In& operator>>(In& stream,JPEGImage& image);

/**
 * Definition of a class for JPEG-compressed images.
 */
class JPEGImage : public Image
{
  private:
    /**
     * The class is required during JPEG-compression to access
     * the main JPEGImage object from library handlers.
     */
    class DestDescriptor : public jpeg_destination_mgr
    {
      public:
        JPEGImage* theObject; /**< A pointer to the JPEGImage object. */
    };

    unsigned size; /**< The size of the JPEG image. */

    //!@name Handlers for JPEG-compression
    //!@{
    static void onDestInit(j_compress_ptr cInfo);
    static int onDestEmpty(j_compress_ptr);
    static void onDestTerm(j_compress_ptr cInfo);

    static void onSrcSkip(j_decompress_ptr cInfo,long numBytes);
    static int onSrcEmpty(j_decompress_ptr);
    static void onSrcIgnore(j_decompress_ptr);
    //!@}

  public:
    /** 
     * Empty constructor. 
     */
    JPEGImage() {size = 0;}

    /** 
     * Constructs a JPEG image from an image.
     * @param src The image used as template.
     */
    JPEGImage(const Image& src);

    /**
     * Assignment operator.
     * @param src The image used as template.
     * @return The resulting JPEG image.
     */
    JPEGImage& operator=(const Image& src);

    /**
     * Uncompress image.
     * @param dest Will receive the uncompressed image.
     */
    void toImage(Image& dest) const;

  friend Out& operator<<(Out& stream,const JPEGImage& image);
  friend In& operator>>(In& stream,JPEGImage& image);
};

#endif //__JPEGImage_h_

/*
 * Change log :
 * 
 * $Log: JPEGImage.h,v $
 * Revision 1.1  2003/10/07 10:09:36  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.4  2003/05/26 12:51:51  dueffert
 * does not work without const for some reason
 *
 * Revision 1.3  2003/05/23 11:24:25  dueffert
 * cast warnings removed, hopefully nobody wants to change (now non-const) src in JPEGImage's =operator...
 *
 * Revision 1.2  2003/01/22 13:47:20  roefer
 * Comment added
 *
 * Revision 1.1  2002/10/11 13:54:44  roefer
 * JPEGImage added
 *
 *
 */
