/**
 * @file ObstaclesPercept.cpp
 *
 * Implementation of class ObstaclesPercept.
 * @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Juengel</a>
 */

#include "ObstaclesPercept.h"

void ObstaclesPercept::reset(unsigned long frameNumber)
{
  this->frameNumber = frameNumber;
  numberOfPoints = 0;

  for(int i = 0; i < 2; i++)
  {
    angleToFreePartOfGoalWasDetermined[i] = false;
    angleToFreePartOfGoal[i] = distanceToFreePartOfGoal[i] = 
                                    widthOfFreePartOfGoal[i] = 0;
  }
}

void ObstaclesPercept::add(const Vector2<int>& nearPoint, const Vector2<int>& farPoint, bool farPointIsOnBorder)
{
  if(numberOfPoints < maxNumberOfPoints)
  {
    nearPoints[numberOfPoints] = nearPoint;
    farPoints[numberOfPoints] = farPoint;
    farPointIsOnImageBorder[numberOfPoints++] = farPointIsOnBorder;
  }
}

void ObstaclesPercept::add(const Vector2<int>& nearPoint, const Vector2<int>& farPoint, bool farPointIsOnBorder, ObstacleType obstacleType)
{
  if(numberOfPoints < maxNumberOfPoints)
  {
    nearPoints[numberOfPoints] = nearPoint;
    farPoints[numberOfPoints] = farPoint;
    farPointIsOnImageBorder[numberOfPoints] = farPointIsOnBorder;
    this->obstacleType[numberOfPoints++] = obstacleType;
  }
}


In& operator>>(In& stream, ObstaclesPercept& obstaclesPercept)
{
  stream >> obstaclesPercept.frameNumber;
  char temp;

  for(int i = 0; i < 2; i++)
  {
    stream >> temp;
    obstaclesPercept.angleToFreePartOfGoalWasDetermined[i] = temp != 0;
    if(temp)
      stream >> obstaclesPercept.angleToFreePartOfGoal[i]
             >> obstaclesPercept.distanceToFreePartOfGoal[i]
             >> obstaclesPercept.widthOfFreePartOfGoal[i];
  }

  stream >> obstaclesPercept.numberOfPoints;
  for(int j = 0; j < obstaclesPercept.numberOfPoints; j++)
  {
    stream >> obstaclesPercept.nearPoints[j].x >> obstaclesPercept.nearPoints[j].y;
    stream >> obstaclesPercept.farPoints[j].x >> obstaclesPercept.farPoints[j].y;
    stream >> temp;
    obstaclesPercept.obstacleType[j] = (ObstaclesPercept::ObstacleType)temp;
    stream >> temp;
    obstaclesPercept.farPointIsOnImageBorder[j] = temp != 0;
  }
  return stream;
}
 
Out& operator<<(Out& stream, const ObstaclesPercept& obstaclesPercept)
{
  stream << obstaclesPercept.frameNumber;
  for(int i = 0; i < 2; i++)
  {
    if(obstaclesPercept.angleToFreePartOfGoalWasDetermined[i]) 
      stream << char(1) << obstaclesPercept.angleToFreePartOfGoal[i]
                        << obstaclesPercept.distanceToFreePartOfGoal[i]
                        << obstaclesPercept.widthOfFreePartOfGoal[i];
    else 
      stream << char(0);
  }

  stream << obstaclesPercept.numberOfPoints;
  for(int j = 0; j < obstaclesPercept.numberOfPoints; j++)
  {
    stream << obstaclesPercept.nearPoints[j].x << obstaclesPercept.nearPoints[j].y;
    stream << obstaclesPercept.farPoints[j].x << obstaclesPercept.farPoints[j].y;
    stream << (char)(obstaclesPercept.obstacleType[j]);
    if(obstaclesPercept.farPointIsOnImageBorder[j]) stream << char(1);
    else stream << char(0);
  }
  return stream;
}

/*
 * Change log :
 * 
 * $Log: ObstaclesPercept.cpp,v $
 * Revision 1.4  2004/03/01 11:49:05  juengel
 * Added obstacle type as parameter for add method and to streaming operators.
 *
 * Revision 1.3  2004/01/19 14:53:46  dueffert
 * all frameNumbers (and not only some of them) are unsigned long now
 *
 * Revision 1.2  2003/11/12 16:19:35  goehring
 * frameNumber added to percepts
 *
 * Revision 1.1  2003/10/07 10:09:36  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2003/06/25 18:42:14  juengel
 * Added nearPoints, farPoints[maxNumberOfPoints] and farPointIsOnImageBorder to ObstaclesPercept.
 *
 * Revision 1.2  2003/05/26 08:12:11  juengel
 * Moved angleToFreePartOfGoal from specialPercept to obstaclesPercept.
 *
 * Revision 1.1  2003/03/10 13:52:09  juengel
 * Added ObstaclesPercept
 *
 */
