/** 
* @file SensorDataBuffer.h
*
* Definition of SensorDataBuffer class.
*
* @author Max Risler
*/
#ifndef __SENSORDATABUFFER_H__
#define __SENSORDATABUFFER_H__

#include "SensorData.h"

#include "Tools/Streams/InOut.h"

/**
* A buffer for sensor data sets, containing all frames received at the same time.
* @author Max Risler
*/
class SensorDataBuffer
{
public:
  /** Maximum number of frames in the buffer.
  */
  enum {maxNumOfFrames = 16};

  /** Constructor */
  SensorDataBuffer();
  
  /** Number of frames in the buffer */
  int numOfFrames;

  /** The joint data frames */
  SensorData frame[maxNumOfFrames];

  /** Returns pointer to the most recent SensorData */
  const SensorData& lastFrame() const
  {
    if (numOfFrames > 0)
      return frame[numOfFrames - 1];
    else
      return frame[0];
  };
};

/**
 * Streaming operator that reads a SensorDataBuffer from a stream.
 * @param stream The stream from which is read.
 * @param sensorDataBuffer The SensorDataBuffer object.
 * @return The stream.
 */ 
In& operator>>(In& stream,SensorDataBuffer& sensorDataBuffer);
 
/**
 * Streaming operator that writes a SensorDataBuffer to a stream.
 * @param stream The stream to write on.
 * @param sensorDataBuffer The SensorDataBuffer object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const SensorDataBuffer& sensorDataBuffer);

#endif //__SENSORDATABUFFER_H__

/*
 * Change log :
 * 
 * $Log: SensorDataBuffer.h,v $
 * Revision 1.1  2003/10/07 10:09:36  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2003/05/03 15:26:06  risler
 * changed
 * #endif __SENSORDATABUFFER_H__
 * to
 * #endif //__SENSORDATABUFFER_H__
 * :)
 *
 * Revision 1.2  2003/05/02 19:04:59  loetzsch
 * changed
 * #endif //__JOINTDATABUFFER_H__
 * to
 * #endif __SENSORDATABUFFER_H__
 *
 * Revision 1.1  2003/05/02 18:45:40  risler
 * SensorDataBuffer added
 * replaced SensorData with SensorDataBuffer
 * full SensorData resolution now accessible
 *
 */
