/**
 * @file SpecialVisionRequest.h
 * 
 * Declaration of class SpecialVisionRequest
 * 
 * @author Matthias Juengel
 */ 

#ifndef __SpecialVisionRequest_h_
#define __SpecialVisionRequest_h_

#include "Tools/Streams/InOut.h"

/** 
* @class SpecialVisionRequest 
*
* Represents a request for special visons (challenges ...).
*/
class SpecialVisionRequest
{
public:

  /** constructor */
  SpecialVisionRequest();

  /** destructor */
  ~SpecialVisionRequest();

  enum SpecialVisionRequests 
  {
    none,
      barCode,
  numOfSpecialVisionRequests
  };

  SpecialVisionRequests specialVisionRequest;

  //! Returns the name of a SpecialVisionRequest. 
  static char* getSpecialVisionRequestName(SpecialVisionRequests  specialVisionRequest)
  {
    switch(specialVisionRequest)
    {
    case none: return "none";
    case barCode: return "barCode";
    default: return "undefined SpecialVisionRequest";
    }
  };
};


/**
 * Streaming operator that reads a SpecialVisionRequest from a stream.
 * @param stream The stream from which is read.
 * @param specialVisionRequest The SpecialVisionRequest object.
 * @return The stream.
 */ 
In& operator>>(In& stream,SpecialVisionRequest& specialVisionRequest);
 
/**
 * Streaming operator that writes a SpecialVisionRequest to a stream.
 * @param stream The stream to write on.
 * @param specialVisionRequest The SpecialVisionRequest object.
 * @return The stream.
 */ 
Out& operator<<(Out& stream, const SpecialVisionRequest& specialVisionRequest);



#endif //__SpecialVisionRequest_h_

/*
 * Change log :
 * 
 * $Log: SpecialVisionRequest.h,v $
 * Revision 1.1  2003/10/07 10:09:36  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:22  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2003/01/29 10:37:21  juengel
 * Added BarCodeReader.
 *
 * Revision 1.1  2002/09/10 15:26:40  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed Challenge Code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.2  2002/07/23 13:32:57  loetzsch
 * new streaming classes
 *
 * removed many #include statements
 *
 * Revision 1.1  2002/05/10 17:40:26  juengel
 * Added SpecialVision and SpecialPercept.
 *
 *
 */
