/**
* @file AlLxJoystickDlgBar.cpp
* Implementation of class CAlLxJoystickDlgBar.
* @author Alexander Urban
*/


#include "StdAfx.h"
#include "AlLxJoystickDlgBar.h"
#include "Modules/SensorBehaviorControl/AlLx_RemotePresence.h"
#include "RobotControlQueues.h"
#include "Tools/Math/Common.h"

#define ALLX_SEND_MSG_TO_ROBOT(packet,id)				\
	getQueues().toPhysical.selectedRobot.out.bin << packet;		\
	getQueues().toPhysical.selectedRobot.out.finishMessage(id);	\
	getQueues().toSimulated.selectedRobot.out.bin << packet;		\
	getQueues().toSimulated.selectedRobot.out.finishMessage(id);


#define ALLX_PATHBITMAP_X		100
#define ALLX_PATHBITMAP_Y		10
#define ALLX_PATHBITMAP_WIDTH	100
#define ALLX_PATHBITMAP_HEIGHT	100
#define ALLX_PATHBITMAP_ROBOTX	50
#define ALLX_PATHBITMAP_ROBOTY	50


/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CAlLxJoystickDlgBar 


CAlLxJoystickDlgBar::CAlLxJoystickDlgBar(CWnd* pParent /*=NULL*/)
	: CRobotControlDialogBar(CAlLxJoystickDlgBar::IDD) {
	//{{AFX_DATA_INIT(CAlLxJoystickDlgBar)
		// HINWEIS: Der Klassen-Assistent fgt hier Elementinitialisierung ein
	//}}AFX_DATA_INIT

	m_pathSteps = 0;
	m_pathBitmap = NULL;
	m_mouseClick.x = m_mouseClick.y = 0;
}


void CAlLxJoystickDlgBar::DoDataExchange(CDataExchange* pDX) {
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAlLxJoystickDlgBar)
		// HINWEIS: Der Klassen-Assistent fgt hier DDX- und DDV-Aufrufe ein
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAlLxJoystickDlgBar, CRobotControlDialogBar)
	//{{AFX_MSG_MAP(CAlLxJoystickDlgBar)
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_ALLX_JOYSTICK_FORWARD_BUTTON, OnForwardButton)
	ON_BN_CLICKED(IDC_ALLX_JOYSTICK_BACKWARD_BUTTON, OnBackwardButton)
	ON_BN_CLICKED(IDC_ALLX_JOYSTICK_LEFT_BUTTON, OnLeftButton)
	ON_BN_CLICKED(IDC_ALLX_JOYSTICK_RIGHT_BUTTON, OnRightButton)
	ON_BN_CLICKED(IDC_ALLX_JOYSTICK_STOP_BUTTON, OnStopButton)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CAlLxJoystickDlgBar 

BOOL CAlLxJoystickDlgBar::OnInitDialog() {
	
	CButton
		*btn;
	CSliderCtrl
		*sld;

	btn = (CButton*) GetDlgItem(IDC_ALLX_JOYSTICK_FORWARD_BUTTON);
	btn->SetBitmap((HBITMAP)::LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_ALLX_UP_BITMAP), IMAGE_BITMAP, 0, 0, LR_MONOCHROME | LR_LOADTRANSPARENT));
	btn = (CButton*) GetDlgItem(IDC_ALLX_JOYSTICK_BACKWARD_BUTTON);
	btn->SetBitmap((HBITMAP)::LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_ALLX_DOWN_BITMAP), IMAGE_BITMAP, 0, 0, LR_MONOCHROME | LR_LOADTRANSPARENT));
	btn = (CButton*) GetDlgItem(IDC_ALLX_JOYSTICK_LEFT_BUTTON);
	btn->SetBitmap((HBITMAP)::LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_ALLX_LEFT_BITMAP), IMAGE_BITMAP, 0, 0, LR_MONOCHROME | LR_LOADTRANSPARENT));
	btn = (CButton*) GetDlgItem(IDC_ALLX_JOYSTICK_RIGHT_BUTTON);
	btn->SetBitmap((HBITMAP)::LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_ALLX_RIGHT_BITMAP), IMAGE_BITMAP, 0, 0, LR_MONOCHROME | LR_LOADTRANSPARENT));
	btn = (CButton*) GetDlgItem(IDC_ALLX_JOYSTICK_STOP_BUTTON);
	btn->SetBitmap((HBITMAP)::LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_ALLX_STOP_BITMAP), IMAGE_BITMAP, 0, 0, LR_MONOCHROME | LR_LOADTRANSPARENT));

	sld = (CSliderCtrl*) GetDlgItem(IDC_ALLX_JOYSTICK_SLIDER);
	sld->SetRange(0, 200);
	sld->SetLineSize(10);
	sld->SetPageSize(50);
	sld->SetPos(30);

	CRobotControlDialogBar::OnInitDialog();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
  }

void CAlLxJoystickDlgBar::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) {

	if (pScrollBar == NULL || pScrollBar->GetDlgCtrlID() != IDC_ALLX_JOYSTICK_SLIDER) {
		CRobotControlDialogBar::OnHScroll(nSBCode, nPos, pScrollBar);
		return;
	}

	AlLx_CommPacket
		acp;

	acp.command = AlLx_CommPacket::setSpeed;
	acp.parameter[0] = ((CSliderCtrl*) pScrollBar)->GetPos();

	ALLX_SEND_MSG_TO_ROBOT(acp, idAlLxComm);
	return;
}

void CAlLxJoystickDlgBar::OnForwardButton() {

	AlLx_CommPacket
		acp;
	int
		i;
	double
		direction[2];

	if (m_pathSteps == 0) {
		acp.command = AlLx_CommPacket::goForward;
		ALLX_SEND_MSG_TO_ROBOT(acp, idAlLxComm);
		return;
	}

	pathBitmap_init();
	pathBitmap_line(ALLX_PATHBITMAP_ROBOTX, ALLX_PATHBITMAP_ROBOTY,
				m_path[0].x, m_path[0].y);
	direction[0] = pi / 2.0;

	m_path2[0].translation = sqrt(pow(ALLX_PATHBITMAP_ROBOTX - m_path[0].x, 2) +
				pow(ALLX_PATHBITMAP_ROBOTY - m_path[0].y, 2));
	direction[1] = atan2((double)(ALLX_PATHBITMAP_ROBOTY - m_path[0].y),
				(double)(m_path[0].x - ALLX_PATHBITMAP_ROBOTX));
	m_path2[0].rotation = direction[1] - direction[0];
	if (m_path2[0].rotation < -pi)
		m_path2[0].rotation += 2.0 * pi;
	else if (m_path2[0].rotation > pi)
		m_path2[0].rotation -= 2.0 * pi;
	direction[0] = direction[1];

	for (i = 1; i < m_pathSteps; i++) {
		pathBitmap_line(m_path[i - 1].x, m_path[i - 1].y, m_path[i].x, m_path[i].y);
		m_path2[i].translation = sqrt(pow(m_path[i - 1].x - m_path[i].x, 2) +
					pow(m_path[i - 1].y - m_path[i].y, 2));
		direction[1] = atan2((double)(m_path[i - 1].y - m_path[i].y),
					(double)(m_path[i].x - m_path[i - 1].x));
		m_path2[i].rotation = direction[1] - direction[0];
		if (m_path2[i].rotation < -pi)
			m_path2[i].rotation += 2.0 * pi;
		else if (m_path2[i].rotation > pi)
			m_path2[i].rotation -= 2.0 * pi;
		direction[0] = direction[1];
	}

	pathBitmap_draw(this->GetDC());
	m_pathSteps = 0;
	return;
}

void CAlLxJoystickDlgBar::OnBackwardButton() {

	AlLx_CommPacket
		acp;

	acp.command = AlLx_CommPacket::goBackward;

	ALLX_SEND_MSG_TO_ROBOT(acp, idAlLxComm);
	return;
}

void CAlLxJoystickDlgBar::OnLeftButton() {

	AlLx_CommPacket
		acp;

	acp.command = AlLx_CommPacket::turnLeft;

	ALLX_SEND_MSG_TO_ROBOT(acp, idAlLxComm);
	return;
}

void CAlLxJoystickDlgBar::OnRightButton() {

	AlLx_CommPacket
		acp;

	acp.command = AlLx_CommPacket::turnRight;

	ALLX_SEND_MSG_TO_ROBOT(acp, idAlLxComm);
	return;
}

void CAlLxJoystickDlgBar::OnStopButton() {

	AlLx_CommPacket
		acp;

	pathBitmap_init();
	pathBitmap_draw(this->GetDC());

	if (m_pathSteps == 0) {
		acp.command = AlLx_CommPacket::stopMotion;
		ALLX_SEND_MSG_TO_ROBOT(acp, idAlLxComm);
		return;
	}

	m_pathSteps = 0;
}

LRESULT CAlLxJoystickDlgBar::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) {

	POINTS
		pos;

	switch (message) {
	case WM_LBUTTONDOWN:
		m_mouseClick = MAKEPOINTS(lParam);
		break;

	case WM_LBUTTONUP:
		if (m_mouseClick.x == 0 || m_mouseClick.y == 0)
			return 0;

		pos = MAKEPOINTS(lParam);
		if (abs(m_mouseClick.x - pos.x) >= 3 ||
					abs(m_mouseClick.y - pos.y) >= 3) {
			m_mouseClick.x = m_mouseClick.y = 0;
			return 0;
		}
		m_mouseClick.x = m_mouseClick.y = 0;

		if (pathBitmap_click(pos.x, pos.y))
			return 0;
		break;

	}

	return CRobotControlDialogBar::WindowProc(message, wParam, lParam);
}

void CAlLxJoystickDlgBar::OnPaint() {

	CPaintDC dc(this); // device context for painting
	
	pathBitmap_draw(&dc);
	
	// Kein Aufruf von CRobotControlDialogBar::OnPaint() fr Zeichnungsnachrichten
}



bool CAlLxJoystickDlgBar::pathBitmap_init() {

	HDC
		hMemDC;
	COLORREF
		color;
	int x, y;

	// Bild-Objekt erstellen:
	if (m_pathBitmap != NULL)
		DeleteObject(m_pathBitmap);
	m_pathBitmap = CreateBitmap(ALLX_PATHBITMAP_WIDTH, ALLX_PATHBITMAP_HEIGHT, 1,
				this->GetDC()->GetDeviceCaps(BITSPIXEL), 0);
	if (m_pathBitmap == NULL)
		return false;

	// Memory-DC-Objekt erstellen
	hMemDC = CreateCompatibleDC(*(this->GetDC()));
	SelectObject(hMemDC, m_pathBitmap);

	color = RGB(255, 255, 255);
	for (x = 0; x < ALLX_PATHBITMAP_WIDTH; x++)
		for (y = 0; y < ALLX_PATHBITMAP_HEIGHT; y++)
			SetPixel(hMemDC, x, y, color);

	color = RGB(255, 0, 0);
	SetPixel(hMemDC, ALLX_PATHBITMAP_ROBOTX, ALLX_PATHBITMAP_ROBOTY, color);
	SetPixel(hMemDC, ALLX_PATHBITMAP_ROBOTX - 1, ALLX_PATHBITMAP_ROBOTY, color);
	SetPixel(hMemDC, ALLX_PATHBITMAP_ROBOTX - 2, ALLX_PATHBITMAP_ROBOTY, color);
	SetPixel(hMemDC, ALLX_PATHBITMAP_ROBOTX + 1, ALLX_PATHBITMAP_ROBOTY, color);
	SetPixel(hMemDC, ALLX_PATHBITMAP_ROBOTX + 2, ALLX_PATHBITMAP_ROBOTY, color);
	SetPixel(hMemDC, ALLX_PATHBITMAP_ROBOTX, ALLX_PATHBITMAP_ROBOTY - 1, color);
	SetPixel(hMemDC, ALLX_PATHBITMAP_ROBOTX, ALLX_PATHBITMAP_ROBOTY - 2, color);
	SetPixel(hMemDC, ALLX_PATHBITMAP_ROBOTX, ALLX_PATHBITMAP_ROBOTY - 3, color);

	DeleteObject(hMemDC);
	return true;
}

bool CAlLxJoystickDlgBar::pathBitmap_setPixel(int x, int y, int red, int green, int blue) {

	HDC
		hMemDC;

	if (m_pathBitmap == NULL && ! pathBitmap_init())
		return false;

	hMemDC = CreateCompatibleDC(*(this->GetDC()));
	SelectObject(hMemDC, m_pathBitmap);
	SetPixel(hMemDC, x, y, RGB(red, green, blue));

	DeleteObject(hMemDC);
	return true;
}

bool CAlLxJoystickDlgBar::pathBitmap_draw(CDC *dc) {

	HDC
		hMemDC;

	if (m_pathBitmap == NULL && ! pathBitmap_init())
		return false;

	hMemDC = CreateCompatibleDC(*dc);
	SelectObject(hMemDC, m_pathBitmap);
	// gemaltes Bild auf Bildschirm kopieren / anzeigen:
	BitBlt(*dc, ALLX_PATHBITMAP_X, ALLX_PATHBITMAP_Y, ALLX_PATHBITMAP_WIDTH,
				ALLX_PATHBITMAP_HEIGHT, hMemDC, 0, 0, SRCCOPY);

	DeleteObject(hMemDC);
	return true;
}

bool CAlLxJoystickDlgBar::pathBitmap_click(int x, int y) {

	x -= ALLX_PATHBITMAP_X;
	y -= ALLX_PATHBITMAP_Y;

	if (x < 0 || x >= ALLX_PATHBITMAP_WIDTH)
		return false;
	if (y < 0 || y >= ALLX_PATHBITMAP_HEIGHT)
		return false;

	if (m_pathSteps >= 10)
		return true;

	m_path[m_pathSteps].x = x;
	m_path[m_pathSteps].y = y;
	m_pathSteps++;

	pathBitmap_setPixel(x,     y,     0, (m_pathSteps == 10) ? 192 : 0, 0);
	pathBitmap_setPixel(x - 1, y - 1, 0, (m_pathSteps == 10) ? 192 : 0, 0);
	pathBitmap_setPixel(x - 1, y + 1, 0, (m_pathSteps == 10) ? 192 : 0, 0);
	pathBitmap_setPixel(x + 1, y - 1, 0, (m_pathSteps == 10) ? 192 : 0, 0);
	pathBitmap_setPixel(x + 1, y + 1, 0, (m_pathSteps == 10) ? 192 : 0, 0);

	return pathBitmap_draw(this->GetDC());
}

bool CAlLxJoystickDlgBar::pathBitmap_line(int x1, int y1, int x2, int y2) {

	double
		m,
		x0;
	int
		x, y;

	if (x1 == x2 && y1 == y2)
		return pathBitmap_setPixel(x1, y2, 0, 0, 255);

	if (x1 == x2) {
		for (y = min(y1, y2) + 1; y < max(y1, y2); y++) {
			pathBitmap_setPixel(x1, y, 0, 0, 255);
		}
	}
	else if (y1 == y2) {
		for (x = min(x1, x2) + 1; x < max(x1, x2); x++) {
			pathBitmap_setPixel(x, y1, 0, 0, 255);
		}		
	}
	else if (abs(x1 - x2) < abs(y1 - y2)) {
		m = ((double) (y1 - y2)) / ((double) (x1 - x2));
		x0 = ((double) y1) - m * ((double) x1);
		for (y = min(y1, y2) + 1; y < max(y1, y2); y++) {
			x = (int) ((((double) y) - x0) / m);
			pathBitmap_setPixel(x, y, 0, 0, 255);
		}
	}
	else {
		m = ((double) (y1 - y2)) / ((double) (x1 - x2));
		x0 = ((double) y1) - m * ((double) x1);
		for (x = min(x1, x2) + 1; x < max(x1, x2); x++) {
			y = (int) (m * ((double) x) + x0);
			pathBitmap_setPixel(x, y, 0, 0, 255);
		}
	}

	return true;
}
