/**
* @file AlLxJoystickDlgBar.h
* Declaration of class CAlLxJoystickDlgBar.
* @author <a href="mailto:urban@informatik.hu-berlin.de">Alexander Urban</a>
*/

#ifndef _ALLXJOYSTICKDLGBAR_H_
#define _ALLXJOYSTICKDLGBAR_H_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"

/** 
* @class CAlLxJoystickDlgBar
* A dialog bar for our telepresence project
* @author <a href="mailto:urban@informatik.hu-berlin.de">Alexander Urban</a>
*/

class CAlLxJoystickDlgBar : public CRobotControlDialogBar {

	struct {
		double
			rotation;
		double
			translation;
	}
		m_path2[10];

public:
	CAlLxJoystickDlgBar(CWnd* pParent = NULL);

// Dialogfelddaten
	//{{AFX_DATA(CAlLxJoystickDlgBar)
	enum { IDD = IDD_DIALOG_BAR_ALLX_JOYSTICK };
		// HINWEIS: Der Klassen-Assistent fgt hier Datenelemente ein
	//}}AFX_DATA


// berschreibungen
	// Vom Klassen-Assistenten generierte virtuelle Funktionsberschreibungen
	//{{AFX_VIRTUAL(CAlLxJoystickDlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Untersttzung
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementierung
protected:

	// Generierte Nachrichtenzuordnungsfunktionen
	//{{AFX_MSG(CAlLxJoystickDlgBar)
	virtual BOOL OnInitDialog();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnForwardButton();
	afx_msg void OnBackwardButton();
	afx_msg void OnLeftButton();
	afx_msg void OnRightButton();
	afx_msg void OnStopButton();
	afx_msg void OnPaint();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	bool pathBitmap_line(int x1, int y1, int x2, int y2);
	int m_pathSteps;
	POINTS m_path[10];
	bool pathBitmap_click(int x, int y);
	bool pathBitmap_draw(CDC *dc);
	bool pathBitmap_setPixel(int x, int y, int red, int green, int blue);
	bool pathBitmap_init();
	HBITMAP m_pathBitmap;
	POINTS m_mouseClick;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ fgt unmittelbar vor der vorhergehenden Zeile zustzliche Deklarationen ein.

#endif // _ALLXJOYSTICKDLGBAR_H_
