/**
* @file DebugKeysToolBar.cpp
* 
* Implementation of class DebugKeysToolBar
*
* @author Martin Ltzsch
*/

#include "StdAfx.h"
#include "resource.h"
#include "DebugKeysToolBar.h"
#include "RobotControlDebugKeyTables.h"
#include "RobotControlQueues.h"

IMPLEMENT_DYNAMIC( CDebugKeysToolBar, CToolBarEx )

void CDebugKeysToolBar::Init()
{
  editForRobot = true;
  queueFillRequest.mode = QueueFillRequest::overwriteOlder;
  
  static TBBUTTONEX tbButtons[] =
  {
    { {  13, IDC_DEBUGKEY_EDIT_FOR_LOCAL,   TBSTATE_ENABLED, TBSTYLE_CHECK | TBSTYLE_CHECKGROUP, 0, 0 }, true },
    { {  14, IDC_DEBUGKEY_EDIT_FOR_ROBOT,   TBSTATE_ENABLED, TBSTYLE_CHECK | TBSTYLE_CHECKGROUP, 0, 0 }, true },
    { {  0, 0, 0, TBSTYLE_SEP, 0,0 }, true },
    { {  0, IDC_DEBUGKEY_COMBO, TBSTATE_ENABLED, TBSTYLE_BUTTON,    0, 0 }, true },
    { {  1, IDC_DEBUGKEY_DISABLED_RADIO, TBSTATE_ENABLED, TBSTYLE_CHECK | TBSTYLE_CHECKGROUP,    0, 0 }, true },
    { {  2, IDC_DEBUGKEY_ALWAYS_RADIO, TBSTATE_ENABLED, TBSTYLE_CHECK | TBSTYLE_CHECKGROUP,    0, 0 }, true },
    { {  3, IDC_DEBUGKEY_NTIMES_RADIO, TBSTATE_ENABLED, TBSTYLE_CHECK | TBSTYLE_CHECKGROUP,    0, 0 }, true },
    { {  4, IDC_DEBUGKEY_EVERYNTIMES_RADIO, TBSTATE_ENABLED, TBSTYLE_CHECK | TBSTYLE_CHECKGROUP,    0, 0 }, true },
    { {  5, IDC_DEBUGKEY_EVERYNMS_RADIO, TBSTATE_ENABLED, TBSTYLE_CHECK | TBSTYLE_CHECKGROUP,    0, 0 }, true },
    { {  6, IDC_DEBUGKEY_N_EDIT, TBSTATE_ENABLED, TBSTYLE_BUTTON,    0, 0 }, true },
    { {  0, 0, 0, TBSTYLE_SEP, 0,0 }, true },
    { {  7, IDC_DEBUGKEY_RESET, TBSTATE_ENABLED, TBSTYLE_BUTTON,    0, 0 }, true },
    { {  0, 0, 0, TBSTYLE_SEP, 0,0 }, true },
    { {  8, IDC_DEBUGKEY_IMMEDIATE_RADIO, TBSTATE_ENABLED, TBSTYLE_CHECK,    0, 0 }, true },
    { {  9, IDC_DEBUGKEY_REALTIME_RADIO, TBSTATE_ENABLED, TBSTYLE_CHECK,    0, 0 }, true },
    { {  10, IDC_DEBUGKEY_WLAN_N_RADIO, TBSTATE_ENABLED, TBSTYLE_CHECK,    0, 0 }, true },
    { {  11, IDC_DEBUGKEY_STICK_N_RADIO, TBSTATE_ENABLED, TBSTYLE_CHECK,    0, 0 }, true },
    { {  12, IDC_DEBUGKEY_REJECT_RADIO, TBSTATE_ENABLED, TBSTYLE_CHECK,    0, 0 }, true },
    { {  6, IDC_DEBUGKEY_SECONDS_EDIT, TBSTATE_ENABLED, TBSTYLE_BUTTON,    0, 0 }, true },
    { {  0, 0, 0, TBSTYLE_SEP, 0,0 }, true },
    { {  15, IDC_DEBUGKEY_SEND, TBSTATE_ENABLED, TBSTYLE_BUTTON,    0, 0 }, true },
  };
  
  SetBitmaps( IDB_DEBUGKEYS, IDB_DEBUGKEYS_COLD);
  SetButtons( sizeof( tbButtons ) / sizeof( tbButtons[ 0 ] ), tbButtons);
  
  AddCombo(&m_wndDebugKeysCombo,IDC_DEBUGKEY_COMBO,160);
  AddEdit(&m_wndDebugKeysNEdit,IDC_DEBUGKEY_N_EDIT,40,&m_wndDebugKeysNEditDummyCombo);
  AddEdit(&m_wndDebugKeysSecondsEdit,IDC_DEBUGKEY_SECONDS_EDIT,40,&m_wndDebugKeysSecondsEditDummyCombo);
  
  m_wndDebugKeysNEdit.SetWindowText("0");
  m_wndDebugKeysSecondsEdit.SetWindowText("0");
  
  for (int key=0;key < DebugKeyTable::numOfDebugKeysForDebugKeyToolbar;key++)
  {
    m_wndDebugKeysCombo.AddString(DebugKeyTable::getDebugKeyName((DebugKeyTable::debugKeyID)key));
  }
  m_wndDebugKeysCombo.SetCurSel(0);
  
  OnDebugKeyComboSelChange();
}

bool CDebugKeysToolBar::handleCommand(UINT command)
{
  switch (command)
  {
  case IDC_DEBUGKEY_SEND:
    {
      CString n;
      m_wndDebugKeysSecondsEdit.GetWindowText(n);
      queueFillRequest.seconds = atoi(n.GetBuffer(n.GetLength()));
      if (editForRobot)
      {
        getQueues().toPhysical.allRobots.out.bin << queueFillRequest;
        getQueues().toPhysical.allRobots.out.finishMessage(idQueueFillRequest);
        getDebugKeyTables().sendForPhysicalRobots();
      }
      else
      {
        getQueues().toSimulated.allRobots.out.bin << queueFillRequest;
        getQueues().toSimulated.allRobots.out.finishMessage(idQueueFillRequest);
        getDebugKeyTables().sendForSimulatedRobots();
      }
    }
    return true;
  case IDC_DEBUGKEY_EDIT_FOR_LOCAL:
    editForRobot = false;
    return true;
  case IDC_DEBUGKEY_EDIT_FOR_ROBOT:
    editForRobot = true;
    return true;
  case IDC_DEBUGKEY_RESET:
    if (editForRobot)
      getDebugKeyTables().forPhysicalRobots.reset();
    else
      getDebugKeyTables().forSimulatedRobots.reset();
    OnDebugKeyComboSelChange();
    return true;
  case IDC_DEBUGKEY_DISABLED_RADIO:
    {
      CString n;
      m_wndDebugKeysNEdit.GetWindowText(n);
      
      if (editForRobot)
        getDebugKeyTables().forPhysicalRobots.set((DebugKeyTable::debugKeyID)m_wndDebugKeysCombo.GetCurSel(),
        DebugKey::disabled,atoi(n.GetBuffer(n.GetLength())));
      else
        getDebugKeyTables().forSimulatedRobots.set((DebugKeyTable::debugKeyID)m_wndDebugKeysCombo.GetCurSel(),
        DebugKey::disabled,atoi(n.GetBuffer(n.GetLength())));
      return true;
    }
  case IDC_DEBUGKEY_ALWAYS_RADIO:
    {
      CString n;
      m_wndDebugKeysNEdit.GetWindowText(n);
      
      if (editForRobot)
        getDebugKeyTables().forPhysicalRobots.set((DebugKeyTable::debugKeyID)m_wndDebugKeysCombo.GetCurSel(),
        DebugKey::always,atoi(n.GetBuffer(n.GetLength())));
      else
        getDebugKeyTables().forSimulatedRobots.set((DebugKeyTable::debugKeyID)m_wndDebugKeysCombo.GetCurSel(),
        DebugKey::always,atoi(n.GetBuffer(n.GetLength())));
      
      return true;
    }
  case IDC_DEBUGKEY_NTIMES_RADIO:
    {
      CString n;
      m_wndDebugKeysNEdit.GetWindowText(n);
      
      if (editForRobot)
        getDebugKeyTables().forPhysicalRobots.set((DebugKeyTable::debugKeyID)m_wndDebugKeysCombo.GetCurSel(),
        DebugKey::n_times,atoi(n.GetBuffer(n.GetLength())));
      else
        getDebugKeyTables().forSimulatedRobots.set((DebugKeyTable::debugKeyID)m_wndDebugKeysCombo.GetCurSel(),
        DebugKey::n_times,atoi(n.GetBuffer(n.GetLength())));
      return true;
    }
  case IDC_DEBUGKEY_EVERYNTIMES_RADIO:
    {
      CString n;
      m_wndDebugKeysNEdit.GetWindowText(n);
      
      if (editForRobot)
        getDebugKeyTables().forPhysicalRobots.set((DebugKeyTable::debugKeyID)m_wndDebugKeysCombo.GetCurSel(),
        DebugKey::every_n_times,atoi(n.GetBuffer(n.GetLength())));
      else
        getDebugKeyTables().forSimulatedRobots.set((DebugKeyTable::debugKeyID)m_wndDebugKeysCombo.GetCurSel(),
        DebugKey::every_n_times,atoi(n.GetBuffer(n.GetLength())));
      return true;
    }
  case IDC_DEBUGKEY_EVERYNMS_RADIO:
    {
      CString n;
      m_wndDebugKeysNEdit.GetWindowText(n);
      
      if (editForRobot)
        getDebugKeyTables().forPhysicalRobots.set((DebugKeyTable::debugKeyID)m_wndDebugKeysCombo.GetCurSel(),
        DebugKey::every_n_ms,atoi(n.GetBuffer(n.GetLength())));
      else
        getDebugKeyTables().forSimulatedRobots.set((DebugKeyTable::debugKeyID)m_wndDebugKeysCombo.GetCurSel(),
        DebugKey::every_n_ms,atoi(n.GetBuffer(n.GetLength())));
      
      return true;
    }
  case IDC_DEBUGKEY_IMMEDIATE_RADIO:
    queueFillRequest.mode = QueueFillRequest::immediateReadWrite;
    return true;
  case IDC_DEBUGKEY_REALTIME_RADIO:
    queueFillRequest.mode = QueueFillRequest::overwriteOlder;
    return true;
  case IDC_DEBUGKEY_WLAN_N_RADIO:
    queueFillRequest.mode = QueueFillRequest::collectNSeconds;
    return true;
  case IDC_DEBUGKEY_STICK_N_RADIO:
    queueFillRequest.mode = QueueFillRequest::toStickNSeconds;
    return true;
  case IDC_DEBUGKEY_REJECT_RADIO:
    queueFillRequest.mode = QueueFillRequest::rejectAll;
    return true;
  case IDC_CLEAR_QUEUE_TO_ROBOT:
    getQueues().toPhysical.allRobots.clear();
    getQueues().toPhysical.selectedRobot.clear();
    return true;
  case IDC_SAVE_QUEUE_TO_ROBOT:
    {
      CString pathName =
        AfxGetApp()->GetProfileString("QueueToRobot", "path", "e:\\open-r\\app\\conf\\");
      pathName += "requests.dat";
      
      CFileDialog fileDialog(false, ".dat",pathName,
        OFN_HIDEREADONLY | OFN_EXPLORER | OFN_ENABLESIZING | OFN_NOCHANGEDIR | OFN_NONETWORKBUTTON
        , "Streamed MessageQueue (*.dat)|*.dat||", this);
      if (fileDialog.DoModal()==IDOK)
      {
        CString fileName = fileDialog.GetFileName();
        CString pathAndFileName = fileDialog.GetPathName();
        pathName =
          pathAndFileName.Left(
          pathAndFileName.GetLength() -
          fileName.GetLength()
          );
        AfxGetApp()->WriteProfileString("QueueToRobot", "path", pathName);
        
        OutBinaryFile fout(pathAndFileName);
        if(!fout.exists())
        {
          CString message;
          message.Format( "File %s could not be created", pathAndFileName);
          AfxMessageBox( message, MB_OK);
        }
        else
        {
          MessageQueue tempQueue;
          
          tempQueue.out.bin << getDebugKeyTables().forPhysicalRobots;
          tempQueue.out.finishMessage(idDebugKeyTable);
          
          tempQueue.out.bin << queueFillRequest;
          tempQueue.out.finishMessage(idQueueFillRequest);
          
          getQueues().toPhysical.allRobots.moveAllMessages(tempQueue);
          getQueues().toPhysical.selectedRobot.moveAllMessages(tempQueue);
          
          fout << tempQueue;
        }
      }
      return true;
    }
  default:
    return false;
  }
  return true;
}

bool CDebugKeysToolBar::handleSelChange(UINT nID)
{
  if (nID==IDC_DEBUGKEY_COMBO)
  {
    OnDebugKeyComboSelChange();
    return true;
  }
  return false;
}

bool CDebugKeysToolBar::handleEditChange(UINT nID)
{
  if (nID==IDC_DEBUGKEY_N_EDIT)
  {
    if (m_wndDebugKeysCombo.GetCount() > 0)
    {
      CString n;
      m_wndDebugKeysNEdit.GetWindowText(n);
      
      if (editForRobot)
      {
        getDebugKeyTables().forPhysicalRobots.setN((DebugKeyTable::debugKeyID)m_wndDebugKeysCombo.GetCurSel(),
          atoi(n.GetBuffer(n.GetLength())));
      }
      else
      {
        getDebugKeyTables().forSimulatedRobots.setN((DebugKeyTable::debugKeyID)m_wndDebugKeysCombo.GetCurSel(),
          atoi(n.GetBuffer(n.GetLength())));
      }
    }
    return true;
  }
  return false;
}

void CDebugKeysToolBar::updateUI(CCmdUI* pCmdUI)
{
  switch(pCmdUI->m_nID)
  {
  case IDC_DEBUGKEY_EDIT_FOR_ROBOT:
    pCmdUI->Enable(true);
    pCmdUI->SetCheck(editForRobot);
    return;
  case IDC_DEBUGKEY_EDIT_FOR_LOCAL:
    pCmdUI->Enable(true);
    pCmdUI->SetCheck(!editForRobot);
    return;
  case IDC_DEBUGKEY_DISABLED_RADIO:
  case IDC_DEBUGKEY_ALWAYS_RADIO:
  case IDC_DEBUGKEY_NTIMES_RADIO:
  case IDC_DEBUGKEY_EVERYNTIMES_RADIO:
  case IDC_DEBUGKEY_EVERYNMS_RADIO:
  case IDC_DEBUGKEY_N_EDIT:
    {
      DebugKey::modes debugKeyMode;
      if(editForRobot)
        debugKeyMode=getDebugKeyTables().forPhysicalRobots.getMode(
        (DebugKeyTable::debugKeyID)m_wndDebugKeysCombo.GetCurSel());
      else
        debugKeyMode=getDebugKeyTables().forSimulatedRobots.getMode(
        (DebugKeyTable::debugKeyID)m_wndDebugKeysCombo.GetCurSel());
      
      switch (pCmdUI->m_nID)
      {
      case IDC_DEBUGKEY_DISABLED_RADIO:
        pCmdUI->Enable(true);
        pCmdUI->SetCheck(debugKeyMode == DebugKey::disabled);
        return;
      case IDC_DEBUGKEY_ALWAYS_RADIO:
        pCmdUI->Enable(true);
        pCmdUI->SetCheck(debugKeyMode == DebugKey::always);
        return;
      case IDC_DEBUGKEY_NTIMES_RADIO:
        pCmdUI->Enable(true);
        pCmdUI->SetCheck(debugKeyMode == DebugKey::n_times);
        return;
      case IDC_DEBUGKEY_EVERYNTIMES_RADIO:
        pCmdUI->Enable(true);
        pCmdUI->SetCheck(debugKeyMode == DebugKey::every_n_times);
        return;
      case IDC_DEBUGKEY_EVERYNMS_RADIO:
        pCmdUI->Enable(true);
        pCmdUI->SetCheck(debugKeyMode == DebugKey::every_n_ms);
        return;
      case IDC_DEBUGKEY_N_EDIT:
        pCmdUI->Enable((debugKeyMode != DebugKey::disabled)&&
          (debugKeyMode != DebugKey::always));
        return;
      }
    }
    return;
  case IDC_DEBUGKEY_IMMEDIATE_RADIO:
    pCmdUI->Enable(true);
    pCmdUI->SetCheck(queueFillRequest.mode == QueueFillRequest::immediateReadWrite);
    return;
  case IDC_DEBUGKEY_REALTIME_RADIO:
    pCmdUI->Enable(true);
    pCmdUI->SetCheck(queueFillRequest.mode == QueueFillRequest::overwriteOlder);
    return;
  case IDC_DEBUGKEY_WLAN_N_RADIO:
    pCmdUI->Enable(true);
    pCmdUI->SetCheck(queueFillRequest.mode == QueueFillRequest::collectNSeconds);
    return;
  case IDC_DEBUGKEY_STICK_N_RADIO:
    pCmdUI->Enable(true);
    pCmdUI->SetCheck(queueFillRequest.mode == QueueFillRequest::toStickNSeconds);
    return;
  case IDC_DEBUGKEY_REJECT_RADIO:
    pCmdUI->Enable(true);
    pCmdUI->SetCheck(queueFillRequest.mode == QueueFillRequest::rejectAll);
    return;
  case IDC_DEBUGKEY_SECONDS_EDIT:
    pCmdUI->Enable((queueFillRequest.mode == QueueFillRequest::collectNSeconds)||
      (queueFillRequest.mode == QueueFillRequest::toStickNSeconds));
    return;
  default:
    return;
  }
}

bool CDebugKeysToolBar::HasButtonText( UINT nID )
{
  switch (nID)
  {
  case IDC_DEBUGKEY_COMBO:  
  case IDC_DEBUGKEY_N_EDIT:
  case IDC_DEBUGKEY_SECONDS_EDIT:
  case IDC_DEBUGKEY_SEND:
  case IDC_DEBUGKEY_RESET:
    return true;
  default:
    return false;
  }
  return true;
}


void CDebugKeysToolBar::OnDebugKeyComboSelChange()
{
  char temp[20];
  
  if (editForRobot)
  {
    sprintf(temp,"%i",getDebugKeyTables().forPhysicalRobots.getN((DebugKeyTable::debugKeyID)m_wndDebugKeysCombo.GetCurSel()));
  }
  else
  {
    sprintf(temp,"%i",getDebugKeyTables().forSimulatedRobots.getN((DebugKeyTable::debugKeyID)m_wndDebugKeysCombo.GetCurSel()));
  }
  
  m_wndDebugKeysNEdit.SetWindowText(temp);
}





/*
* Change log :
* 
* $Log: DebugKeysToolBar.cpp,v $
* Revision 1.6  2004/04/08 15:33:08  wachter
* GT04 checkin of Microsoft-Hellounds
*
* Revision 1.6  2004/03/20 00:04:03  pg_thki
* - made the editboxes a little bit larger. (bugfix for 120DPI fonts)
*
* Revision 1.5  2004/03/01 15:26:44  dueffert
* default RobotControl-queueFillMode changed to match default Robot-queueFillMode
*
* Revision 1.4  2004/01/29 12:03:24  jhoffman
* UI changes:
* - Main menu entries renamed, reordered, added some new icons
* - delete-confirmation in settings and WLAN dialog
* - settings dialog uses icons, radio buttons added
* - WLAN dialog restructured
* - motion tester and head motion tested layout improved, stop button added
* - check boxes replaced by radio buttons where appropriate
*
* Revision 1.3  2003/12/09 19:49:25  loetzsch
* Renamed some of the main queues of RobotControl.
*
* Added possibility to send messages to specific simulated or physical robots.
*
* Revision 1.2  2003/12/06 06:31:20  loetzsch
* no message
*
* Revision 1.1  2003/10/07 10:09:37  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/09/01 16:18:58  juengel
* Not all DebugKeys are displayed in DebugKeysToolBar.
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.10  2003/05/11 23:46:32  dueffert
* Depend now works with RobotControl too
*
* Revision 1.9  2003/03/17 15:17:16  risler
* moved edit for robot/local buttons to the left
*
* Revision 1.8  2003/03/11 12:06:46  dueffert
* QueueFillMode rejectAll added
*
* Revision 1.7  2003/03/05 17:09:27  loetzsch
* redesign of the queues and debug key tables in RobotControl
*
* Revision 1.6  2002/11/27 13:51:06  dueffert
* QueueFillMode beautified
*
* Revision 1.5  2002/11/19 17:55:37  dueffert
* no message
*
* Revision 1.4  2002/11/19 12:57:55  dueffert
* queuefillrequest added, debugkey toolbar extended, memorystick toolbar removed
*
* Revision 1.3  2002/11/18 10:35:05  juengel
* Added "block debug sender" mechanism
*
* Revision 1.2  2002/10/01 11:14:34  loetzsch
* Redesigned DebugKey and DebugKeyTable
*
* Revision 1.1  2002/09/10 15:49:04  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.5  2002/09/02 15:17:30  loetzsch
* At RobotControl's start, the debug key table for the robot is selected for editing
*
* Revision 1.4  2002/08/13 12:55:10  loetzsch
* - Added base class CRobotControlToolBar for tool bars
* - Moved command handling from CRobotControlMainFrame to the tool bars
*
* Revision 1.3  2002/07/23 13:43:36  loetzsch
* - new streaming classes
* - removed many #include statements
* - 5 instead of 3 debug queues in RobotControl
* - exchanged StaticQueue with MessageQueue
* - new debug message handling
* - empty constructors in bars / dialogs
* - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
* - general clean up
*
* Revision 1.2  2002/05/29 14:04:14  risler
* combobox bigger
*
* Revision 1.1.1.1  2002/05/10 12:40:20  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.12  2002/04/30 14:25:28  risler
* bug with sending local debug keys removed
*
* Revision 1.11  2002/04/23 17:45:17  loetzsch
* - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
* - removed Modules Toolbar
* - removed access for dialogs and toolbars to solutionRequest.
* - changed access for dialogs and toolbars to debug queues
* - removed the instance of SolutionRequest in CRobotControlApp
* - only the log player, local processes and the robot put messages into queueToRobotControl
*
* Revision 1.10  2002/02/18 12:05:18  loetzsch
* Percept visualization continued
*
* Revision 1.9  2002/02/12 16:34:49  risler
* finished MofTester
*
* Revision 1.8  2002/01/30 17:32:00  loetzsch
* Absturz wenn kleingeschoben ausgebaut
*
* Revision 1.7  2002/01/23 07:47:53  loetzsch
* Combo fr DebugKeys breiter gemacht
*
* Revision 1.6  2002/01/17 13:35:56  loetzsch
* sendLocal now sends the table to queueToLocalProcesses instead
* of queueToRobot
*
* Revision 1.5  2001/12/20 17:14:54  loetzsch
* Debugging mechanisms continued
*
* Revision 1.4  2001/12/16 17:18:55  loetzsch
* DebugKeyToolBar wieder groe Member Funktionsnamen eingebaut, Technote zu Toolbars
*
* Revision 1.3  2001/12/13 15:03:02  loetzsch
* DebugKeyToolBar fertig
*
* Revision 1.2  2001/12/13 12:58:16  loetzsch
* MemoryStick ToolBar hinzugefgt und an anderen Toolbars herumgebastelt
*
* Revision 1.1  2001/12/12 15:21:09  juengel
* CDebugKeyToolBar in eigenes .cpp und .h File verlagert.
*
*
*/
