/**
* @file DebugMessageGeneratorDlgBar.h
*
* Dialog to create debug messages by a text input that are not
* generated by other dialogs.
*
* @author Max Risler
*
*/

#ifndef __DebugMessageGeneratorDlgBar_h_
#define __DebugMessageGeneratorDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"

/**
* Class CDebugMessageGeneratorDlgBar
* Dialog to create debug messages
*/

class CDebugMessageGeneratorDlgBar : public CRobotControlDialogBar
{
public:
  /**
  * Default constructor.
  */
  CDebugMessageGeneratorDlgBar();

	//{{AFX_DATA(CDebugMessageGeneratorDlgBar)
	enum { IDD = IDD_DIALOG_BAR_DEBUGMESSAGEGENERATOR };
	CStatic	m_error;
	CButton	m_sendButton;
	CEdit	m_edit;
	CComboBox	m_combo;
	//}}AFX_DATA


	//{{AFX_VIRTUAL(CDebugMessageGeneratorDlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);
  virtual BOOL OnInitDialog();
  //}}AFX_VIRTUAL

protected:

	//{{AFX_MSG(CDebugMessageGeneratorDlgBar)
	afx_msg void OnSend();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP();
};

//{{AFX_INSERT_LOCATION}}

#endif // __DebugMessageGeneratorDlgBar_h_

/*
 * Change log :
 * 
 * $Log: DebugMessageGeneratorDlgBar.h,v $
 * Revision 1.1  2003/10/07 10:09:37  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2003/05/11 23:46:32  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.1  2002/09/10 15:49:04  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.3  2002/08/30 17:13:56  dueffert
 * doxygen parser bugs fixed, docu added
 *
 * Revision 1.2  2002/07/23 13:43:36  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - 5 instead of 3 debug queues in RobotControl
 * - exchanged StaticQueue with MessageQueue
 * - new debug message handling
 * - empty constructors in bars / dialogs
 * - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
 * - general clean up
 *
 * Revision 1.1.1.1  2002/05/10 12:40:20  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.2  2002/04/23 17:45:17  loetzsch
 * - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
 * - removed Modules Toolbar
 * - removed access for dialogs and toolbars to solutionRequest.
 * - changed access for dialogs and toolbars to debug queues
 * - removed the instance of SolutionRequest in CRobotControlApp
 * - only the log player, local processes and the robot put messages into queueToRobotControl
 *
 * Revision 1.1  2002/04/04 11:04:00  risler
 * added DebugMessageGenerator
 *
 *
 */
