/**
 *  @file HSIColorTableToolDlgBar.h
 *  Declaration of class CHSIColorTableToolDlgBar.
 *  @author<A href=mailto:kspiess@informatik.uni-bremen.de>Kai Spiess</A>
 */

#ifndef __HSIColorTableToolDlgBar_h_
#define __HSIColorTableToolDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"

#include "Dialogs/HSIColorTableToolZoomDlg.h"
#include "HSITools/HSIColorTableToolCore.h"

/**
 * @class CHSIColorTableToolDlgBar
 * A dialog bar for easy creating HSI colortables.
 * @author Kai Spiess
 */
class CHSIColorTableToolDlgBar : public CRobotControlDialogBar
{
public:
  /** The zoom dialog of this tool. */
	HSIColorTableToolZoomDlg m_hsiToolZoomDialog;
  /** The width of the painted rgb images. */
	int m_imageWidth;
  /** The height of the painted rgb images. */
	int m_imageHeight;
  /** This sets the sliders and the value text in the dialog for the specified color class.
   *  @param colorClass The color class.
   */
	void setSlidersForColorClass(int colorClass);

  /** 
  * Called from a MessageQueue to distribute messages 
  * @param message The message that can be read.
  * @return true if the message was read (handled).
  */
  virtual bool handleMessage(InMessage& message);
  
  Image m_rawYUVImage;
  /** The HSI colortable toolcore for this dialog.*/
	HSIColorTableToolCore m_hsiToolCore;
  /** Stores the actual image from the queue to the specified place in the toolcore.
   *  @param index The index of the place in the toolcore.
   */
	void captureImageInPlace(int index);
  /** The actual chosen color.*/
	int m_choosenColor;
  /** The upper left corners where the segmented images should be painted.*/
	CPoint m_segmentedImagePlace[4];
  /** The upper left corners where the RGB images should be painted.*/
	CPoint m_rgbImagePlace[4];

  /** Constructor */
 	CHSIColorTableToolDlgBar();

	//{{AFX_DATA(CHSIColorTableToolDlgBar)
	enum { IDD = IDD_DIALOG_BAR_HSICOLORTABLETOOL };
	CButton	m_captureButton1;
	CButton	m_updateImageFromQueue;
	CComboBox	m_hsiColorChooser;
	CEdit	m_IminValue;
	CEdit	m_ImaxValue;
	CEdit	m_SminValue;
	CEdit	m_SmaxValue;
	CEdit	m_HminValue;
	CEdit	m_HmaxValue;
	CSliderCtrl	m_IminSlider;
	CSliderCtrl	m_ImaxSlider;
	CSliderCtrl	m_SminSlider;
	CSliderCtrl	m_SmaxSlider;
	CSliderCtrl	m_HminSlider;
	CSliderCtrl	m_HmaxSlider;
	CStatic	m_HPaletteBitmapFrame;
	//}}AFX_DATA

	//{{AFX_VIRTUAL(CHSIColorTableToolDlgBar)
  protected:
	virtual void DoDataExchange(CDataExchange* pDX);
  virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL

protected:
	//{{AFX_MSG(CHSIColorTableToolDlgBar)
	afx_msg void OnPaint();
	afx_msg void OnHsicolortabletoolLoadcolortableButton();
	afx_msg void OnHsicolortabletoolSavecolortableButton();
	afx_msg void OnHsicolortabletoolCaptureButton1();
	afx_msg void OnHsicolortabletoolCaptureButton2();
	afx_msg void OnHsicolortabletoolCaptureButton3();
	afx_msg void OnHsicolortabletoolCaptureButton4();
	afx_msg void OnSelchangeHsicolortabletoolColorchooser();
	afx_msg void OnHsicolortabletoolUpdateCheck();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP();
};

//{{AFX_INSERT_LOCATION}}

#endif // __HSIColorTableToolDlgBar_h_

/*
 * Change log :
 * 
 * $Log: HSIColorTableToolDlgBar.h,v $
 * Revision 1.1  2003/10/07 10:09:37  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2003/05/11 23:46:33  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.1  2002/09/10 15:49:04  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.3  2002/08/30 17:13:56  dueffert
 * doxygen parser bugs fixed, docu added
 *
 * Revision 1.2  2002/07/23 13:43:36  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - 5 instead of 3 debug queues in RobotControl
 * - exchanged StaticQueue with MessageQueue
 * - new debug message handling
 * - empty constructors in bars / dialogs
 * - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
 * - general clean up
 *
 * Revision 1.1.1.1  2002/05/10 12:40:20  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.5  2002/04/23 17:45:16  loetzsch
 * - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
 * - removed Modules Toolbar
 * - removed access for dialogs and toolbars to solutionRequest.
 * - changed access for dialogs and toolbars to debug queues
 * - removed the instance of SolutionRequest in CRobotControlApp
 * - only the log player, local processes and the robot put messages into queueToRobotControl
 *
 * Revision 1.4  2002/04/08 18:09:32  kspiess
 * verschwinden des ersten capture-button bei update eingebaut
 *
 * Revision 1.3  2002/02/08 14:24:41  kspiess
 * Funktionalitt fr das HSIColorTableTool eingebaut.
 * Neuen Zoom-Dialog fr das HSIColorTableTool integriert.
 *
 * Revision 1.2  2002/02/04 23:39:48  kspiess
 * Erste Teile der Funktionalitt fr das HSIColorTableTool eingebaut
 *
 * Revision 1.1  2002/01/13 14:12:02  kspiess
 * HSIColorTableTool-Dialog in RobotControl eingebaut; Implementierung der Funktionalitaet kommt bald
 *
 *
 */
