/**
* @file HeadMotionTesterDlgBar.h
*
* Declaration of class CHeadMotionTesterDlgBar
*
* @author Martin Ltzsch
*/

#ifndef __HeadMotionTesterDlgBar_h_
#define __HeadMotionTesterDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"

#include "Representations/Motion/HeadControlMode.h"
#include "Representations/Motion/HeadMotionRequest.h"
#include "Tools/Actorics/RobotDimensions.h"

/**
* @class CHeadMotionTesterDlgBar 
* 
* A dialog bar to send head motion requests
*/
class CHeadMotionTesterDlgBar : public CRobotControlDialogBar, public RobotDimensionsERS210
{
public:
  /**
  * Default constructor.
  */
  CHeadMotionTesterDlgBar();

	//{{AFX_DATA(CHeadMotionTesterDlgBar)
	enum { IDD = IDD_DIALOG_BAR_HEADMOTIONTESTER };
	CEdit	m_zEdit;
  CButton m_RadioMode;
  CButton m_RadioRequest;
	CListBox	m_ControlModeList;
	CStatic	m_TiltStatic;
	CEdit  	m_TiltValueEdit;
	CButton	m_SendButton;
	CStatic	m_RollStatic;
	CEdit  	m_RollValueEdit;
	CButton	m_ResetButton;
	CStatic	m_PanStatic;
	CEdit  	m_PanValueEdit;
	CStatic	m_MouthStatic;
	CEdit  	m_MouthValueEdit;
	CSliderCtrl	m_TiltSlider;
	CSliderCtrl	m_RollSlider;
	CSliderCtrl	m_PanSlider;
	CSliderCtrl	m_MouthSlider;
  CStatic m_xStatic;
  CEdit m_xEdit;
  CEdit m_yEdit;
  CStatic m_xOffsetStatic;
  CEdit m_xOffsetEdit;
  CEdit m_yOffsetEdit;
  CButton m_ERS7Check;
	//}}AFX_DATA


	//{{AFX_VIRTUAL(CHeadMotionTesterDlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    
  virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL

  void showCurrentHeadMotion(int mode);

protected:
  HeadMotionRequest headMotionRequest;
  HeadControlMode headControlMode;

  unsigned long lastSentTime;
  bool sendAllowed;

  //{{AFX_MSG(CHeadMotionTesterDlgBar)
	afx_msg void OnSend();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnRadioMode();
	afx_msg void OnRadioRequest();
	afx_msg void OnReset();
	afx_msg void OnSelchangeModeList();
	afx_msg void OnDblclkModeList();
	afx_msg void OnERS7Check();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP();
};

//{{AFX_INSERT_LOCATION}}

#endif //__HeadMotionTesterDlgBar_h_

/*
 * Change log :
 * 
 * $Log: HeadMotionTesterDlgBar.h,v $
 * Revision 1.6  2004/04/07 13:00:46  risler
 * ddd checkin after go04 - second part
 *
 * Revision 1.2  2004/04/02 22:15:13  dthomas
 * added mouth-slider to head-motion-tester
 *
 * Revision 1.1.1.1  2004/03/29 08:28:44  Administrator
 * initial transfer from tamara
 *
 * Revision 1.5  2004/03/17 10:26:07  jhoffman
 * - removed display problems in dialogs
 * - brushed up ugly dialogs
 *
 * Revision 1.4  2004/03/15 14:48:10  kerdels
 * modified Head Motion Tester Dialog to view the joint-values sent
 *
 * Revision 1.3  2004/01/28 18:22:59  fritsche
 * ERS7-Chechbox added in HeadMotionTester
 *
 * Revision 1.2  2004/01/01 10:58:51  roefer
 * RobotDimensions are in a class now
 *
 * Revision 1.1  2003/10/07 10:09:37  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/26 15:28:23  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2003/05/27 15:50:59  dueffert
 * dialog became smarter
 *
 * Revision 1.2  2003/05/11 23:46:33  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.1  2002/09/10 15:49:05  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.5  2002/08/30 17:13:56  dueffert
 * doxygen parser bugs fixed, docu added
 *
 * Revision 1.4  2002/07/23 13:43:36  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - 5 instead of 3 debug queues in RobotControl
 * - exchanged StaticQueue with MessageQueue
 * - new debug message handling
 * - empty constructors in bars / dialogs
 * - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
 * - general clean up
 *
 * Revision 1.3  2002/05/25 17:37:03  juengel
 * 3D and offset for lookAtPoint
 *
 * Revision 1.2  2002/05/15 08:01:37  kosen
 * offset in lookAtPoint added
 *
 * Revision 1.1.1.1  2002/05/10 12:40:20  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.9  2002/04/26 12:27:15  loetzsch
 * removed the "default .... " radio from the head motion tester dialog bar
 *
 * Revision 1.8  2002/04/23 17:45:17  loetzsch
 * - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
 * - removed Modules Toolbar
 * - removed access for dialogs and toolbars to solutionRequest.
 * - changed access for dialogs and toolbars to debug queues
 * - removed the instance of SolutionRequest in CRobotControlApp
 * - only the log player, local processes and the robot put messages into queueToRobotControl
 *
 * Revision 1.7  2002/03/20 15:15:29  kosen
 * lookAtPoint added
 *
 * Revision 1.6  2002/02/12 16:34:49  risler
 * finished MofTester
 *
 * Revision 1.5  2002/01/23 14:18:18  risler
 * send on dblclick
 *
 * Revision 1.4  2002/01/19 21:36:26  risler
 * added HeadMotionTester, HeadControlSelector
 *
 * Revision 1.3  2002/01/18 23:28:48  loetzsch
 * provided access to queueToRobot and to queueToRobotControl,
 * OnSend() added
 *
 * Revision 1.2  2001/12/10 17:47:09  risler
 * change log added
 *
 */
