/**
* @file HistogramDlgBar.h
*
* Declaration of class CHistogramDlgBar
*
* @author Matthias Jngel
*/

#ifndef __HistogramDlgBar_h_
#define __HistogramDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"

#include "Tools/Math/Histogram.h"


/**
* @class CHistogramDlgBar 
* 
* A dialog bar to view time diagrams
*/
class CHistogramDlgBar : public CRobotControlDialogBar
{
public:
  /**
  * Default constructor.
  */
  CHistogramDlgBar();

	~CHistogramDlgBar();   
  
  /** 
  * Called from a MessageQueue to distribute messages 
  * @param message The message that can be read.
  * @return true if the message was read (handled).
  */
  virtual bool handleMessage(InMessage& message);

	//{{AFX_DATA(CHistogramDlgBar)
	enum { IDD = IDD_DIALOG_BAR_HISTOGRAM };
	CSliderCtrl	m_scaleSlider;
	CEdit	m_scaleEdit;
	CSliderCtrl	m_numberSlider;
	CEdit	m_numberEdit;
	//}}AFX_DATA


	//{{AFX_VIRTUAL(CHistogramDlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    
  virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL

protected:

	//{{AFX_MSG(CHistogramDlgBar)
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP();
private:
	void deleteBrushes();
	void createBrushes();

  void saveCurrentSelection();
  void loadSelection();

  void unselectAll();
  void exportToFileAsCSV();

  void paintHistogram(
    Histogram& histogram, 
    CRect& rectForPainting, 
    double scale,
    bool showAverage,
    bool showAverageOfFrequencies,
    bool showClusters
    );

  void paintHistograms();

  void setSliders();

  double scaleSliderPositionToScale(int scaleSliderPosition);
  int scaleToScaleSliderPosition(double scale);

  //display ////////
  CRect rect;
  CRect currentRect;

  CDC dcOffScreen;
  CBitmap* bmpOffScreen;
  CBitmap* oldBitmap;

  CBrush brush[Histogram::numberOfHistogramIDs];
  COLORREF crColor[Histogram::numberOfHistogramIDs];
  CBrush* oldBrush;

  int numberOfHistograms;

  enum{maxNumberOfHistograms = 100};
  CRect histogramRect[maxNumberOfHistograms];
  Histogram::HistogramID histogramID[maxNumberOfHistograms];
  double scale[maxNumberOfHistograms];
  bool showAverage[maxNumberOfHistograms];
  bool showAverageOfFrequencies[maxNumberOfHistograms];
  bool showClusters[maxNumberOfHistograms];

  int scaleSliderPosition;

  void calculateRects();

  int numberOfRows, numberOfColumns;

  int mouseOverRow;
  int mouseOverColumn;

  int currentSelection;

  //data
  Histogram histograms[Histogram::numberOfHistogramIDs];
};

//{{AFX_INSERT_LOCATION}}

#endif //__HistogramDlgBar_h_

/*
 * Change log :
 * 
 * $Log: HistogramDlgBar.h,v $
 * Revision 1.2  2003/12/15 11:47:05  juengel
 * Introduced CameraInfo
 *
 * Revision 1.1  2003/10/07 10:09:37  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/26 11:40:12  juengel
 * - sorted tools
 * - clean-up in DataTypes
 *
 * Revision 1.1  2003/08/25 17:19:54  juengel
 * Added Histogram
 *
 */
