/**
* @file InvKinParametersDlgBar.cpp
*
* Implementation of class InvKinParametersDlgBar
*
* @author Arthur Cesarz
* @author Matthias Hebbel
*/
#include "StdAfx.h"
#include "InvKinParametersDlgBar.h"
#include "Modules/WalkingEngine/InvKinWalkingParameterSets.h"

#include "Representations/Motion/PIDData.h"
#include "Platform/SystemCall.h"
#include "RobotControlQueues.h"

#define SETOFVALUES(paramName) minParam.##paramName, \
                               maxParam.##paramName, \
                               pIndividual->##paramName

CInvKinParametersDlgBar::CInvKinParametersDlgBar(CWnd* pParent /*=NULL*/)
	: CRobotControlDialogBar(IDD)
{
	//{{AFX_DATA_INIT(CInvKinParametersDlgBar)
	//}}AFX_DATA_INIT
}

void CInvKinParametersDlgBar::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CInvKinParametersDlgBar)
	DDX_Control(pDX, IDC_INVKINPAR_BUTTON_SEND,           m_ButtonSend);
	DDX_Control(pDX, IDC_INVKINPAR_CHECKBOX,              m_Checkbox);
  DDX_Control(pDX, IDC_INVKINPAR_RADIO_PARENT,          m_Parent);
  DDX_Control(pDX, IDC_INVKINPAR_RADIO_OFFSPRING,       m_Offspring);
  DDX_Control(pDX, IDC_INVKINPAR_VALUEDISTANCE, m_ValueDistance);
  DDX_Control(pDX, IDC_INVKINPAR_VALUEMUTATIONSTRENGTH, m_ValueMutationStrength);

	DDX_Control(pDX, IDC_INVKINPAR_COMBOFOOTMODE,         m_ComboFootMode);
  DDX_Control(pDX, IDC_INVKINPAR_VALUEFOREHEIGHT,       m_Value_foreHeight);
	DDX_Control(pDX, IDC_INVKINPAR_VALUEFOREWIDTH,        m_Value_foreWidth);
	DDX_Control(pDX, IDC_INVKINPAR_VALUEFORECENTERX,      m_Value_foreCenterX);
	DDX_Control(pDX, IDC_INVKINPAR_VALUEHINDHEIGHT,       m_Value_hindHeight);
	DDX_Control(pDX, IDC_INVKINPAR_VALUEHINDWIDTH,        m_Value_hindWidth);
	DDX_Control(pDX, IDC_INVKINPAR_VALUEHINDCENTERX,      m_Value_hindCenterX);
	DDX_Control(pDX, IDC_INVKINPAR_VALUEFOOTLIFTFORE,     m_Value_foreFootLift);
	DDX_Control(pDX, IDC_INVKINPAR_VALUEFOOTLIFTHIND,     m_Value_hindFootLift);
	DDX_Control(pDX, IDC_INVKINPAR_VALUEFOOTTILTFORE,     m_Value_foreFootTilt);
	DDX_Control(pDX, IDC_INVKINPAR_VALUEFOOTTILTHIND,     m_Value_hindFootTilt);
	DDX_Control(pDX, IDC_INVKINPAR_VALUELEGSPEEDFACTORX,  m_Value_legSpeedFactorX);
	DDX_Control(pDX, IDC_INVKINPAR_VALUELEGSPEEDFACTORY,  m_Value_legSpeedFactorY);
	DDX_Control(pDX, IDC_INVKINPAR_VALUELEGSPEEDFACTORR,  m_Value_legSpeedFactorR);
	DDX_Control(pDX, IDC_INVKINPAR_VALUEMAXIMUMSTEPSIZEX, m_Value_maxStepSizeX);
	DDX_Control(pDX, IDC_INVKINPAR_VALUEMAXIMUMSTEPSIZEY, m_Value_maxStepSizeY);
	DDX_Control(pDX, IDC_INVKINPAR_VALUEMAXIMUMCHANGESPEEDX, m_Value_maxSpeedXChange);
	DDX_Control(pDX, IDC_INVKINPAR_VALUEMAXIMUMCHANGESPEEDY, m_Value_maxSpeedYChange);
	DDX_Control(pDX, IDC_INVKINPAR_VALUEMAXIMUMCHANGEROTATION, m_Value_maxRotationChange);
	DDX_Control(pDX, IDC_INVKINPAR_VALUECOUNTERROTATION,  m_Value_counterRotation);
  DDX_Control(pDX, IDC_INVKINPAR_VALUESTEPLENGTH,       m_Value_stepLen);
  DDX_Control(pDX, IDC_INVKINPAR_VALUEGROUNDPHASEF,     m_Value_groundPhase[0]);
	DDX_Control(pDX, IDC_INVKINPAR_VALUELIFTPHASEF,       m_Value_liftPhase[0]);
	DDX_Control(pDX, IDC_INVKINPAR_VALUELOWERPHASEF,      m_Value_loweringPhase[0]);
	DDX_Control(pDX, IDC_INVKINPAR_VALUEGROUNDPHASEH,     m_Value_groundPhase[1]);
	DDX_Control(pDX, IDC_INVKINPAR_VALUELIFTPHASEH,       m_Value_liftPhase[1]);
	DDX_Control(pDX, IDC_INVKINPAR_VALUELOWERPHASEH,      m_Value_loweringPhase[1]);
	DDX_Control(pDX, IDC_INVKINPAR_VALUELEGPH0,           m_Value_legPhase[0]);
	DDX_Control(pDX, IDC_INVKINPAR_VALUELEGPH1,           m_Value_legPhase[1]);
	DDX_Control(pDX, IDC_INVKINPAR_VALUELEGPH2,           m_Value_legPhase[2]);
	DDX_Control(pDX, IDC_INVKINPAR_VALUELEGPH3,           m_Value_legPhase[3]);
	DDX_Control(pDX, IDC_INVKINPAR_VALUEBODYSHIFTX,       m_Value_bodyShiftX);
	DDX_Control(pDX, IDC_INVKINPAR_VALUEBODYSHIFTY,       m_Value_bodyShiftY);
	DDX_Control(pDX, IDC_INVKINPAR_VALUEBODYSHIFTOFFSET,  m_Value_bodyShiftOffset);
	DDX_Control(pDX, IDC_INVKINPAR_VALUEBODYTILTOFFSET,   m_Value_bodyTiltOffset);

  DDX_Control(pDX, IDC_INVKINPAR_SLIDERFOREHEIGHT,      m_Slider_foreHeight);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERFOREWIDTH,       m_Slider_foreWidth);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERFORECENTERX,     m_Slider_foreCenterX);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERHINDHEIGHT,      m_Slider_hindHeight);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERHINDWIDTH,       m_Slider_hindWidth);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERHINDCENTERX,     m_Slider_hindCenterX);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERFOOTLIFTFORE,    m_Slider_foreFootLift);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERFOOTLIFTHIND,    m_Slider_hindFootLift);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERFOOTTILTFORE,    m_Slider_foreFootTilt);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERFOOTTILTHIND,    m_Slider_hindFootTilt);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERLEGSPEEDFACTORX, m_Slider_legSpeedFactorX);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERLEGSPEEDFACTORY, m_Slider_legSpeedFactorY);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERLEGSPEEDFACTORR, m_Slider_legSpeedFactorR);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERMAXIMUMSTEPSIZEX, m_Slider_maxStepSizeX);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERMAXIMUMSTEPSIZEY, m_Slider_maxStepSizeY);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERMAXIMUMCHANGESPEEDX, m_Slider_maxSpeedXChange);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERMAXIMUMCHANGESPEEDY, m_Slider_maxSpeedYChange);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERMAXIMUMCHANGEROTATION, m_Slider_maxRotationChange);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERCOUNTERROTATION, m_Slider_counterRotation);
  DDX_Control(pDX, IDC_INVKINPAR_SLIDERSTEPLENGTH,      m_Slider_stepLen);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERGROUNDPHASEF,    m_Slider_groundPhase[0]);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERLIFTPHASEF,      m_Slider_liftPhase[0]);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERLOWERPHASEF,     m_Slider_loweringPhase[0]);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERGROUNDPHASEH,    m_Slider_groundPhase[1]);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERLIFTPHASEH,      m_Slider_liftPhase[1]);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERLOWERPHASEH,     m_Slider_loweringPhase[1]);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERLEGPH0,          m_Slider_legPhase[0]);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERLEGPH1,          m_Slider_legPhase[1]);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERLEGPH2,          m_Slider_legPhase[2]);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERLEGPH3,          m_Slider_legPhase[3]);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERBODYSHIFTX,      m_Slider_bodyShiftX);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERBODYSHIFTY,      m_Slider_bodyShiftY);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERBODYSHIFTOFFSET, m_Slider_bodyShiftOffset);
	DDX_Control(pDX, IDC_INVKINPAR_SLIDERBODYTILTOFFSET,  m_Slider_bodyTiltOffset);
  //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CInvKinParametersDlgBar, CDynamicBarDlg)
	//{{AFX_MSG_MAP(CInvKinParametersDlgBar)
	ON_BN_CLICKED(IDC_INVKINPAR_CHECKBOX,                 OnInvKinParCheckbox)
  ON_BN_CLICKED(IDC_INVKINPAR_BUTTON_SEND,              OnButtonSend)
  ON_BN_CLICKED(IDC_INVKINPAR_BUTTON_MUTATE,            OnButtonMutate)
  ON_BN_CLICKED(IDC_INVKINPAR_BUTTON_WALK,              OnWalkParamWalk)
  ON_BN_CLICKED(IDC_INVKINPAR_RADIO_PARENT,             OnSelectParent)
  ON_BN_CLICKED(IDC_INVKINPAR_RADIO_OFFSPRING,          OnSelectOffspring)
  ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEDISTANCE,          OnChangeDistance)
  ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEMUTATIONSTRENGTH,  OnChangeMutationStrength)
	ON_CBN_SELCHANGE(IDC_INVKINPAR_COMBOFOOTMODE,         OnSelchangeInvKinParComboFootMode)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEFOREHEIGHT,        OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEFOREWIDTH,         OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEFORECENTERX,       OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEHINDHEIGHT,        OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEHINDWIDTH,         OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEHINDCENTERX,       OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEFOOTLIFTFORE,      OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEFOOTLIFTHIND,      OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEFOOTTILTFORE,      OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEFOOTTILTHIND,      OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUELEGSPEEDFACTORX,   OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUELEGSPEEDFACTORY,   OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUELEGSPEEDFACTORR,   OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEMAXIMUMSTEPSIZEX,  OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEMAXIMUMSTEPSIZEY,  OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEMAXIMUMCHANGESPEEDX, OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEMAXIMUMCHANGESPEEDY, OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEMAXIMUMCHANGEROTATION, OnKillFocusEditCtrls)
  ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUECOUNTERROTATION,   OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUESTEPLENGTH,        OnKillFocusEditCtrls)
  ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEGROUNDPHASEF,      OnKillFocusEditCtrls)
  ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUELIFTPHASEF,        OnKillFocusEditCtrls)
  ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUELOWERPHASEF,       OnKillFocusEditCtrls)
  ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEGROUNDPHASEH,      OnKillFocusEditCtrls)
  ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUELIFTPHASEH,        OnKillFocusEditCtrls)
  ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUELOWERPHASEH,       OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUELEGPH0,            OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUELEGPH1,            OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUELEGPH2,            OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUELEGPH3,            OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEBODYSHIFTX,        OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEBODYSHIFTY,        OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEBODYSHIFTOFFSET,   OnKillFocusEditCtrls)
	ON_EN_KILLFOCUS(IDC_INVKINPAR_VALUEBODYTILTOFFSET,    OnKillFocusEditCtrls)

	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERFOREHEIGHT,      OnCustomdrawSlider_foreHeight)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERFOREWIDTH,       OnCustomdrawSlider_foreWidth)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERFORECENTERX,     OnCustomdrawSlider_foreCenterX)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERHINDHEIGHT,      OnCustomdrawSlider_hindHeight)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERHINDWIDTH,       OnCustomdrawSlider_hindWidth)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERHINDCENTERX,     OnCustomdrawSlider_hindCenterX)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERFOOTLIFTFORE,    OnCustomdrawSlider_foreFootLift)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERFOOTLIFTHIND,    OnCustomdrawSlider_hindFootLift)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERFOOTTILTFORE,    OnCustomdrawSlider_foreFootTilt)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERFOOTTILTHIND,    OnCustomdrawSlider_hindFootTilt)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERLEGSPEEDFACTORR, OnCustomdrawSlider_legSpeedFactorR)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERLEGSPEEDFACTORX, OnCustomdrawSlider_legSpeedFactorX)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERLEGSPEEDFACTORY, OnCustomdrawSlider_legSpeedFactorY)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERMAXIMUMSTEPSIZEX, OnCustomdrawSlider_maxStepSizeX)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERMAXIMUMSTEPSIZEY, OnCustomdrawSlider_maxStepSizeY)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERMAXIMUMCHANGESPEEDX, OnCustomdrawSlider_maxSpeedXChange)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERMAXIMUMCHANGESPEEDY, OnCustomdrawSlider_maxSpeedYChange)
  ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERMAXIMUMCHANGEROTATION, OnCustomdrawSlider_maxRotationChange)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERCOUNTERROTATION, OnCustomdrawSlider_counterRotation)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERSTEPLENGTH, OnCustomdrawSlider_stepLen)
  ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERGROUNDPHASEF,    OnCustomdrawSlider_groundPhase0)
  ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERLIFTPHASEF,      OnCustomdrawSlider_liftPhase0)
  ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERLOWERPHASEF,     OnCustomdrawSlider_loweringPhase0)
  ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERGROUNDPHASEH,    OnCustomdrawSlider_groundPhase1)
  ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERLIFTPHASEH,      OnCustomdrawSlider_liftPhase1)
  ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERLOWERPHASEH,     OnCustomdrawSlider_loweringPhase1)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERLEGPH0,          OnCustomdrawSlider_legPhase0)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERLEGPH1,          OnCustomdrawSlider_legPhase1)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERLEGPH2,          OnCustomdrawSlider_legPhase2)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERLEGPH3,          OnCustomdrawSlider_legPhase3)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERBODYSHIFTX,      OnCustomdrawSlider_bodyShiftX)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERBODYSHIFTY,      OnCustomdrawSlider_bodyShiftY)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERBODYSHIFTOFFSET, OnCustomdrawSlider_bodyShiftOffset)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_INVKINPAR_SLIDERBODYTILTOFFSET,  OnCustomdrawSlider_bodyTiltOffset)

  ON_WM_CONTEXTMENU()
  //}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CInvKinParametersDlgBar::updateUI(CCmdUI* pCmdUI)
{
  switch(pCmdUI->m_nID)
  {
  case IDC_INVKINPAR_BUTTON_SEND:
    pCmdUI->Enable(!sendOnChange);
    break;
  case IDC_INVKINPAR_BUTTON_MUTATE:
  case IDC_INVKINPAR_RADIO_PARENT:
  case IDC_INVKINPAR_RADIO_OFFSPRING:
    pCmdUI->Enable(!walking);
    break;
  default:
    break;
  }
}

BOOL CInvKinParametersDlgBar::OnInitDialog()
{
  CDynamicBarDlg::OnInitDialog();
  // TODO: Load DefaultIndividual from file instead of setRanges() and setDefaults()

  smallFont.CreateFont(12,0,0,0,FW_NORMAL,FALSE,FALSE,0,ANSI_CHARSET,
    OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,
    DEFAULT_PITCH | FF_SWISS,"Arial");

  pIndividual = &parentParam;
  setRanges();
  setDefaults();
  initControls();
  lastSentTimeA = 0;
  lastSentTimeB = 0;
  walking       = false;
  sendOnChange  = false;
  autoMutationStrength = true;
  distance             = 2100;
  mutationStrength     = 5.0;
  loggedMutStrength    = 0.0;
  numberOfMutations    = 0;
  numberOfSuccessfulMutations = 0;

  tFormat(buffer, mutationStrength);
  m_ValueDistance.SetWindowText(itoa(distance,tmp,10));
  m_ValueMutationStrength.SetWindowText(buffer);
  m_Parent.SetCheck(true);
  m_Offspring.SetCheck(false);

  readContextMenu();
  
  GetDlgItem(IDC_INVKINPAR_TEXTFOREHEIGHT)->  SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTFOREWIDTH)->   SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTFORECENTERX)-> SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTHINDHEIGHT)->  SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTHINDWIDTH)->   SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTHINDCENTERX)-> SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTFOOTLIFTFORE)->SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTFOOTLIFTHIND)->SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTFOOTTILTFORE)->SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTFOOTTILTHIND)->SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTLEGSPEEDX)->   SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTLEGSPEEDY)->   SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTLEGSPEEDR)->   SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTMAXSTEPX)->    SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTMAXSTEPY)->    SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTMAXCHASPEX)->  SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTMAXCHASPEY)->  SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTMAXCHAROT)->   SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTCOUNTERROTATION)->SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTSTEPLENGTH)->  SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTGROUNDPHASEF)->SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTLIFTPHASEF)->  SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTLOWERPHASEF)-> SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTGROUNDPHASEH)->SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTLIFTPHASEH)->  SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTLOWERPHASEH)-> SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTLEGPH0)->      SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTLEGPH1)->      SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTLEGPH2)->      SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTLEGPH3)->      SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTBODYSHIFTX)->  SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTBODYSHIFTY)->  SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTSHIFTOFFSET)-> SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_TEXTTILTOFFSET)->  SetFont( &smallFont );
  GetDlgItem(IDC_INVKINPAR_CHECKBOX)->        SetFont( &smallFont ); 
  return TRUE;
}

void CInvKinParametersDlgBar::setRanges()
{
  InvKinWalkingParameters minParamTemp(
    "", 0, -120.0,  50.0, -100.0, -120.0,  50.0, -100.0,
    -40.0,  -40.0,  -1.0,   -1.0,    0.0,   0.0,    0.0,
      0.0,    0.0,   0.0,    0.0,    0.0,  -0.5,     20,
      0.0,    0.0,  -0.4,    0.0,    0.0,  -0.4,   -1.0, 
      0.0,    0.0,   0.0,   -2.0,   -2.0,  -2.0,   -0.5);

  InvKinWalkingParameters maxParamTemp(
    "", 5,  140.0, 180.0,  160.0,  160.0,  180.0,   0.0,
    100.0,  100.0,   1.0,    1.0,    2.0,    2.0,   2.0,
    100.0,  100.0, 200.0,  200.0,    2.0,    0.5,   400,
      1.0,   1.0,   1.0,    1.0,    1.0,    1.0,    1.0, 
      1.0,   1.0,   1.0,    2.0,    2.0,    2.0,    0.5);
  
  minParam = minParamTemp;
  maxParam = maxParamTemp;
}


void CInvKinParametersDlgBar::setDefaults()
{
  Quick2UNSWWalkingParameters defaultParam;

  parentParam=defaultParam;
  evolveParam=defaultParam;
}


#define INITCONTROL(paramName) m_Slider_##paramName.SetRange(0, 10000, TRUE)

void CInvKinParametersDlgBar::initControls()
{
  INITCONTROL(foreHeight);
  INITCONTROL(foreWidth);
  INITCONTROL(foreCenterX);
  INITCONTROL(hindHeight);
  INITCONTROL(hindWidth);
  INITCONTROL(hindCenterX);
  INITCONTROL(foreFootLift);
  INITCONTROL(hindFootLift);
  INITCONTROL(foreFootTilt);
  INITCONTROL(hindFootTilt);
  INITCONTROL(legSpeedFactorX);
  INITCONTROL(legSpeedFactorY);
  INITCONTROL(legSpeedFactorR);
  INITCONTROL(maxStepSizeX);
  INITCONTROL(maxStepSizeY);
  INITCONTROL(maxSpeedXChange);
  INITCONTROL(maxSpeedYChange);
  INITCONTROL(maxRotationChange);
  INITCONTROL(counterRotation);
  INITCONTROL(stepLen);
  INITCONTROL(groundPhase[0]);  
  INITCONTROL(liftPhase[0]);  
  INITCONTROL(loweringPhase[0]);  
  INITCONTROL(groundPhase[1]);  
  INITCONTROL(liftPhase[1]);  
  INITCONTROL(loweringPhase[1]);  
  for (int i=0; i<4; i++)
    INITCONTROL(legPhase[i]);
  INITCONTROL(bodyShiftX);  
  INITCONTROL(bodyShiftY);  
  INITCONTROL(bodyShiftOffset);  
  INITCONTROL(bodyTiltOffset);  

  m_ComboFootMode.AddString("rectangle");
  m_ComboFootMode.AddString("halfCircle");
  m_ComboFootMode.AddString("circle");
  m_ComboFootMode.AddString("rounded");
  m_ComboFootMode.AddString("optimized");
  m_ComboFootMode.AddString("freeFormQuad");

  updateControls();
}

int CInvKinParametersDlgBar::valueToSliderPos(double min, double max, double value)
{
  return (int)(10000.0/(max-min)*(max-value));
}

double CInvKinParametersDlgBar::sliderPosToValue(int position, double min, double max)
{
  return (double)(max+min-(((max-min)/10000.0)*position + min));
}

void CInvKinParametersDlgBar::OnCustomdrawSlider(double min, double max, double& value,
                                                 CSliderCtrl	&slider, CEdit	&textctrl)
{
  value = sliderPosToValue(slider.GetPos(), min, max);
  tFormat(buffer, value);
  textctrl.SetWindowText(buffer);
  if (sendOnChange == true) OnButtonSend();
}


#define ONCUSTOMDRAWSLIDER(paramName) \
            void CInvKinParametersDlgBar::OnCustomdrawSlider_##paramName\
            (NMHDR* pNHMDR, LRESULT* pResult)\
            { OnCustomdrawSlider((double)minParam.##paramName, \
                                 (double)maxParam.##paramName, \
                                 (double&)pIndividual->##paramName, \
                                 m_Slider_##paramName, \
                                 m_Value_##paramName);\
              *pResult = 0;\
            }
#define ONCUSTOMDRAWSLIDER2(paramName, number) \
            void CInvKinParametersDlgBar::OnCustomdrawSlider_##paramName##number\
            (NMHDR* pNHMDR, LRESULT* pResult)\
            { OnCustomdrawSlider((double)minParam.##paramName[##number], \
                                 (double)maxParam.##paramName[##number], \
                                 (double&)pIndividual->##paramName[##number], \
                                 m_Slider_##paramName[##number], \
                                 m_Value_##paramName[##number]);\
              *pResult = 0;\
            }

ONCUSTOMDRAWSLIDER(foreHeight);
ONCUSTOMDRAWSLIDER(foreWidth);
ONCUSTOMDRAWSLIDER(foreCenterX);
ONCUSTOMDRAWSLIDER(hindHeight);
ONCUSTOMDRAWSLIDER(hindWidth);
ONCUSTOMDRAWSLIDER(hindCenterX);
ONCUSTOMDRAWSLIDER(foreFootLift);
ONCUSTOMDRAWSLIDER(hindFootLift);
ONCUSTOMDRAWSLIDER(foreFootTilt);
ONCUSTOMDRAWSLIDER(hindFootTilt);
ONCUSTOMDRAWSLIDER(legSpeedFactorX);
ONCUSTOMDRAWSLIDER(legSpeedFactorY);
ONCUSTOMDRAWSLIDER(legSpeedFactorR);
ONCUSTOMDRAWSLIDER(maxStepSizeX);
ONCUSTOMDRAWSLIDER(maxStepSizeY);
ONCUSTOMDRAWSLIDER(maxSpeedXChange);
ONCUSTOMDRAWSLIDER(maxSpeedYChange);
ONCUSTOMDRAWSLIDER(maxRotationChange);
ONCUSTOMDRAWSLIDER(counterRotation);
// ONCUSTOMDRAWSLIDER(stepLen);
ONCUSTOMDRAWSLIDER2(groundPhase, 0);
ONCUSTOMDRAWSLIDER2(liftPhase, 0);
ONCUSTOMDRAWSLIDER2(loweringPhase, 0);
ONCUSTOMDRAWSLIDER2(groundPhase, 1);
ONCUSTOMDRAWSLIDER2(liftPhase, 1);
ONCUSTOMDRAWSLIDER2(loweringPhase, 1);
ONCUSTOMDRAWSLIDER2(legPhase, 0);
ONCUSTOMDRAWSLIDER2(legPhase, 1);
ONCUSTOMDRAWSLIDER2(legPhase, 2);
ONCUSTOMDRAWSLIDER2(legPhase, 3);
ONCUSTOMDRAWSLIDER(bodyShiftX);
ONCUSTOMDRAWSLIDER(bodyShiftY);
ONCUSTOMDRAWSLIDER(bodyShiftOffset);
ONCUSTOMDRAWSLIDER(bodyTiltOffset);


void CInvKinParametersDlgBar::OnCustomdrawSlider_stepLen(NMHDR* pNMHDR, LRESULT* pResult)
{
  double doubleStepLen;
  OnCustomdrawSlider((double)minParam.stepLen, (double)maxParam.stepLen, doubleStepLen, m_Slider_stepLen, m_Value_stepLen);
  pIndividual->stepLen=(int)doubleStepLen;
	*pResult = 0;
}

void CInvKinParametersDlgBar::setSlider(double min, double max, double value,
                                         CSliderCtrl	&slider, CEdit	&textctrl)
{
  if (value > max)
  {
    value = max;
  }
  if (value < min)
  {
    value = min;
  }
  slider.SetPos(valueToSliderPos(min, max, value));
  tFormat(buffer, value);
  textctrl.SetFont( &smallFont );
  textctrl.SetWindowText(buffer);
}


void CInvKinParametersDlgBar::updateControls()
{
  m_ComboFootMode.SetCurSel(pIndividual->footMode);
  setSlider(SETOFVALUES(foreHeight),  m_Slider_foreHeight,  m_Value_foreHeight);
  setSlider(SETOFVALUES(foreWidth),   m_Slider_foreWidth,   m_Value_foreWidth);
  setSlider(SETOFVALUES(foreCenterX), m_Slider_foreCenterX, m_Value_foreCenterX);
  setSlider(SETOFVALUES(hindHeight),  m_Slider_hindHeight,  m_Value_hindHeight);
  setSlider(SETOFVALUES(hindWidth),   m_Slider_hindWidth,   m_Value_hindWidth);
  setSlider(SETOFVALUES(hindCenterX), m_Slider_hindCenterX, m_Value_hindCenterX);
  setSlider(SETOFVALUES(foreFootLift), m_Slider_foreFootLift, m_Value_foreFootLift);
  setSlider(SETOFVALUES(hindFootLift), m_Slider_hindFootLift, m_Value_hindFootLift);
  setSlider(SETOFVALUES(foreFootTilt), m_Slider_foreFootTilt, m_Value_foreFootTilt);
  setSlider(SETOFVALUES(hindFootTilt), m_Slider_hindFootTilt, m_Value_hindFootTilt);
  setSlider(SETOFVALUES(legSpeedFactorX), m_Slider_legSpeedFactorX, m_Value_legSpeedFactorX);
  setSlider(SETOFVALUES(legSpeedFactorY), m_Slider_legSpeedFactorY, m_Value_legSpeedFactorY);
  setSlider(SETOFVALUES(legSpeedFactorR), m_Slider_legSpeedFactorR, m_Value_legSpeedFactorR);
  setSlider(SETOFVALUES(maxStepSizeX), m_Slider_maxStepSizeX, m_Value_maxStepSizeX);
  setSlider(SETOFVALUES(maxStepSizeY), m_Slider_maxStepSizeY, m_Value_maxStepSizeY);
  setSlider(SETOFVALUES(maxSpeedXChange), m_Slider_maxSpeedXChange, m_Value_maxSpeedXChange);
  setSlider(SETOFVALUES(maxSpeedYChange), m_Slider_maxSpeedYChange, m_Value_maxSpeedYChange);
  setSlider(SETOFVALUES(maxRotationChange), m_Slider_maxRotationChange, m_Value_maxRotationChange);
  setSlider(SETOFVALUES(counterRotation), m_Slider_counterRotation, m_Value_counterRotation);
  setSlider(SETOFVALUES(stepLen), m_Slider_stepLen, m_Value_stepLen);
  setSlider(SETOFVALUES(groundPhase[0]), m_Slider_groundPhase[0], m_Value_groundPhase[0]);
  setSlider(SETOFVALUES(liftPhase[0]), m_Slider_liftPhase[0], m_Value_liftPhase[0]);
  setSlider(SETOFVALUES(loweringPhase[0]), m_Slider_loweringPhase[0], m_Value_loweringPhase[0]);
  setSlider(SETOFVALUES(groundPhase[1]), m_Slider_groundPhase[1], m_Value_groundPhase[1]);
  setSlider(SETOFVALUES(liftPhase[1]), m_Slider_liftPhase[1], m_Value_liftPhase[1]);
  setSlider(SETOFVALUES(loweringPhase[1]), m_Slider_loweringPhase[1], m_Value_loweringPhase[1]);
  for( int i = 0; i < 4; i++ )
    setSlider(SETOFVALUES(legPhase[i]), m_Slider_legPhase[i], m_Value_legPhase[i]);
  setSlider(SETOFVALUES(bodyShiftX), m_Slider_bodyShiftX, m_Value_bodyShiftX);
  setSlider(SETOFVALUES(bodyShiftY), m_Slider_bodyShiftY, m_Value_bodyShiftY);
  setSlider(SETOFVALUES(bodyShiftOffset), m_Slider_bodyShiftOffset, m_Value_bodyShiftOffset);
  setSlider(SETOFVALUES(bodyTiltOffset), m_Slider_bodyTiltOffset, m_Value_bodyTiltOffset);
  setSpeed();
}

void CInvKinParametersDlgBar::OnButtonSend()
{
  if (SystemCall::getTimeSince(lastSentTimeA) > 150)
  {
    getQueues().toPhysical.selectedRobot.out.bin << *pIndividual;
    getQueues().toPhysical.selectedRobot.out.finishMessage(idInvKinWalkingParameters);

    getQueues().toSimulated.selectedRobot.out.bin << *pIndividual;
    getQueues().toSimulated.selectedRobot.out.finishMessage(idInvKinWalkingParameters);

    lastSentTimeA = SystemCall::getCurrentSystemTime();
  }
}

void CInvKinParametersDlgBar::OnSelchangeInvKinParComboFootMode()
{
  pIndividual->footMode = (InvKinWalkingParameters::FootMode)m_ComboFootMode.GetCurSel();
  if (sendOnChange == true) OnButtonSend();
}


void CInvKinParametersDlgBar::OnInvKinParCheckbox()
{
  sendOnChange = m_Checkbox.GetCheck() == 1 ? true : false; // true disables sendbutton
}

void CInvKinParametersDlgBar::tFormat(CString & buffer, double & paramName)
{
  buffer.Format("%.3f", paramName);
  buffer.TrimRight("0");
  buffer.TrimRight(".");
  buffer += ' ';
}

CString CInvKinParametersDlgBar::walkParamToTextBuffer(InvKinWalkingParameters & w)
{
  CString buf1, buf2;
  buf2.Format("%d ", w.footMode);
  tFormat(buf1, w.foreHeight); buf2 += buf1;
  tFormat(buf1, w.foreWidth);  buf2 += buf1;
  tFormat(buf1, w.foreCenterX);  buf2 += buf1;
  tFormat(buf1, w.hindHeight);  buf2 += buf1;
  tFormat(buf1, w.hindWidth);  buf2 += buf1;
  tFormat(buf1, w.hindCenterX);  buf2 += buf1;
  tFormat(buf1, w.foreFootLift);  buf2 += buf1;
  tFormat(buf1, w.hindFootLift);  buf2 += buf1;
  tFormat(buf1, w.foreFootTilt);  buf2 += buf1;
  tFormat(buf1, w.hindFootTilt);  buf2 += buf1;
  tFormat(buf1, w.legSpeedFactorX);  buf2 += buf1;
  tFormat(buf1, w.legSpeedFactorY);  buf2 += buf1;
  tFormat(buf1, w.legSpeedFactorR);  buf2 += buf1;
  tFormat(buf1, w.maxStepSizeX);  buf2 += buf1;
  tFormat(buf1, w.maxStepSizeY);  buf2 += buf1;
  tFormat(buf1, w.maxSpeedXChange);  buf2 += buf1;
  tFormat(buf1, w.maxSpeedYChange);  buf2 += buf1;
  tFormat(buf1, w.maxRotationChange);  buf2 += buf1;
  tFormat(buf1, w.counterRotation);  buf2 += buf1;
  double temp = (double)w.stepLen;
  tFormat(buf1, temp);  buf2 += buf1;
  tFormat(buf1, w.groundPhase[0]);  buf2 += buf1;
  tFormat(buf1, w.liftPhase[0]);  buf2 += buf1;
  tFormat(buf1, w.loweringPhase[0]);  buf2 += buf1;
  tFormat(buf1, w.groundPhase[1]);  buf2 += buf1;
  tFormat(buf1, w.liftPhase[1]);  buf2 += buf1;
  tFormat(buf1, w.loweringPhase[1]);  buf2 += buf1;
  for( int i = 0; i < 4; i++)
  {
    tFormat(buf1, w.legPhase[i]);  buf2 += buf1;
  }
  tFormat(buf1, w.bodyShiftX);  buf2 += buf1;
  tFormat(buf1, w.bodyShiftY);  buf2 += buf1;
  tFormat(buf1, w.bodyShiftOffset);  buf2 += buf1;
  tFormat(buf1, w.bodyTiltOffset);  buf2 += buf1;

//  buf2 += numberOfSuccessfulMutations; buf1 += " ";
  
  return buf2;
}


void CInvKinParametersDlgBar::copyToClipboard()
{
  buffer = walkParamToTextBuffer(*pIndividual);

  GLOBALHANDLE hGMem = GlobalAlloc(GHND, buffer.GetLength()+1 );
  char* pchGM = (char*) ::GlobalLock(hGMem);
  strcpy( pchGM, buffer.GetBuffer(0) );
  buffer.ReleaseBuffer();

  OpenClipboard();
	EmptyClipboard();
	SetClipboardData( CF_TEXT, pchGM );
	CloseClipboard();

  GlobalUnlock(hGMem);
}

void CInvKinParametersDlgBar::pasteFromClipboard()
{
  GLOBALHANDLE hGMem;

  OpenClipboard();
  if ( hGMem = GetClipboardData( CF_TEXT ) )
  {
    char *pctmp = (char*) hGMem;
    CString buffer2 = pctmp;

    InConfigMemory inputStream(buffer2.GetBuffer(buffer2.GetLength()),buffer2.GetLength());

    InvKinWalkingParameters p;
    int footMode;

    if(
      (!(inputStream >> footMode).eof()) &&
      footMode >= 0 &&
      footMode < InvKinWalkingParameters::numOfFootModes &&
      (!(inputStream >> p.foreHeight).eof()) &&
      (!(inputStream >> p.foreWidth).eof()) &&
      (!(inputStream >> p.foreCenterX).eof()) &&
      (!(inputStream >> p.hindHeight).eof()) &&
      (!(inputStream >> p.hindWidth).eof()) &&
      (!(inputStream >> p.hindCenterX).eof()) &&
      (!(inputStream >> p.foreFootLift).eof()) &&
      (!(inputStream >> p.hindFootLift).eof()) &&
      (!(inputStream >> p.foreFootTilt).eof()) &&
      (!(inputStream >> p.hindFootTilt).eof()) &&
      (!(inputStream >> p.legSpeedFactorX).eof()) &&
      (!(inputStream >> p.legSpeedFactorY).eof()) &&
      (!(inputStream >> p.legSpeedFactorR).eof()) &&
      (!(inputStream >> p.maxStepSizeX).eof()) &&
      (!(inputStream >> p.maxStepSizeY).eof()) &&
      (!(inputStream >> p.maxSpeedXChange).eof()) &&
      (!(inputStream >> p.maxSpeedYChange).eof()) &&
      (!(inputStream >> p.maxRotationChange).eof()) &&
      (!(inputStream >> p.counterRotation).eof()) &&
      (!(inputStream >> p.stepLen).eof()) &&
      (!(inputStream >> p.groundPhase[0]).eof()) &&
      (!(inputStream >> p.liftPhase[0]).eof()) &&
      (!(inputStream >> p.loweringPhase[0]).eof()) &&
      (!(inputStream >> p.groundPhase[1]).eof()) &&
      (!(inputStream >> p.liftPhase[1]).eof()) &&
      (!(inputStream >> p.loweringPhase[1]).eof()) &&
      (!(inputStream >> p.legPhase[0]).eof()) &&
      (!(inputStream >> p.legPhase[1]).eof()) &&
      (!(inputStream >> p.legPhase[2]).eof()) &&
      (!(inputStream >> p.legPhase[3]).eof()) &&
      (!(inputStream >> p.bodyShiftX).eof()) &&
      (!(inputStream >> p.bodyShiftY).eof()) &&
      (!(inputStream >> p.bodyShiftOffset).eof()) &&
      (inputStream >> p.bodyTiltOffset).eof()
      )
    {
      p.footMode = (InvKinWalkingParameters::FootMode)footMode;
      p.headTilt = p.headPan = p.headRoll = p.mouth = jointDataInvalidValue;
      *pIndividual = p;
      updateControls();
      OnButtonSend();
      UpdateWindow();
    }
  }
  CloseClipboard();
}

void CInvKinParametersDlgBar::OnContextMenu(CWnd* pWnd, CPoint point)
{
  CMenu menu;
  menu.LoadMenu(IDP_INVKINPAR_MENU);
  CMenu* subMenu = menu.GetSubMenu(0)->GetSubMenu(8);
  UINT nFlags;

  menu.CheckMenuItem(IDC_INVKINPAR_WRITELOG,      writeLogFile ? MF_CHECKED : 0);
  menu.CheckMenuItem(IDC_INVKINPAR_ADAPTMUTATION, autoMutationStrength ? MF_CHECKED : 0);

  #define APPENDMENU(parName, parID, parTitle) nFlags = (evolveParam.##parName == jointDataInvalidValue) ? 0 : MF_CHECKED; \
                                               subMenu->AppendMenu( MF_BYCOMMAND | nFlags, ##parID, ##parTitle );

  APPENDMENU(foreHeight,        3300, "foreHeight");
  APPENDMENU(foreWidth,         3301, "foreWidth");
  APPENDMENU(foreCenterX,       3302, "foreCenterX");
  APPENDMENU(hindHeight,        3303, "hindHeight");
  APPENDMENU(hindWidth,         3304, "hindWidth");
  APPENDMENU(hindCenterX,       3305, "hindCenterX");
  APPENDMENU(foreFootLift,      3306, "foreFootLift");
  APPENDMENU(hindFootLift,      3307, "hindFootLift");
  APPENDMENU(foreFootTilt,      3308, "foreFootTilt");
  APPENDMENU(hindFootTilt,      3309, "hindFootTilt");
  APPENDMENU(legSpeedFactorX,   3310, "legSpeedFactorX");
  APPENDMENU(legSpeedFactorY,   3311, "legSpeedFactorY");
  APPENDMENU(legSpeedFactorR,   3312, "legSpeedFactorR");
  APPENDMENU(maxStepSizeY,      3313, "maxStepSizeX");
  APPENDMENU(maxStepSizeY,      3314, "maxStepSizeY");
  APPENDMENU(maxSpeedXChange,   3315, "maxSpeedXChange");
  APPENDMENU(maxSpeedYChange,   3316, "maxSpeedYChange");

  // Menubreak
  nFlags = (evolveParam.maxRotationChange == jointDataInvalidValue) ? MF_MENUBARBREAK : MF_CHECKED | MF_MENUBARBREAK;
  subMenu->AppendMenu( MF_BYCOMMAND | nFlags, 3317, "maxRotationChange" );

  APPENDMENU(counterRotation,   3318, "counterRotation");
  APPENDMENU(stepLen,           3319, "stepLen");
  APPENDMENU(groundPhase[0],    3320, "groundPhaseF");
  APPENDMENU(liftPhase[0],      3321, "liftPhaseF");
  APPENDMENU(loweringPhase[0],  3322, "loweringPhaseF");
  APPENDMENU(groundPhase[1],    3323, "groundPhaseH");
  APPENDMENU(liftPhase[1],      3324, "liftPhaseH");
  APPENDMENU(loweringPhase[1],  3325, "loweringPhaseH");
  APPENDMENU(legPhase[0],       3326, "legPhase1");
  APPENDMENU(legPhase[1],       3327, "legPhase2");
  APPENDMENU(legPhase[2],       3328, "legPhase3");
  APPENDMENU(legPhase[3],       3329, "legPhase4");
  APPENDMENU(bodyShiftX,        3330, "bodyShiftX");
  APPENDMENU(bodyShiftY,        3331, "bodyShiftY");
  APPENDMENU(bodyShiftOffset,   3332, "bodyShiftOffset");
  APPENDMENU(bodyTiltOffset,    3333, "bodyTiltOffset");

  subMenu->DeleteMenu(0,0);

  // Track menu
  UINT nID = menu.GetSubMenu(0)->TrackPopupMenu( TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_RETURNCMD | TPM_NONOTIFY,
    point.x, point.y, this);

  #define SETCHECK(parName) evolveParam.##parName = (evolveParam.##parName == jointDataInvalidValue) ? 1 : jointDataInvalidValue; \
                            saveContextMenu(); \
                            break;

  switch (nID)
  {
    case IDC_INVKINPAR_COPY:
      copyToClipboard();
      break;

    case IDC_INVKINPAR_PASTE:
      pasteFromClipboard();
      break;

    case IDC_INVKINPAR_LOADVAL:
      OnWalkParamLoad();
      break;

    case IDC_INVKINPAR_SAVEVAL:
      OnWalkParamSave();
      break;

    case IDC_INVKINPAR_DEFAULT:
      setDefaults();
      updateControls();
      OnKillFocusEditCtrls();
      readContextMenu();
      break;

    case IDC_INVKINPAR_WRITELOG:
      OnWriteLogFile();
      break;

    case IDC_INVKINPAR_ADAPTMUTATION:
      autoMutationStrength = !autoMutationStrength;
      break;

    case 3300: SETCHECK(foreHeight);
    case 3301: SETCHECK(foreWidth);
    case 3302: SETCHECK(foreCenterX);
    case 3303: SETCHECK(hindHeight);
    case 3304: SETCHECK(hindWidth);
    case 3305: SETCHECK(hindCenterX);
    case 3306: SETCHECK(foreFootLift);
    case 3307: SETCHECK(hindFootLift);
    case 3308: SETCHECK(foreFootTilt);
    case 3309: SETCHECK(hindFootTilt);
    case 3310: SETCHECK(legSpeedFactorX);
    case 3311: SETCHECK(legSpeedFactorY);
    case 3312: SETCHECK(legSpeedFactorR);
    case 3313: SETCHECK(maxStepSizeX);
    case 3314: SETCHECK(maxStepSizeY);
    case 3315: SETCHECK(maxSpeedXChange);
    case 3316: SETCHECK(maxSpeedYChange);
    case 3317: SETCHECK(maxRotationChange);
    case 3318: SETCHECK(counterRotation);
    case 3319: SETCHECK(stepLen);
    case 3320: SETCHECK(groundPhase[0]);
    case 3321: SETCHECK(liftPhase[0]);
    case 3322: SETCHECK(loweringPhase[0]);
    case 3323: SETCHECK(groundPhase[1]);
    case 3324: SETCHECK(liftPhase[1]);
    case 3325: SETCHECK(loweringPhase[1]);
    case 3326: SETCHECK(legPhase[0]);
    case 3327: SETCHECK(legPhase[1]);
    case 3328: SETCHECK(legPhase[2]);
    case 3329: SETCHECK(legPhase[3]);
    case 3330: SETCHECK(bodyShiftX);
    case 3331: SETCHECK(bodyShiftY);
    case 3332: SETCHECK(bodyShiftOffset);
    case 3333: SETCHECK(bodyTiltOffset);
  }
}

void CInvKinParametersDlgBar::OnWalkParamLoad()
{
  CString defaultPath = File::getGTDir();
  defaultPath += "/Config/";
  defaultPath.Replace('/','\\');
  CString pathName =
    AfxGetApp()->GetProfileString("WalkingParametersDlg", "openPath", defaultPath);
  pathName += "*.iwp";

  CFileDialog fileDialog(true, ".iwp",pathName,
    OFN_HIDEREADONLY | OFN_EXPLORER | OFN_ENABLESIZING | OFN_NOCHANGEDIR | OFN_NONETWORKBUTTON
    , "InvKin:Walkingparameter (*.iwp)|*.iwp||", this);

  if (fileDialog.DoModal()==IDOK)
  {
    CString fileName = fileDialog.GetFileName();
    CString pathAndFileName = fileDialog.GetPathName();
    pathName =
      pathAndFileName.Left(
      pathAndFileName.GetLength() -
      fileName.GetLength()
      );
    AfxGetApp()->WriteProfileString("WalkingParametersDlg", "openPath", pathName);

    InBinaryFile fin(pathAndFileName);
    if (fin.exists())
    {
        fin >> *pIndividual;
    }
    else
    {
      CString message;
      message.Format( "File %s not found.", pathAndFileName);
      AfxMessageBox( message, MB_OK);
    }
    updateControls();
    OnButtonSend();
  }
  UpdateWindow();
}

void CInvKinParametersDlgBar::OnWalkParamSave()
{
  CString defaultPath = File::getGTDir();
  defaultPath += "/Config/";
  defaultPath.Replace('/','\\');
  CString pathName =
    AfxGetApp()->GetProfileString("WalkingParametersDlg", "savePath", defaultPath);
  pathName += "*.iwp";

  CFileDialog fileDialog(false, ".iwp",pathName,
    OFN_HIDEREADONLY | OFN_EXPLORER | OFN_ENABLESIZING | OFN_NOCHANGEDIR | OFN_NONETWORKBUTTON
    , "InvKin:Walkingparameter (*.iwp)|*.iwp||", this);

  if (fileDialog.DoModal()==IDOK)
  {
    CString fileName = fileDialog.GetFileName();
    CString pathAndFileName = fileDialog.GetPathName();
    CString pathName =
      pathAndFileName.Left(
      pathAndFileName.GetLength() -
      fileName.GetLength()
      );
    AfxGetApp()->WriteProfileString("WalkingParametersDlg", "savePath", pathName);

    OutBinaryFile fout(pathAndFileName);
    if (fout.exists())
    {
      fout << *pIndividual;
    }
    else
    {
      CString message;
      message.Format( "File %s not found.", pathAndFileName);
      AfxMessageBox( message, MB_OK);
    }
  }
}

void CInvKinParametersDlgBar::OnKillFocusEditCtrls()
{
#define OKFEC(parName)   m_Value_##parName.GetWindowText(buffer); \
                         pIndividual->##parName = atof(buffer);

  OKFEC( foreHeight );
  OKFEC( foreWidth );
  OKFEC( foreCenterX );
  OKFEC( hindHeight );
  OKFEC( hindWidth );
  OKFEC( hindCenterX );
  OKFEC( foreFootLift );
  OKFEC( hindFootLift );
  OKFEC( foreFootTilt );
  OKFEC( hindFootTilt );
  OKFEC( legSpeedFactorX );
  OKFEC( legSpeedFactorY );
  OKFEC( legSpeedFactorR );
  OKFEC( maxStepSizeX );
  OKFEC( maxStepSizeY );
  OKFEC( maxSpeedXChange );
  OKFEC( maxSpeedYChange );
  OKFEC( maxRotationChange );
  OKFEC( counterRotation );

  m_Value_stepLen.GetWindowText(buffer);
  pIndividual->stepLen = atoi(buffer);
  
  OKFEC( groundPhase[0] );
  OKFEC( liftPhase[0] );
  OKFEC( loweringPhase[0] );
  OKFEC( groundPhase[1] );
  OKFEC( liftPhase[1] );
  OKFEC( loweringPhase[1] );
  OKFEC( legPhase[0] );
  OKFEC( legPhase[1] );
  OKFEC( legPhase[2] );
  OKFEC( legPhase[3] );
  OKFEC( bodyShiftX );
  OKFEC( bodyShiftY );
  OKFEC( bodyShiftOffset );
  OKFEC( bodyTiltOffset );

  updateControls();
}

void CInvKinParametersDlgBar::OnWalkParamWalk()
{
  if( !walking )
  {
    SetDlgItemText(IDC_INVKINPAR_BUTTON_WALK, "&Stop");
    startWalking();
    OnButtonSend();
    walking = true;
  }
  else
  {
    SetDlgItemText(IDC_INVKINPAR_BUTTON_WALK, "Test &Walk");
    OnWalkParamStop();
    walking = false;
  }
}

void CInvKinParametersDlgBar::OnWalkParamStop()
{
    double speed = (double)distance/((double)getFitness() / 1000.0);
    if(m_Offspring.GetCheck())
    {
      evolveParam.fitness = speed;
    }
    else
    {
      parentParam.fitness = speed;
    }
    setSpeed();
}

void CInvKinParametersDlgBar::setSpeed()
{
  double speed = parentParam.fitness;
  if(speed > 0.0)
  {
    tFormat(buffer, speed);
  }
  else
  {
    buffer = "-";
  }
  buffer = buffer + " [mm/s]";
  GetDlgItem(IDC_INVKINPAR_TEXTSPEEDPARENT)->SetWindowText(buffer);
  
  speed = evolveParam.fitness;
  if(speed > 0.0)
  {
    tFormat(buffer, speed);
  }
  else
  {
    buffer = "-";
  }
  buffer = buffer + " [mm/s]";
  GetDlgItem(IDC_INVKINPAR_TEXTSPEEDOFFSPRING)->SetWindowText(buffer);
}

void CInvKinParametersDlgBar::startWalking()
{
  if (SystemCall::getTimeSince(lastSentTimeB) > 150)
  {
    motionRequest.tailRequest = MotionRequest::noTailWag;
    motionRequest.motionType = MotionRequest::walk;
    motionRequest.walkType = MotionRequest::debug;
    motionRequest.walkParams = Pose2D(0, walkMaxForwardSpeed, 0);
    motionRequest.breathe = false;
    motionRequest.stabilize = false;

    headControlMode.headControlMode = HeadControlMode::none;
    headMotionRequest.tilt = -1571000;
    headMotionRequest.pan  = 0;
    headMotionRequest.roll = 0;

    getQueues().toPhysical.selectedRobot.out.bin << motionRequest;
    getQueues().toPhysical.selectedRobot.out.finishMessage(idMotionRequest);
    getQueues().toPhysical.selectedRobot.out.bin << headControlMode;
    getQueues().toPhysical.selectedRobot.out.finishMessage(idHeadControlMode);
    getQueues().toPhysical.selectedRobot.out.bin << headMotionRequest;
    getQueues().toPhysical.selectedRobot.out.finishMessage(idHeadMotionRequest);

    getQueues().toSimulated.selectedRobot.out.bin << motionRequest;
    getQueues().toSimulated.selectedRobot.out.finishMessage(idMotionRequest);
    getQueues().toSimulated.selectedRobot.out.bin << headControlMode;
    getQueues().toSimulated.selectedRobot.out.finishMessage(idHeadControlMode);
    getQueues().toSimulated.selectedRobot.out.bin << headMotionRequest;
    getQueues().toSimulated.selectedRobot.out.finishMessage(idHeadMotionRequest);

    startTime = SystemCall::getCurrentSystemTime();
    lastSentTimeB = startTime;
  }
}

unsigned long CInvKinParametersDlgBar::getFitness()
{
  motionRequest.walkParams = Pose2D(0, 0.0000000001, 0);

  getQueues().toPhysical.selectedRobot.out.bin << motionRequest;
  getQueues().toPhysical.selectedRobot.out.finishMessage(idMotionRequest);

  getQueues().toSimulated.selectedRobot.out.bin << motionRequest;
  getQueues().toSimulated.selectedRobot.out.finishMessage(idMotionRequest);

  return SystemCall::getTimeSince(startTime);
}

void CInvKinParametersDlgBar::OnChangeDistance()
{
  m_ValueDistance.GetWindowText(buffer);
  distance = atoi(buffer);
  m_ValueDistance.SetWindowText(itoa(distance,tmp,10));
}

void CInvKinParametersDlgBar::saveContextMenu()
{
  int i;

#define WRITEPROFINT(parN, parStr) i = (evolveParam.##parN == jointDataInvalidValue) ? 0 : 1; \
        AfxGetApp()->WriteProfileInt("WalkingParametersDlg\\1+1ES", ##parStr, i);

  WRITEPROFINT(foreHeight,"foreHeight");
  WRITEPROFINT(foreWidth,"foreWidth");
  WRITEPROFINT(foreCenterX,"foreCenterX");
  WRITEPROFINT(hindHeight,"hindWidth");
  WRITEPROFINT(hindCenterX,"hindCenterX");
  WRITEPROFINT(foreFootLift,"foreFootLift");
  WRITEPROFINT(hindFootLift,"hindFootLift");
  WRITEPROFINT(foreFootTilt,"foreFootTilt");
  WRITEPROFINT(hindFootTilt,"hindFootTilt");
  WRITEPROFINT(legSpeedFactorX,"legSpeedFactorX");
  WRITEPROFINT(legSpeedFactorY,"legSpeedFactorY");
  WRITEPROFINT(legSpeedFactorR,"legSpeedFactorR");
  WRITEPROFINT(maxStepSizeX,"maxStepSizeX");
  WRITEPROFINT(maxStepSizeY,"maxStepSizeY");
  WRITEPROFINT(maxSpeedXChange,"maxSpeedXChange");
  WRITEPROFINT(maxSpeedYChange,"maxSpeedYChange");
  WRITEPROFINT(maxRotationChange,"maxRotationChange");
  WRITEPROFINT(counterRotation,"counterRotation");
  WRITEPROFINT(stepLen,"stepLen");
  WRITEPROFINT(groundPhase[0],"groundPhaseF");
  WRITEPROFINT(liftPhase[0],"liftPhaseF");
  WRITEPROFINT(loweringPhase[0],"loweringPhaseF");
  WRITEPROFINT(groundPhase[1],"groundPhaseH");
  WRITEPROFINT(liftPhase[1],"liftPhaseH");
  WRITEPROFINT(loweringPhase[1],"loweringPhaseH");
  WRITEPROFINT(legPhase[0],"legPhase0");
  WRITEPROFINT(legPhase[1],"legPhase1");
  WRITEPROFINT(legPhase[2],"legPhase2");
  WRITEPROFINT(legPhase[3],"legPhase3");
  WRITEPROFINT(bodyShiftX,"bodyShiftX");
  WRITEPROFINT(bodyShiftY,"bodyShiftY");
  WRITEPROFINT(bodyShiftOffset,"bodyShiftOffset");
  WRITEPROFINT(bodyTiltOffset,"bodyTiltOffset");
  AfxGetApp()->WriteProfileInt("WalkingParametersDlg", "writeLogFile", writeLogFile ? 1 : 0);
}

void CInvKinParametersDlgBar::readContextMenu()
{
  int i;

#define READPROFINT(parN, parStr) i = AfxGetApp()->GetProfileInt("WalkingParametersDlg\\1+1ES", ##parStr, 1); \
  evolveParam.##parN = i ? 0 : jointDataInvalidValue;

  READPROFINT(foreHeight,"foreHeight");
  READPROFINT(foreWidth,"foreWidth");
  READPROFINT(foreCenterX,"foreCenterX");
  READPROFINT(hindHeight,"hindWidth");
  READPROFINT(hindCenterX,"hindCenterX");
  READPROFINT(foreFootLift,"foreFootLift");
  READPROFINT(hindFootLift,"hindFootLift");
  READPROFINT(foreFootTilt,"foreFootTilt");
  READPROFINT(hindFootTilt,"hindFootTilt");
  READPROFINT(legSpeedFactorX,"legSpeedFactorX");
  READPROFINT(legSpeedFactorY,"legSpeedFactorY");
  READPROFINT(legSpeedFactorR,"legSpeedFactorR");
  READPROFINT(maxStepSizeX,"maxStepSizeX");
  READPROFINT(maxStepSizeY,"maxStepSizeY");
  READPROFINT(maxSpeedXChange,"maxSpeedXChange");
  READPROFINT(maxSpeedYChange,"maxSpeedYChange");
  READPROFINT(maxRotationChange,"maxRotationChange");
  READPROFINT(counterRotation,"counterRotation");
  READPROFINT(stepLen,"stepLen");
  READPROFINT(groundPhase[0],"groundPhaseF");
  READPROFINT(liftPhase[0],"liftPhaseF");
  READPROFINT(loweringPhase[0],"loweringPhaseF");
  READPROFINT(groundPhase[1],"groundPhaseH");
  READPROFINT(liftPhase[1],"liftPhaseH");
  READPROFINT(loweringPhase[1],"loweringPhaseH");
  READPROFINT(legPhase[0],"legPhase0");
  READPROFINT(legPhase[1],"legPhase1");
  READPROFINT(legPhase[2],"legPhase2");
  READPROFINT(legPhase[3],"legPhase3");
  READPROFINT(bodyShiftX,"bodyShiftX");
  READPROFINT(bodyShiftY,"bodyShiftY");
  READPROFINT(bodyShiftOffset,"bodyShiftOffset");
  READPROFINT(bodyTiltOffset,"bodyTiltOffset");
  writeLogFile = (AfxGetApp()->GetProfileInt("WalkingParametersDlg", "writeLogFile", 0) == 1)
    ? true : false;

  CString defaultPath = File::getGTDir();
  defaultPath += "/Config/";
  defaultPath.Replace('/','\\');
  CString pathName = AfxGetApp()->GetProfileString("WalkingParametersDlg", "logFilePath", defaultPath);
  CString logFileName = AfxGetApp()->GetProfileString("WalkingParametersDlg", "logFileName", "1+1ES.log");
  logFilePathAndName = pathName + logFileName;
}

void CInvKinParametersDlgBar::WriteLogFile()
{
  int i, j;
  CString buf1, buf2;
  OutTextFile fout( logFilePathAndName, true );
  if (fout.exists())
  {
    //write evolved parameters
    tFormat(buf1, loggedMutStrength);
    fout << endl << "G" << numberOfSuccessfulMutations << "M" << buf1.Left(buf1.Find(' '));
#define WRITEEVO(paramName) i = (evolveParam.##paramName == jointDataInvalidValue) ? 0 : 1;\
    fout << i;
    WRITEEVO(foreHeight);
    WRITEEVO(foreWidth);
    WRITEEVO(foreCenterX);
    WRITEEVO(hindHeight);
    WRITEEVO(hindCenterX);
    WRITEEVO(foreFootLift);
    WRITEEVO(hindFootLift);
    WRITEEVO(foreFootTilt);
    WRITEEVO(hindFootTilt);
    WRITEEVO(legSpeedFactorX);
    WRITEEVO(legSpeedFactorY);
    WRITEEVO(legSpeedFactorR);
    WRITEEVO(maxStepSizeX);
    WRITEEVO(maxStepSizeY);
    WRITEEVO(maxSpeedXChange);
    WRITEEVO(maxSpeedYChange);
    WRITEEVO(maxRotationChange);
    WRITEEVO(counterRotation);
    WRITEEVO(stepLen);
    WRITEEVO(groundPhase[0]);
    WRITEEVO(liftPhase[0]);
    WRITEEVO(loweringPhase[0]);
    WRITEEVO(groundPhase[1]);
    WRITEEVO(liftPhase[1]);
    WRITEEVO(loweringPhase[1]);
    WRITEEVO(legPhase[0]);
    WRITEEVO(legPhase[1]);
    WRITEEVO(legPhase[2]);
    WRITEEVO(legPhase[3]);
    WRITEEVO(bodyShiftX);
    WRITEEVO(bodyShiftY);
    WRITEEVO(bodyShiftOffset);
    WRITEEVO(bodyTiltOffset);
    fout << endl;

    // write parent
    buf1 = m_Parent.GetCheck() ? "+ F " : "- F ";
    tFormat(buf2, parentParam.fitness);
    buf1 += buf2;
    buf2 = walkParamToTextBuffer(parentParam);
    buf1 += buf2;
    while ( buf1.GetLength() > 1 )
    {
      // formatted output
      j = buf1.Find(' ');
      if ( j >= 0 )
      {
        fout << buf1.Left( j );
        buf1.Delete( 0, j + 1 );
      }
    }
    fout << endl;

    // write offspring
    buf1 = m_Parent.GetCheck() ? "- F " : "+ F ";
    tFormat(buf2, evolveParam.fitness);
    buf1 += buf2;
    buf2 = walkParamToTextBuffer(evolveParam);
    buf1 += buf2;
    while ( buf1.GetLength() > 1 )
    {
      // formatted output
      j = buf1.Find(' ');
      if ( j >= 0 )
      {
        fout << buf1.Left( j );
        buf1.Delete( 0, j + 1 );
      }
    }
    fout << endl;

  }
  else
  {
    buf1.Format( "Could not write logfile." );
    AfxMessageBox( buf1, MB_OK);
  }
}

void CInvKinParametersDlgBar::OnSelectParent()
{
  pIndividual = &parentParam;
  m_Parent.SetCheck(true);
  m_Offspring.SetCheck(false);
  if (sendOnChange) OnButtonSend();
  updateControls();
}

void CInvKinParametersDlgBar::OnSelectOffspring()
{
  pIndividual = &evolveParam;
  m_Parent.SetCheck(false);
  m_Offspring.SetCheck(true);
  if (sendOnChange) OnButtonSend();
  updateControls();
}

void CInvKinParametersDlgBar::OnButtonMutate()
{
  numberOfMutations++;
  if(writeLogFile)
    WriteLogFile();
  loggedMutStrength = mutationStrength;
  if(m_Offspring.GetCheck())
  {
    parentParam = evolveParam;
    evolveParam.mutationOf(&parentParam, 1, mutationStrength*pi2/100.0);
    numberOfSuccessfulMutations++;
  }
  else
  {
    evolveParam.mutationOf(&parentParam, 1, mutationStrength*pi2/100.0);
  }
  OnSelectOffspring();
  adaptMutationStrength();
}

void CInvKinParametersDlgBar::OnChangeMutationStrength()
{
  m_ValueMutationStrength.GetWindowText(buffer);
  mutationStrength = atof(buffer);
  tFormat(buffer, mutationStrength);
  m_ValueMutationStrength.SetWindowText(buffer);
}

void CInvKinParametersDlgBar::OnWriteLogFile()
{
  writeLogFile = !writeLogFile;
  saveContextMenu();
  if( writeLogFile )
  {
    CString defaultPath = File::getGTDir();
    defaultPath += "/Config/";
    defaultPath.Replace('/','\\');

    CString pathName = AfxGetApp()->GetProfileString("WalkingParametersDlg", "logFilePath", defaultPath);
    CString logFileName = AfxGetApp()->GetProfileString("WalkingParametersDlg", "logFileName", "1+1ES.log");
    pathName += "logFileName";

    CFileDialog fileDialog(false, ".log",pathName,
      OFN_HIDEREADONLY | OFN_EXPLORER | OFN_ENABLESIZING | OFN_NOCHANGEDIR | OFN_NONETWORKBUTTON
      , "Logfiles (*.log)|*.log||", this);

    if (fileDialog.DoModal()==IDOK)
    {
      CString fileName = fileDialog.GetFileName();
      CString pathAndFileName = fileDialog.GetPathName();
      logFilePathAndName = pathAndFileName;
      CString pathName =
        pathAndFileName.Left(
        pathAndFileName.GetLength() -
        fileName.GetLength()
        );
      AfxGetApp()->WriteProfileString("WalkingParametersDlg", "logFilePath", pathName);
      AfxGetApp()->WriteProfileString("WalkingParametersDlg", "logFileName", fileName);
    }
  }
}

void CInvKinParametersDlgBar::adaptMutationStrength()
{
  if(autoMutationStrength &&
    (numberOfMutations >= getNumberOfEvolveValues()) &&
    (numberOfMutations > 0))
  {
    if(((double)numberOfSuccessfulMutations/(double)numberOfMutations) < 0.2)
    {
      mutationStrength = mutationStrength*0.8;
    }
    else mutationStrength = mutationStrength/0.8;
  numberOfMutations = 0;
  numberOfSuccessfulMutations = 0;
  tFormat(buffer, mutationStrength);
  m_ValueMutationStrength.SetWindowText(buffer);
  }
}

int CInvKinParametersDlgBar::getNumberOfEvolveValues()
{
  int numberOfEvolveValues = 0;
  if (evolveParam.foreHeight != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.foreWidth != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.foreCenterX != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.hindHeight != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.hindWidth != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.hindCenterX != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.foreFootLift != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.hindFootLift != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.foreFootTilt != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.hindFootTilt != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.legSpeedFactorX != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.legSpeedFactorY != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.legSpeedFactorR != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.maxStepSizeX != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.maxStepSizeY != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.maxSpeedXChange != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.maxSpeedYChange != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.maxRotationChange != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.counterRotation != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.stepLen != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.groundPhase[0] != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.liftPhase[0] != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.loweringPhase[0] != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.groundPhase[1] != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.liftPhase[1] != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.loweringPhase[1] != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.legPhase[0] != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.legPhase[1] != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.legPhase[2] != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.legPhase[3] != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.bodyShiftX != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.bodyShiftY != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.bodyShiftOffset != jointDataInvalidValue) numberOfEvolveValues++;
  if (evolveParam.bodyTiltOffset != jointDataInvalidValue) numberOfEvolveValues++;
  return numberOfEvolveValues;
}

bool CInvKinParametersDlgBar::handleMessage(InMessage& message)
{
  MessageID messageID = message.getMessageID();
  switch(messageID)
  {
  case idInvKinWalkingParameters:
    message.bin >> evolveParam;
    OnSelectOffspring();
    return true;
  default:
    return false;
  }
}
/*
 * Change log :
 *
 * $Log: InvKinParametersDlgBar.cpp,v $
 * Revision 1.8  2004/04/19 16:45:06  dueffert
 * minima, maxima and number of steps between changed to allow testing new 400mm/s walk
 *
 * Revision 1.7  2004/04/08 15:33:08  wachter
 * GT04 checkin of Microsoft-Hellounds
 *
 * Revision 1.6  2004/03/18 14:22:53  cesarz
 * Changed walk type to debug.
 *
 * Revision 1.5  2004/01/20 14:13:53  cesarz
 * fixed small bug in context menu
 *
 * Revision 1.4  2003/12/19 15:51:50  dueffert
 * better default and better min and max values
 *
 * Revision 1.3  2003/12/09 19:49:25  loetzsch
 * Renamed some of the main queues of RobotControl.
 *
 * Added possibility to send messages to specific simulated or physical robots.
 *
 * Revision 1.2  2003/12/06 06:31:20  loetzsch
 * no message
 *
 * Revision 1.1  2003/10/07 10:09:37  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.7  2003/09/26 15:28:23  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.6  2003/09/26 11:40:12  juengel
 * - sorted tools
 * - clean-up in DataTypes
 *
 * Revision 1.5  2003/09/11 15:20:59  dueffert
 * passing of InvKinParameters added
 *
 * Revision 1.4  2003/09/01 15:57:42  dueffert
 * Genom and Individual merged
 *
 * Revision 1.3  2003/08/06 15:58:49  cesarz
 * added new walking parameters to InvKinDlgBar
 *
 * Revision 1.2  2003/07/24 12:44:19  risler
 * new walking engine Parameters loweringPhase, Phase parameters for fore and hind legs now, leaveAnytime, new footmode freeFormQuad
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.24  2003/05/12 00:29:11  dueffert
 * Depend now works for RobotControl too
 *
 * Revision 1.23  2003/04/04 17:42:44  dueffert
 * foot mode added
 *
 * Revision 1.22  2003/03/23 19:11:06  loetzsch
 * OUTPUT not allowed in the RobotControl thread anymore.
 * Use getQueues().toGUI.out instead.
 *
 * Revision 1.21  2003/03/19 09:11:37  dueffert
 * circle support added
 *
 * Revision 1.20  2003/03/05 17:09:27  loetzsch
 * redesign of the queues and debug key tables in RobotControl
 *
 * Revision 1.19  2003/02/19 16:55:17  hebbel
 * Added evolved parameterset for InvKinWalkingEngine
 *
 * Revision 1.18  2003/02/18 22:57:48  hebbel
 * Selfadaption of mutation strength implemented
 *
 * Revision 1.17  2003/02/18 00:47:08  cesarz
 * Robot is able to start and stop walking now.
 *
 * Revision 1.16  2003/02/17 13:09:31  cesarz
 * changed min, max, and default parameter sets.
 *
 * Revision 1.15  2003/02/10 23:33:02  cesarz
 * some small bugfixes and changes.
 *
 * Revision 1.14  2003/02/09 22:23:14  cesarz
 * extended logFile support.
 *
 * Revision 1.13  2003/02/03 09:50:33  hebbel
 * Fitness calculation and mutation strength added.
 *
 * Revision 1.12  2003/02/02 22:47:38  hebbel
 * Implemented mutation of walkingparameters.
 *
 * Revision 1.11  2003/01/23 16:44:10  risler
 * only one instance of InvKinWalkingEngine
 * parameter sets can now be switched while walking
 * added UNSWFastTurn, combining two parameter sets
 *
 * Revision 1.10  2003/01/23 14:24:21  cesarz
 * added logfile support and some improvements.
 *
 * Revision 1.9  2003/01/13 18:15:24  dueffert
 * eliminated ugly crash reason
 *
 * Revision 1.8  2003/01/09 15:22:32  cesarz
 * added registry support for the 1+1ES context menu
 *
 * Revision 1.7  2002/12/18 12:59:09  cesarz
 * 1+1 ES-contextmenu implemented
 *
 * Revision 1.6  2002/12/18 10:19:46  hebbel
 * OnePlusOne ES continued
 *
 * Revision 1.5  2002/12/10 15:39:16  hebbel
 * some extensions for the InvKinWalkingParametersDlgBar
 *
 * Revision 1.4  2002/12/09 00:15:44  cesarz
 * Dialog layout and clipboard functions corrected.
 *
 * Revision 1.3  2002/12/05 22:59:58  cesarz
 * Leg phases added.
 *
 * Revision 1.2  2002/12/03 16:15:32  cesarz
 * corrected sending of parameters.
 *
 * Revision 1.1  2002/12/03 15:03:05  cesarz
 * InvKinParametersDlgBar added.
 *
*/
