/**
* @file JoystickMotionTesterDlgBar.cpp
* 
* Implementation of class CJoystickMotionTesterDlgBar.
*
* @author Uwe Dffert
*/

#include "StdAfx.h"
#include "JoystickMotionTesterDlgBar.h"

#include "Tools/Actorics/RobotDimensions.h"
#include "Platform/SystemCall.h"
#include "RobotControlQueues.h"

#include "Representations/JoystickData.h"

CJoystickMotionTesterDlgBar::CJoystickMotionTesterDlgBar()
: CRobotControlDialogBar(IDD),
m_pBitmap(0),oldBehavior(0),scheme(sStickSpeed),
sizex(50),sizey(40)
{
  joy.x=0;
  joy.y=0;
  joy.z=0;
  joy.a=0;
  joy.b=0;
  joy.c=-1;
  joy.mode=jDisabled;
  joy.walktype=0;
  joy.walktypechange=FALSE;
  joy.astart=joy.a;
  joy.headControl.mode=0;
  joy.headControl.time=0x80000000;
  joy.special.action=0;
  joy.special.time=0x80000000;
  
  sent.headControl.time=0x80000000;
  sent.headMotion.tilt=0;
  sent.headMotion.pan=0;
  sent.headMotion.roll=0;
  sent.headMotion.time=0x80000000;
  sent.motion.xspeed=0;
  sent.motion.yspeed=0;
  sent.motion.arcspeed=0;
  sent.motion.time=0x80000000;
  sent.special.action=0;
  sent.special.time=0x80000000;
  
  //{{AFX_DATA_INIT(CJoystickMotionTesterDlgBar)
  //}}AFX_DATA_INIT
}

CJoystickMotionTesterDlgBar::~CJoystickMotionTesterDlgBar()
{
  if(m_pBitmap)
  {
    delete m_pBitmap;
  }
}

void CJoystickMotionTesterDlgBar::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CJoystickMotionTesterDlgBar)
  DDX_Control(pDX, IDC_JOYSTICKMOTIONTESTER_SCHEME, m_scheme);
  DDX_Control(pDX, IDC_JOYSTICKMOTIONTESTER_USEJOYSTICK, m_useJoystick);
  //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CJoystickMotionTesterDlgBar, CDynamicBarDlg)
//{{AFX_MSG_MAP(CJoystickMotionTesterDlgBar)
ON_BN_CLICKED(IDC_JOYSTICKMOTIONTESTER_USEJOYSTICK, OnUseJoystick)
ON_WM_TIMER()
ON_WM_PAINT()
ON_WM_SIZE()
ON_CBN_SELCHANGE(IDC_JOYSTICKMOTIONTESTER_SCHEME, OnSelchangeScheme)
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CJoystickMotionTesterDlgBar::OnInitDialog() 
{
  CDynamicBarDlg::OnInitDialog();
  AddSzControl(m_useJoystick, mdNone, mdNone);
  m_useJoystick.SetCheck(FALSE);
  AddSzControl(m_scheme, mdNone, mdNone);
  scheme=static_cast<JScheme>(AfxGetApp()->GetProfileInt("JoystickMotionTester", "Scheme",m_scheme.GetCurSel()));
  m_scheme.SetCurSel((int)scheme);
  return TRUE;
}

void CJoystickMotionTesterDlgBar::changeHeadControlMode()
{
  if ((joy.headControl.mode != (joy.a+1000)*HeadControlMode::numOfHeadControlModes/2001)&&
    ((joy.astart+1000)*HeadControlMode::numOfHeadControlModes/2001 != (joy.a+1000)*HeadControlMode::numOfHeadControlModes/2001))
  {
    joy.headControl.mode =(joy.a+1000)*HeadControlMode::numOfHeadControlModes/2001;
    joy.headControl.time = SystemCall::getCurrentSystemTime();
    joy.astart=-2000;
  }
}

void CJoystickMotionTesterDlgBar::changeSpecialAction()
{
  if ((joy.astart+1000)*MotionRequest::numOfSpecialAction/2001 != (joy.a+1000)*MotionRequest::numOfSpecialAction/2001)
  {
    joy.special.action=(joy.a+1000)*MotionRequest::numOfSpecialAction/2001;
    joy.special.time = SystemCall::getCurrentSystemTime();
    joy.astart=-2000;
  }
}

void CJoystickMotionTesterDlgBar::sendHeadControlMode(int act)
{
  //HCM is only sent, if accelerator has not changed for 250ms
  //and that wasn't already sent
  if ((SystemCall::getTimeSince(joy.headControl.time) >= 250)&&(joy.headControl.time>sent.headControl.time))
  {
    headControlMode.headControlMode = (HeadControlMode::HeadControlModes)act;
    
    getQueues().toPhysical.selectedRobot.out.bin << headControlMode;
    getQueues().toPhysical.selectedRobot.out.finishMessage(idHeadControlMode);
    
    getQueues().toSimulated.selectedRobot.out.bin << headControlMode;
    getQueues().toSimulated.selectedRobot.out.finishMessage(idHeadControlMode);
    
    sent.headControl.mode = act;
    sent.headControl.time = SystemCall::getCurrentSystemTime();
  }
}

void CJoystickMotionTesterDlgBar::sendSpecialAction(int act)
{
  if ((sent.special.time<joy.special.time)||((act!=-999)))
  {
    if (act==-1)
    {
      motionRequest.motionType=MotionRequest::getup;
    }
    else
    {
      if (act>=100)
      {
        //secretSpecialActionID 3 & 7 dont work yet
        if ((act==101)||(act==105)) act--;
        motionRequest.motionType=MotionRequest::walk;
        //        motionRequest.secretSpecialActionID=2+act-100;
      }
      else
      {
        if (act==-999)
        {
          act=joy.special.action;
        }
        motionRequest.motionType=MotionRequest::specialAction;
        motionRequest.specialActionType=static_cast<MotionRequest::SpecialActionID>(act);
      }
    }
    
    
    getQueues().toPhysical.selectedRobot.out.bin << motionRequest;
    getQueues().toPhysical.selectedRobot.out.finishMessage(idMotionRequest);
    
    getQueues().toSimulated.selectedRobot.out.bin << motionRequest << endl;
    getQueues().toSimulated.selectedRobot.out.finishMessage(idMotionRequest);
    
    sent.special.action = act;
    sent.special.time = SystemCall::getCurrentSystemTime();
  }
}

void CJoystickMotionTesterDlgBar::sendHeadMotionRequest(int x, int y, int z)
{
  double tilt = y<0 ? -y*jointLimitHeadTiltN/1000 : y*jointLimitHeadTiltP/1000;
  double pan  = x>0 ? x*jointLimitHeadPanN/1000  : -x*jointLimitHeadPanP/1000;
  double roll = z<0 ? -z*jointLimitHeadRollN/1000 : z*jointLimitHeadRollP/1000;
  
  // sent HeadMotionRequest at most every 300 ms
  if (SystemCall::getTimeSince(sent.headMotion.time) >= 300)
  {
    headMotionRequest.tilt = toMicroRad(tilt);
    headMotionRequest.pan = toMicroRad(pan);
    headMotionRequest.roll = toMicroRad(roll);
    //headMotionRequest.speed = 3;
    
    if ((sent.headMotion.tilt != -(int)toDegrees(tilt))||
      (sent.headMotion.pan != -(int)toDegrees(pan))||
      (sent.headMotion.roll != (int)toDegrees(roll)))
    {
      getQueues().toPhysical.selectedRobot.out.bin << headMotionRequest;
      getQueues().toPhysical.selectedRobot.out.finishMessage(idHeadMotionRequest);
      
      getQueues().toSimulated.selectedRobot.out.bin << headMotionRequest;
      getQueues().toSimulated.selectedRobot.out.finishMessage(idHeadMotionRequest);
      
      sent.headMotion.tilt = -(int)toDegrees(tilt);
      sent.headMotion.pan = -(int)toDegrees(pan);
      sent.headMotion.roll = (int)toDegrees(roll);
      sent.headMotion.time = SystemCall::getCurrentSystemTime();
    }
  }
}

void CJoystickMotionTesterDlgBar::sendMotionRequest()
{
  int x=joy.x;
  int y=joy.y;
  int z=joy.z;
  int a=joy.a;
  // sent MotionRequest at most every 300 ms and at least 1000ms after SpecialAction
  if ((SystemCall::getTimeSince(sent.special.time) >= 1000)&&(SystemCall::getTimeSince(sent.motion.time) >= 300))
  {
    motionRequest.motionType = MotionRequest::walk;
    motionRequest.walkType = static_cast<enum MotionRequest::WalkType>(joy.walktype);
    switch (scheme)
    {
    case sStickSpeed:
      motionRequest.walkParams.translation.y = -x*walkMaxLeftRightSpeed/1000;
      motionRequest.walkParams.translation.x = -y<0?(-y*walkMaxBackwardSpeed/1000):(-y*walkMaxForwardSpeed/1000);
      motionRequest.walkParams.rotation = -z*walkMaxRotationSpeed/1000;
      break;
    case sAcceleratorSpeed:
      motionRequest.walkParams.translation.x = -y<-100?((a-1000)*walkMaxBackwardSpeed/2000):((1000-a)*walkMaxForwardSpeed/2000);
      if ((joy.b >> (8-1) & 1) == 1)  //button 8 = Turn statt Strafe
      {
        motionRequest.walkParams.translation.y = 0;
        motionRequest.walkParams.rotation = -x*walkMaxRotationSpeed/1000;
      }
      else
      {
        motionRequest.walkParams.translation.y = -x*walkMaxLeftRightSpeed/1000;
        motionRequest.walkParams.rotation = 0;
      }
      break;
    }
    
    if (((sent.motion.xspeed != -(int)motionRequest.walkParams.translation.y)||
      (sent.motion.yspeed != -(int)motionRequest.walkParams.translation.x)||
      (sent.motion.arcspeed != -(int)toDegrees(motionRequest.walkParams.rotation)||
      (joy.walktypechange)))&&
      (joy.a<2000))
    {
      getQueues().toPhysical.selectedRobot.out.bin << motionRequest;
      getQueues().toPhysical.selectedRobot.out.finishMessage(idMotionRequest);
      
      getQueues().toSimulated.selectedRobot.out.bin << motionRequest << endl;
      getQueues().toSimulated.selectedRobot.out.finishMessage(idMotionRequest);
      
      sent.motion.xspeed = -(int)motionRequest.walkParams.translation.y;
      sent.motion.yspeed = -(int)motionRequest.walkParams.translation.x;
      sent.motion.arcspeed = -(int)toDegrees(motionRequest.walkParams.rotation);
      sent.motion.time = SystemCall::getCurrentSystemTime();
    }
  }
}


void CJoystickMotionTesterDlgBar::OnUseJoystick() 
{
  if (m_useJoystick.GetCheck())
  {
    joy.mode=jWalking;
    joy.astart=2000;
    
    //I'm sorry, polling is neccessary, events dont handle button 5-8 and 3rd axis
    SetTimer(654,40,0);
  }
  else
  {
    KillTimer(654);
    joy.mode=jDisabled;
  }
  UpdateData();
  Invalidate(FALSE);
}

void CJoystickMotionTesterDlgBar::OnTimer(UINT nIDEvent) 
{
  JOYINFOEX ji;
  ji.dwSize = sizeof(ji);
  ji.dwFlags = JOY_RETURNALL;
  MMRESULT joyresult;
  char bu[9];
  bu[8]=0;
  int roboNoOffset = 0;
  
  
  
  
  if((scheme == s4a) || (scheme == s4b)) {
    // 4 player-mode
    
    if(scheme == s4b)
      roboNoOffset = 2; // Robots 2-4
    
    for(int joyNo=0; joyNo<2; joyNo++) {
      
      joyresult=joyGetPosEx(joyNo,&ji);
      
      if (joyresult!=0)
      {
        //there is no joystick attached -> JoystickMotionTester would be useless
        continue;
      }
      else
      {
        joy.b=ji.dwButtons;
        joy.c=ji.dwPOV==65535?-1:ji.dwPOV/4500;
        for (int i=0;i<8;i++)
        {
          bu[i]=((joy.b>>i)&1)?'1':'0';
        }
        joy.x=(int)(((int)ji.dwXpos-32767)/32.768);
        joy.y=(int)(((int)ji.dwYpos-32767)/32.768);
        joy.z=(int)(((int)ji.dwRpos-32767)/32.768);
        joy.a=(int)(((int)ji.dwZpos-32767)/32.768);
        if (joy.astart==2000)
        {
          //after start initialize astart with first valid a-value
          if (ji.dwZpos == 32767)
          {
            joy.a=2000;
          }
          else
          {
            joy.astart=joy.a;
          }
        }
        
        
        static int sentTime=0;
        static JoystickData joystickData;
        joystickData.x = (-(double)joy.y)/1000;
        joystickData.y = (-(double)joy.x)/1000;
        joystickData.z = (-(double)joy.z)/1000;
        joystickData.accel = (1000.0-(double)joy.a)/2000;
        joystickData.button |= joy.b;
        joystickData.coolie = joy.c+1;
        
        
        
        //	 if ((joy.b >> (1-1) & 1) == 1)
        //	 {
        //		 joystickData.directSpecialAction = true;
        //         joystickData.specialActionID = MotionRequest::chestKick2;
        //	 }
        //	 
        //	 else joystickData.directSpecialAction = false;
        
        joystickData.directSpecialAction = true;	
        if ((joy.b >> (1-1) & 1) == 1)
        {
          joystickData.specialActionID = MotionRequest::chestKick1;
        }
        else if ((joy.b >> (2-1) & 1) == 1)
        {
          joystickData.specialActionID = MotionRequest::headKick;
        }
        else if ((joy.b >> (3-1) & 1) == 1)
        {
          joystickData.specialActionID = MotionRequest::leftKick;
        }
        else if ((joy.b >> (4-1) & 1) == 1)
        {
          joystickData.specialActionID = MotionRequest::rightKick;
        }
        else joystickData.directSpecialAction = false;
        
        
        if ((SystemCall::getTimeSince(sentTime) >= 300))
        {
          getQueues().toPhysical.robot[joyNo+roboNoOffset].out.bin << joystickData;
          getQueues().toPhysical.robot[joyNo+roboNoOffset].out.finishMessage(idJoystickData);
          
          getQueues().toSimulated.robot[joyNo+roboNoOffset].out.bin << joystickData << endl;
          getQueues().toSimulated.robot[joyNo+roboNoOffset].out.finishMessage(idJoystickData);
          
          joystickData.button = 0;
          sentTime=SystemCall::getCurrentSystemTime();
        }
      }
    }
  }
  else 
  {// begin single-player-mode
    
    
    
    
    
    // start single
    joyresult=joyGetPosEx(JOYSTICKID1,&ji);
    if (joyresult!=0)
    {
      //there is no joystick attached -> JoystickMotionTester would be useless
      m_useJoystick.SetCheck(FALSE);
      OnUseJoystick();
      
    }
    else
    {
      joy.b=ji.dwButtons;
      joy.c=ji.dwPOV==65535?-1:ji.dwPOV/4500;
      for (int i=0;i<8;i++)
      {
        bu[i]=((joy.b>>i)&1)?'1':'0';
      }
      joy.x=(int)(((int)ji.dwXpos-32767)/32.768);
      joy.y=(int)(((int)ji.dwYpos-32767)/32.768);
      joy.z=(int)(((int)ji.dwRpos-32767)/32.768);
      joy.a=(int)(((int)ji.dwZpos-32767)/32.768);
      if (joy.astart==2000)
      {
        //after start initialize astart with first valid a-value
        if (ji.dwZpos == 32767)
        {
          joy.a=2000;
        }
        else
        {
          joy.astart=joy.a;
        }
      }
      
      switch (scheme)
      {
      case sStickSpeed:
        {
          /** @todo Coolie beim Gucken und Laufen, Schub beim Gucken? */
          if ((joy.b >> (8-1) & 1) == 1)  //button 8 = WalkTypeWechsel
          {
            if (! joy.walktypechange)
            {
              joy.walktype++;
              joy.walktype %= MotionRequest::numOfWalkType;
            }
            joy.walktypechange=TRUE;
          }
          else
          {
            joy.walktypechange=FALSE;
          }
          if ((joy.b >> (7-1) & 1) == 1)  //button 7 = Getup
          {
            sendSpecialAction(-1);
          }
          else if ((joy.b >> (1-1) & 1) == 1)
          {
            sendSpecialAction(MotionRequest::chestKick1);
          }
          else if ((joy.b >> (2-1) & 1) == 1)
          {
            sendSpecialAction(MotionRequest::headKick);
          }
          else if ((joy.b >> (3-1) & 1) == 1)
          {
            sendSpecialAction(MotionRequest::leftKick);
          }
          else if ((joy.b >> (4-1) & 1) == 1)
          {
            sendSpecialAction(MotionRequest::rightKick);
          }
          
          switch (joy.mode)
          {
          case jWalking:
            if (joy.b == (1<<(5-1)))  //only button 5 pressed
            {
              joy.mode=jLooking;
            }
            else if (joy.b == (1<<(6-1)))  //only button 6 pressed
            {
              joy.mode=jSpecial;
              joy.astart=joy.a;
            }
            else
            {
              changeHeadControlMode();
              sendHeadControlMode(joy.headControl.mode);
              sendMotionRequest();
            }
            break;
          case jLooking:
            if (joy.b == (1<<(6-1)))  //only button 6 pressed
            {
              joy.mode=jSpecial;
              joy.astart=joy.a;
            }
            else if ((joy.b&(1<<(5-1)))==0)  //button 5 not pressed
            {
              joy.mode=jWalking;
              joy.astart=joy.a;
            }
            else
            {
              sendHeadMotionRequest(joy.x,joy.y,joy.z);
            }
            break;
          case jSpecial:
            if (joy.b == (1<<(5-1)))  //only button 5 pressed
            {
              joy.mode=jLooking;
            }
            else if ((joy.b&(1<<(6-1)))==0)  //button 6 not pressed
            {
              sendSpecialAction();
              joy.mode=jWalking;
              joy.astart=joy.a;
            }
            else
            {
              changeSpecialAction();
            }
            break;
          }
          break;
        }
      case sAcceleratorSpeed:
        {
          //Coolie= geheime SpecialActions
          if (joy.c>=0)
          {
            sendSpecialAction(100+joy.c);
          }
          
          if ((joy.b >> (6-1) & 1) == 1)  //button 6 = WalkTypeWechsel
          {
            if (! joy.walktypechange)
            {
              joy.walktype++;
              joy.walktype %= MotionRequest::numOfWalkType;
            }
            joy.walktypechange=TRUE;
          }
          else
          {
            joy.walktypechange=FALSE;
          }
          if ((joy.b >> (7-1) & 1) == 1)  //button 7 = Getup
          {
            sendSpecialAction(-1);
          }
          else if ((joy.b >> (1-1) & 1) == 1)
          {
            sendSpecialAction(MotionRequest::chestKick1);
          }
          else if ((joy.b >> (2-1) & 1) == 1)
          {
            sendSpecialAction(MotionRequest::headKick);
          }
          else if ((joy.b >> (3-1) & 1) == 1)
          {
            sendSpecialAction(MotionRequest::leftKick);
          }
          else if ((joy.b >> (4-1) & 1) == 1)
          {
            sendSpecialAction(MotionRequest::rightKick);
          }
          switch (joy.mode)
          {
          case jWalking:
            if (joy.b == (1<<(5-1)))  //only button 5 pressed
            {
              joy.mode=jLooking;
            }
            else
            {
              sendMotionRequest();
            }
            break;
          case jLooking:
            if ((joy.b&(1<<(5-1)))==0)  //button 5 not pressed
            {
              joy.mode=jWalking;
              joy.astart=joy.a;
            }
            else
            {
              sendHeadMotionRequest(joy.x,joy.y,joy.z);
            }
            break;
          }
        }
      case sRaw:
        {
          static int sentTime=0;
          static JoystickData joystickData;
          joystickData.x = (-(double)joy.y)/1000;
          joystickData.y = (-(double)joy.x)/1000;
          joystickData.z = (-(double)joy.z)/1000;
          joystickData.accel = (1000.0-(double)joy.a)/2000;
          joystickData.button |= joy.b;
          joystickData.coolie = joy.c+1;
          if ((SystemCall::getTimeSince(sentTime) >= 300))
          {
            getQueues().toPhysical.selectedRobot.out.bin << joystickData;
            getQueues().toPhysical.selectedRobot.out.finishMessage(idJoystickData);
            
            getQueues().toSimulated.selectedRobot.out.bin << joystickData << endl;
            getQueues().toSimulated.selectedRobot.out.finishMessage(idJoystickData);
            
            joystickData.button = 0;
            sentTime=SystemCall::getCurrentSystemTime();
          }
        }
    }
    UpdateData();
    Invalidate(FALSE);
    }
  }  
  CDynamicBarDlg::OnTimer(nIDEvent);
}  

void CJoystickMotionTesterDlgBar::drawRobot(CDC* dc, double x, double y, double r, double scale)
{
  POINT p[4];
  p[0].x=(int)(x+cos(r)*(1+2*scale));
  p[0].y=(int)(y+sin(r)*(1+2*scale));
  p[1].x=(int)(x-cos(r)*(1+2*scale));
  p[1].y=(int)(y-sin(r)*(1+2*scale));
  p[2].x=(int)(x-cos(r)*(1+2*scale)+cos(r+pi_2)*(2+7*scale));
  p[2].y=(int)(y-sin(r)*(1+2*scale)+sin(r+pi_2)*(2+7*scale));
  p[3].x=(int)(x+cos(r)*(1+2*scale)+cos(r+pi_2)*(2+7*scale));
  p[3].y=(int)(y+sin(r)*(1+2*scale)+sin(r+pi_2)*(2+7*scale));
  dc->Polygon(p,4);
}

void CJoystickMotionTesterDlgBar::OnPaint() 
{
  CPaintDC dc(this);
  CRect rect;
  GetClientRect(&rect);
  
  if(!GetParent()->IsIconic() && rect.right && rect.bottom)
  {
    if(!m_pBitmap || rect != m_rect)
    {
      m_rect = rect;
      if(m_pBitmap)
        delete m_pBitmap;
      m_pBitmap = new CBitmap;
      m_pBitmap->CreateCompatibleBitmap(&dc,rect.right,rect.bottom);
    }
    CDC dcMem;
    dcMem.CreateCompatibleDC(&dc);
    CBitmap* pBitmap = dcMem.SelectObject(m_pBitmap);
    
    CBrush br(GetSysColor(COLOR_3DFACE));
    dcMem.FillRect(&rect,&br);
    dcMem.SetBkColor(GetSysColor(COLOR_3DFACE));

    if (scheme!=sRaw)
    {
    static double randx[20]={1,1,1,1,1,1,0.6,0.2,-0.2,-0.6,-1,-1,-1,-1,-1,-1,-0.6,-0.2,0.2,0.6};
    static double randy[20]={1,0.6,0.2,-0.2,-0.6,-1,-1,-1,-1,-1,-1,-0.6,-0.2,0.2,0.6,1,1,1,1,1};
    int centerx,centery,radi;
    char s[128];
    
    if (sizex-90>sizey)
    {
      centery=sizey/2;
    }
    else
    {
      centery=(sizex-90)/2;
    }
    centerx=sizex-centery;
    if (centery>15)
    {
      radi=centery-5;
    }
    else
    {
      radi=10;
    }
    
    RECT r;
    r.top=centery>80?centery/2:40;
    r.bottom=r.top+16;
    r.left=1;
    r.right=sizex;
    if (joy.mode!=jDisabled)
    {
    switch(joy.mode)
    {
    case jLooking:
      {
        dcMem.DrawText("looking",7,&r,0);
        dcMem.Ellipse(centerx-radi,centery-radi,centerx+radi,centery+radi);
        POINT p[20];
        Pose2D borderPos;
        for (int i=0;i<20;i++)
        {
        /** @todo initialize borderPos with point on border */
        /*
          double x = relBallPos.translation.x;
          double z = pz - ballRadius;
          
            // calculation of tilt joint for the HeadMotionRequest
            double tilt = atan(x / z) + acos(distanceNeckToPanCenter / sqrt(x * x + z * z)) - pi;
            
              // tilt moves position of pan joint, so recalculate
              robotPose += Vector2<double>(sin(-tilt) * distanceNeckToPanCenter,0);
              relBallPos = ballPosition - robotPose;
              
                x = relBallPos.translation.x;
                z += cos(-tilt) * distanceNeckToPanCenter;
                
                  // calculation of pan joint on diagonal surface for the HeadMotionRequest
                  double pan = atan2(relBallPos.translation.y,
                  sqrt(x * x + z * z));
          */
          
          p[i].x=(int)(centerx+sent.headMotion.pan*radi/105+cos(sent.headMotion.roll*pi/180)*randx[i]*radi/5+cos(sent.headMotion.roll*pi/180+pi_2)*randy[i]*radi/6);
          p[i].y=(int)(centery+sent.headMotion.tilt*radi/105+sin(sent.headMotion.roll*pi/180)*randx[i]*radi/5+sin(sent.headMotion.roll*pi/180+pi_2)*randy[i]*radi/6);
        }
        dcMem.Polygon(p,20);
        break;
      }
    case jWalking:
      {
        dcMem.DrawText("walking",7,&r,0);
        double x=centerx, y=centery/1.1;
        double r=0;
        drawRobot(&dcMem,x,y,r,radi/18);
        int trajx[129], trajy[129];
        for (int i=0; i<=128;i++)
        {
          trajx[i]=(int)x;
          trajy[i]=(int)y;
          x+=(cos(r)*sent.motion.xspeed+cos(r+pi_2)*sent.motion.yspeed)/128*radi/200;
          y+=(sin(r)*sent.motion.xspeed+sin(r+pi_2)*sent.motion.yspeed)/128*radi/200;
          r+=(double)sent.motion.arcspeed/128/180*pi;
        }
        drawRobot(&dcMem,x,y,r,radi/18);
        dcMem.MoveTo(trajx[0],trajy[0]);
        for (i=1; i<=128;i++)
        {
          dcMem.LineTo(trajx[i],trajy[i]);
        }
        if ((trajx[0]-trajx[128])*(trajx[0]-trajx[128])+(trajy[0]-trajy[128])*(trajy[0]-trajy[128])>(radi/20)*(radi/20))
        {
          double w=r+atan2((double)sent.motion.yspeed,(double)sent.motion.xspeed);
          dcMem.LineTo((int)(x+cos(w-5*pi/6)*(2+radi/18)),(int)(y+sin(w-5*pi/6)*(2+radi/18)));
          dcMem.MoveTo(trajx[128],trajy[128]);
          dcMem.LineTo((int)(x+cos(w+5*pi/6)*(2+radi/18)),(int)(y+sin(w+5*pi/6)*(2+radi/18)));
        }
        break;
      }
    case jSpecial:
      dcMem.DrawText("special",7,&r,0);
      break;
    case jDisabled:
      dcMem.DrawText("not joysticking",15,&r,0);
      break;
    }
      switch (scheme)
      {
      case sStickSpeed:
        {
          if (joy.headControl.time<=sent.headMotion.time)
          {
            dcMem.SetTextColor(0xaaaaaa);
            sprintf(s,"hcm=%s",HeadControlMode::getHeadControlModeName((HeadControlMode::HeadControlModes)sent.headControl.mode));
          }
          else if (joy.headControl.mode!=sent.headControl.mode)
          {
            dcMem.SetTextColor(0x0000dd);
            sprintf(s,"hcm=%s",HeadControlMode::getHeadControlModeName((HeadControlMode::HeadControlModes)joy.headControl.mode));
          }
          else
          {
            dcMem.SetTextColor(0x000000);
            sprintf(s,"hcm=%s",HeadControlMode::getHeadControlModeName((HeadControlMode::HeadControlModes)sent.headControl.mode));
          }
          r.top=centery>80?centery*3/4:60; r.bottom=r.top+16;  r.left=5;
          dcMem.DrawText(s,strlen(s),&r,0);
          break;
        }
      }
      
      if ((sent.motion.time<=sent.headMotion.time)||(sent.motion.time<=sent.special.time))
      {
        dcMem.SetTextColor(0xaaaaaa);
      }
      else
      {
        dcMem.SetTextColor(0x000000);
      }
      sprintf(s,"walktype=%s",MotionRequest::getWalkTypeName(static_cast<enum MotionRequest::WalkType>(joy.walktype)));
      
      r.top=centery>80?centery:80; r.bottom=r.top+16;  r.left=5;
      dcMem.DrawText(s,strlen(s),&r,0);
      
      if ((joy.special.time<=sent.motion.time)&&(sent.special.time<=sent.motion.time))
      {
        dcMem.SetTextColor(0xaaaaaa);
        if (sent.special.action>=100)
        {
          sprintf(s,"sa=unsw_%i",sent.special.action-98);
        }
        else
        {
          sprintf(s,"sa=%s",sent.special.action>=0?MotionRequest::getSpecialActionName((MotionRequest::SpecialActionID)sent.special.action):MotionRequest::getMotionName(MotionRequest::getup));
        }
      }
      else if (joy.special.time>=sent.special.time)
      {
        dcMem.SetTextColor(0x0000ff);
        sprintf(s,"sa=%s",joy.special.action>=0?MotionRequest::getSpecialActionName((MotionRequest::SpecialActionID)joy.special.action):MotionRequest::getMotionName(MotionRequest::getup));
      }
      else
      {
        dcMem.SetTextColor(0x000000);
        if (sent.special.action>=100)
        {
          sprintf(s,"sa=unsw_%i",sent.special.action-98);
        }
        else
        {
          sprintf(s,"sa=%s",sent.special.action>=0?MotionRequest::getSpecialActionName((MotionRequest::SpecialActionID)sent.special.action):MotionRequest::getMotionName(MotionRequest::getup));
        }
      }
      r.top=centery>80?centery*5/4:100; r.bottom=r.top+16;
      dcMem.DrawText(s,strlen(s),&r,0);
    }
    }
    dc.BitBlt(0,0,rect.right,rect.bottom,&dcMem,0,0,SRCCOPY);
    dcMem.SelectObject(pBitmap);
  }
}

void CJoystickMotionTesterDlgBar::OnSize(UINT nType, int cx, int cy) 
{
  CDynamicBarDlg::OnSize(nType, cx, cy);
  if ((sizex!=cx)||(sizey!=cy))
  {
    Invalidate(FALSE);
  }
  sizex=cx;
  sizey=cy;
}

void CJoystickMotionTesterDlgBar::OnSelchangeScheme() 
{
  scheme = (JScheme)(m_scheme.GetCurSel());
  AfxGetApp()->WriteProfileInt("JoystickMotionTester", "Scheme",m_scheme.GetCurSel());
  if (joy.mode!=jDisabled)
  {
    joy.mode=jWalking;
    joy.astart=2000;
  }
}

/*
* Change log :
* 
* $Log: JoystickMotionTesterDlgBar.cpp,v $
* Revision 1.7  2004/06/21 11:28:01  dueffert
* initialization bug fixed; indented
*
* Revision 1.6  2004/06/12 11:45:43  altmeyer
* 2x2 Support (2 Player per Laptop)
*
* Revision 1.5  2004/06/11 21:50:22  altmeyer
* added 4-Joystick supported (but not under Windows XP, only 2 joystick..?!)
*
* Revision 1.4  2003/12/09 19:49:25  loetzsch
* Renamed some of the main queues of RobotControl.
*
* Added possibility to send messages to specific simulated or physical robots.
*
* Revision 1.3  2003/12/04 22:56:07  roefer
* Compatibility with VC2003.NET
*
* Revision 1.2  2003/11/30 01:53:19  loetzsch
* prepared RobotControl port to Visual C++ .Net
*
* Revision 1.1  2003/10/07 10:09:38  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.3  2003/09/26 15:28:23  juengel
* Renamed DataTypes to representations.
*
* Revision 1.2  2003/09/26 11:40:12  juengel
* - sorted tools
* - clean-up in DataTypes
*
* Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.7  2003/05/11 23:46:34  dueffert
* Depend now works with RobotControl too
*
* Revision 1.6  2003/03/05 17:09:27  loetzsch
* redesign of the queues and debug key tables in RobotControl
*
* Revision 1.5  2003/03/03 18:08:35  dueffert
* first behavior on raw joystick data
*
* Revision 1.4  2003/02/27 16:12:10  dueffert
* joystick raw mode added
*
* Revision 1.3  2002/11/28 14:06:08  dueffert
* docu improved
*
* Revision 1.2  2002/09/22 18:40:51  risler
* added new math functions, removed GTMath library
*
* Revision 1.1  2002/09/10 15:49:05  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.5  2002/08/18 12:25:36  dueffert
* beautifying for release
*
* Revision 1.4  2002/07/23 13:43:36  loetzsch
* - new streaming classes
* - removed many #include statements
* - 5 instead of 3 debug queues in RobotControl
* - exchanged StaticQueue with MessageQueue
* - new debug message handling
* - empty constructors in bars / dialogs
* - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
* - general clean up
*
* Revision 1.3  2002/06/20 23:39:47  dueffert
* double instead of double
*
* Revision 1.2  2002/05/31 14:57:08  dueffert
* WalkType support added
*
* Revision 1.1.1.1  2002/05/10 12:40:21  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.16  2002/05/03 11:49:56  juengel
* Removed secretSpecialActionID.
*
* Revision 1.15  2002/05/02 12:12:33  kallnik
* GTMath
*
* Revision 1.14  2002/04/25 14:50:34  kallnik
* changed double/float to double
* added several #include GTMath
*
* PLEASE use double
*
* Revision 1.13  2002/04/24 07:49:14  risler
* changed normalWalkMaxSpeed to walkMaxSpeed
*
* Revision 1.12  2002/04/23 17:45:16  loetzsch
* - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
* - removed Modules Toolbar
* - removed access for dialogs and toolbars to solutionRequest.
* - changed access for dialogs and toolbars to debug queues
* - removed the instance of SolutionRequest in CRobotControlApp
* - only the log player, local processes and the robot put messages into queueToRobotControl
*
* Revision 1.11  2002/04/23 15:08:44  risler
* changed MotionRequest: walk instead of normalWalk,... and walkType added
*
* Revision 1.10  2002/04/16 15:59:10  dueffert
* no message
*
* Revision 1.9  2002/04/09 13:13:05  dueffert
* no message
*
* Revision 1.4  2002/04/02 15:38:12  dueffert
* minor odometry enhancements
*
* Revision 1.3  2002/03/29 18:12:27  dueffert
* JoystickMotionTester improved
*
* Revision 1.8  2002/03/29 16:04:42  dueffert
* schemes added
*
* Revision 1.7  2002/03/12 17:29:56  dueffert
* works fine now though response times could be better
*
* Revision 1.6  2002/03/11 18:32:19  dueffert
* JoystickMotionTester nearly complete
*
* Revision 1.5  2002/03/07 15:50:37  dueffert
* no message
*
* Revision 1.4  2002/03/06 16:13:41  dueffert
* JoystickMotionTester state machine implemented
*
* Revision 1.3  2002/03/05 20:05:09  dueffert
* joystick: polling instead of messages, sorry, but messages cant deal with all buttons/axes
*
* Revision 1.2  2002/03/04 14:29:24  dueffert
* no message
*
* Revision 1.1  2002/03/04 11:54:13  dueffert
* JoystickMotionTester added
*
*
*/
