#ifndef __MotionOptimizer_h_
#define __MotionOptimizer_h_

#include "Modules/WalkingEngine/InvKinWalkingEngine.h"

class MotionOptimizer;

#pragma warning(disable:4786) 
#include "MotionOptimizerController.h"
#include "Tools/Streams/InStreams.h"
#include "Tools/Streams/OutStreams.h"
#include <iterator>
#include <map>
#include <string>

class MotionOptimizer
{
public:

  MotionOptimizer ( MotionOptimizerController& controller );

  void reset();
  bool hasNext();
  int getNext ( InvKinWalkingParameters &paramset );
  void setResult ( int paramSetId, double result );
private:

  bool readInput();
  void writeOutput ( int paramSetId, double result );
  void printParamset(const InvKinWalkingParameters &paramset, char* msg);

  int read;
  std::map<int,InvKinWalkingParameters> input;
  std::map<int,InvKinWalkingParameters> assigned;
  int written;
  std::map<int,double> output;
  
  MotionOptimizerController& controller;

  char* fileIn;
  char* fileOut;
};

#endif //  __MotionOptimizer_h_