#ifndef __MotionOptimizerRobot_h_
#define __MotionOptimizerRobot_h_

class MotionOptimizerRobot;

#include "MotionOptimizerController.h"

#include "Modules/BehaviorControl/MotionRatingBehaviorControl/MotionRatingBehaviorMessage.h"
#include "Modules/WalkingEngine/InvKinWalkingEngine.h"

class MotionOptimizerRobot
{
public:
  MotionOptimizerRobot ( MotionOptimizerController* dlg, int robotId, bool isPhysical, int listItem );

  int getId() const { return id; }
  int getItem() const { return item; }
  bool isPhysical() const { return physical; }
  int getRemainingPower() const { return battery; }
  int getMessageCount() const { return messages; }
  int getParamSetId() const { return paramSetId; }
  double getCurrentSpeed() const { return currSpeed; }
  double getAverageSpeed() const { return avgSpeed; }
  int getCurrentWalk() const { return currentWalk; }
  int getWalkCount() const { return walkCount; }

  MotionRatingBehaviorMessage::States getState() const {return state; }
  char* getStateName() const { return MotionRatingBehaviorMessage::getStateName ( state ); }

  bool handleMessage ( MotionRatingBehaviorMessage& message );
  bool notify();

  bool init ( int path );
  bool test ( int paramSetId, InvKinWalkingParameters& paramSet );

private:
  MotionOptimizerController* dialog;

  int id;
  bool physical;
  int item;
  int messages;
  int battery;
  int paramSetId;
  double currSpeed, avgSpeed;
  int currentWalk, walkCount;

  unsigned int lastMessage;

  MotionRatingBehaviorMessage::States state, realState;

  MessageQueue& getQueueToRobot();
  void sendMessage ( MotionRatingBehaviorMessage& message );

};

#endif //  __MotionOptimizerRobot_h_