// MotionOptimizerDlgBar.cpp: Implementierungsdatei
//

#include "StdAfx.h"

#include "MotionOptimizerRobotList.h"

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CMotionOptimizerDlgBar 


MotionOptimizerRobotList::MotionOptimizerRobotList()
{
}

MotionOptimizerRobotList::~MotionOptimizerRobotList()
{
  for ( RobotList::const_iterator pos = robots.begin(); pos != robots.end(); pos++ )
    delete (*pos);
}

void MotionOptimizerRobotList::addRobot ( MotionOptimizerRobot* robot )
{
  robots.push_back ( robot );
}

bool MotionOptimizerRobotList::hasWaitingRobot()
{
  return getWaitingRobot() != 0;
}

bool MotionOptimizerRobotList::hasSleepingRobot()
{
  return getSleepingRobot() != 0;
}

MotionOptimizerRobot* MotionOptimizerRobotList::getRobot ( int id, bool physical )
{
  MotionOptimizerRobot* robot = 0;
  for ( RobotList::const_iterator pos = robots.begin(); pos != robots.end(); pos++ )
  {
    if ( ( (*pos)->getId() == id ) && ( (*pos)->isPhysical() == physical ) )
      robot = (*pos);
  }
  return robot;
}

MotionOptimizerRobot* MotionOptimizerRobotList::getRobot ( MotionRatingBehaviorMessage::States state )
{
  MotionOptimizerRobot* robot = 0;
  for ( RobotList::const_iterator pos = robots.begin(); pos != robots.end(); pos++ )
  {
    if ( (*pos)->getState() == state )
      robot = (*pos);
  }
  return robot;
}

MotionOptimizerRobot* MotionOptimizerRobotList::getWaitingRobot()
{
  return getRobot ( MotionRatingBehaviorMessage::waiting );
}

MotionOptimizerRobot* MotionOptimizerRobotList::getSleepingRobot()
{
  return getRobot ( MotionRatingBehaviorMessage::sleeping );
}
