#ifndef __MotionOptimizerRobotList_h_
#define __MotionOptimizerRobotList_h_

#include <list>

#include "Modules/BehaviorControl/MotionRatingBehaviorControl/MotionRatingBehaviorMessage.h"

class CMotionOptimizerDlgBar;

#include "MotionOptimizerRobot.h"

typedef std::list<MotionOptimizerRobot*> RobotList;

class MotionOptimizerRobotList
{
public:
	MotionOptimizerRobotList();
	~MotionOptimizerRobotList();

  void addRobot ( MotionOptimizerRobot* robot );

  MotionOptimizerRobot* getRobot ( int id, bool pyhsical );
  MotionOptimizerRobot* getRobot ( MotionRatingBehaviorMessage::States );

  bool hasWaitingRobot();
  MotionOptimizerRobot* getWaitingRobot();
  bool hasSleepingRobot();
  MotionOptimizerRobot* getSleepingRobot();

protected:
  RobotList robots;

};

#endif //  __MotionOptimizerRobotList_h_
