/**
* @file MotionTesterDlgBar.h
*
* Declaration of class CMotionTesterDlgBar.
*
* @author Martin Ltzsch
*/

#ifndef __MotionTesterDlgBar_h_
#define __MotionTesterDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"

#include "Representations/Motion/MotionRequest.h"
 
/** 
* @class CMotionTesterDlgBar 
*
* A dialog bar for sending motion requests
*
* @author Martin Ltzsch
*/
class CMotionTesterDlgBar : public CRobotControlDialogBar
{
public:
  /**
  * Default constructor.
  */
  CMotionTesterDlgBar();

	//{{AFX_DATA(CMotionTesterDlgBar)
	enum { IDD = IDD_DIALOG_BAR_MOTIONTESTER };
	CComboBox	m_tailCombo;
	CStatic	m_tailStatic;
	CComboBox	m_walkTypeCombo;
	CListBox	m_typeList;
  CSliderCtrl m_walkSlider1;
  CSliderCtrl m_walkSlider2;
  CSliderCtrl m_walkSlider3;
  CStatic m_forwardStatic;
  CStatic m_backwardStatic;
  CStatic m_leftStatic;
  CStatic m_rightStatic;
  CStatic m_rotLeftStatic;
  CStatic m_rotRightStatic;
  CStatic m_forwardBackwardStatic;
  CStatic m_leftRightStatic;
  CStatic m_rotLeftRightStatic;
  CListBox m_specialActionList;
  CButton	m_sendButton;
	CButton	m_resetButton;
  CButton m_stabilizeCheck;
  CButton m_updateRPCheck;
  CButton m_breatheCheck;
	CButton m_smoothControlCheck;
	CButton m_stopButton;
	//}}AFX_DATA


	//{{AFX_VIRTUAL(CMotionTesterDlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);  
  virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL

  void OnHScroll();
  void showCurrentMotion(int mode);
	double makeSmooth(double value);

  MotionRequest motionRequest;

  unsigned long lastSentTime;
	bool smoothControlMode;
protected:

	//{{AFX_MSG(CMotionTesterDlgBar)
	afx_msg void OnSend();
	afx_msg void OnReset();
	afx_msg void OnSelchangeSpecialActionList();
	afx_msg void OnUpdateControl(CCmdUI* pCmdUI);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnDblclkSpecialActionList();
	afx_msg void OnSelchangeTypeList();
	afx_msg void OnDblclkTypeList();
	afx_msg void OnStabilizeCheck();
	afx_msg void OnUpdateRPCheck();
	afx_msg void OnBreatheCheck();
	afx_msg void OnSmoothControlCheck();
	afx_msg void OnSelchangeWalkType();
	afx_msg void OnButtonA();
	afx_msg void OnButtonD();
	afx_msg void OnButtonE();
	afx_msg void OnButtonQ();
	afx_msg void OnButtonS();
	afx_msg void OnButtonW();
	afx_msg void OnButtonX();
	afx_msg void OnSelchangeTailCombo();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP();
};

//{{AFX_INSERT_LOCATION}}

#endif // __MotionTesterDlgBar_h_

/*
 * Change log :
 * 
 * $Log: MotionTesterDlgBar.h,v $
 * Revision 1.3  2004/03/16 14:00:23  juengel
 * Integrated Improvments from "Gnne"
 * -ATH2004ERS7Behavior
 * -ATHHeadControl
 * -KickSelectionTable
 * -KickEditor
 *
 * Revision 1.2  2004/03/15 17:11:40  hoffmann
 * - added ATH2004HeadControl
 * - added ATH2004LEDControl
 * - headmotiontester shows "tilt2"
 * - motion process updates odometry while no new robotPose is received, added to motion request
 * - some ui adjustments
 * - added member function to "field" to find out if robot is in own penalty area for use in the obstacles locator
 *
 * Revision 1.2  2004/01/29 12:21:48  jhoffman
 * UI changes:
 * - Main menu entries renamed, reordered, added some new icons
 * - delete-confirmation in settings and WLAN dialog
 * - settings dialog uses icons, radio buttons added
 * - WLAN dialog restructured
 * - motion tester and head motion tested layout improved, stop button added
 * - check boxes replaced by radio buttons where appropriate
 *
 * Revision 1.1  2003/10/07 10:09:38  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/26 15:28:23  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.4  2003/06/04 16:43:09  dassler
 * Added a smooth robot movement. By using the Doom buttons the value of the movement is changed by 10% of the max value.
 * A checkbox turns smooth feature on/off
 *
 * Revision 1.3  2003/05/11 23:46:34  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.2  2002/11/25 14:48:18  jhoffman
 * "breath" check box added to motion tester
 *
 * Revision 1.1  2002/09/10 15:49:05  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.4  2002/08/30 17:13:56  dueffert
 * doxygen parser bugs fixed, docu added
 *
 * Revision 1.3  2002/07/23 13:43:37  loetzsch
 * - new streaming classes
 * - removed many #include statements
 * - 5 instead of 3 debug queues in RobotControl
 * - exchanged StaticQueue with MessageQueue
 * - new debug message handling
 * - empty constructors in bars / dialogs
 * - access to debugkeytables and queues via RobotControlQueues.h and RobotControlDebugKeyTables.h
 * - general clean up
 *
 * Revision 1.2  2002/06/04 16:44:55  risler
 * tailRequest added
 *
 * Revision 1.1.1.1  2002/05/10 12:40:21  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.10  2002/04/23 17:45:16  loetzsch
 * - splitted debugKeyTable into debugKeyTableForRobot and debugKeyTableForLocalProcesses
 * - removed Modules Toolbar
 * - removed access for dialogs and toolbars to solutionRequest.
 * - changed access for dialogs and toolbars to debug queues
 * - removed the instance of SolutionRequest in CRobotControlApp
 * - only the log player, local processes and the robot put messages into queueToRobotControl
 *
 * Revision 1.9  2002/04/23 15:08:44  risler
 * changed MotionRequest: walk instead of normalWalk,... and walkType added
 *
 * Revision 1.8  2002/04/04 16:19:06  jhoffman
 * added stabilizer check box
 *
 * Revision 1.7  2002/02/13 01:41:07  risler
 * changed motion tester layout
 *
 * Revision 1.6  2002/02/12 16:34:49  risler
 * finished MofTester
 *
 * Revision 1.5  2002/01/20 20:46:17  loetzsch
 * increased usability
 *
 * Revision 1.4  2002/01/19 21:36:26  risler
 * added HeadMotionTester, HeadControlSelector
 *
 * Revision 1.3  2002/01/18 02:17:39  loetzsch
 * MotionTester dialog and distribution of MotionRequests
 * to the processes programmed.
 *
 * Revision 1.2  2001/12/10 17:47:09  risler
 * change log added
 *
 */
