/**
* @file MultipleFieldsDlgBar.h
*
* Declaration of class CMultipleFieldsDlgBar
*
* @author Martin Ltzsch
*/

#ifndef __MultipleFieldsDlgBar_h_
#define __MultipleFieldsDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"

#include "Visualization/DebugDrawingManager/DebugDrawingManager.h"

/**
* @class CMultipleFieldsDlgBar 
* 
* A dialog bar for displaying four field views
*
* @author Martin Ltzsch
*/
class CMultipleFieldsDlgBar : public CRobotControlDialogBar
{
public:
  /** Default constructor.*/
  CMultipleFieldsDlgBar();

  /** Destructor */
  ~CMultipleFieldsDlgBar();

	//{{AFX_DATA(CMultipleFieldsDlgBar)
	enum { IDD = IDD_DIALOG_BAR_MULTIPLE_FIELDS };
	//}}AFX_DATA

	//{{AFX_VIRTUAL(CMultipleFieldsDlgBar)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    
  virtual BOOL OnInitDialog();
	//}}AFX_VIRTUAL
  
protected:
  /** the rectangle in the dialog for painting */
  CRect paintRect;

  /** the rectangle in the bitmap for painting */
  CRect currentRect;

  /** An off screen device cotext for painting*/
  CDC dcOffScreen;
  
  /** A bitmap that is selected by dcOffScreen*/
  CBitmap* bmpOffScreen;

  /** The old bitmap that is selected by dcOffScreen at the end to enable
  *   the destruction of bmpOffScreen.
  */
  CBitmap* oldBitmap;


	//{{AFX_MSG(CMultipleFieldsDlgBar)
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP();
};

//{{AFX_INSERT_LOCATION}}

#endif //__MultipleFieldsDlgBar_h_

/*
 * Change log :
 * 
 * $Log: MultipleFieldsDlgBar.h,v $
 * Revision 1.1  2003/12/09 18:15:31  loetzsch
 * added dialog bar "multiple fields"
 *
*/
