// OptionRatingDlgBar.cpp : implementation file
//

#include "StdAfx.h"
#include "OptionRatingDlgBar.h"
#include "Tools/DynamicTeamTactic/RateableOptions.h"
#include "Tools/DynamicTeamTactic/CollectedBeliefs.h"

static char AsciiBars[11][11] = {" ",
	                               "|",
                                 "||",
																 "|||",
																 "||||",
																 "|||||",
																 "||||||",
																 "|||||||",
																 "||||||||",
																 "|||||||||",
																 "||||||||||"};
/////////////////////////////////////////////////////////////////////////////
// COptionRatingDlgBar dialog


COptionRatingDlgBar::COptionRatingDlgBar()
	: CRobotControlDialogBar(IDD)
{
	//{{AFX_DATA_INIT(COptionRatingDlgBar)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

COptionRatingDlgBar::~COptionRatingDlgBar()
{
}

bool COptionRatingDlgBar::handleMessage(InMessage& message)
{

  if (message.getMessageID() == idSingleBeliefs)
  {      
    // insert stuff here
		int tmp = 0;
    SingleBeliefs as;
		message.bin >> as;
		if (m_VisCheck.GetCheck() ==0)
		{
  		char buffer[10];
      for (int i = 0; i < RateableOptions::numOfOptions; ++i){
        tmp = as.ratedOptions[i];
				sprintf( buffer, "%d", tmp);
	    	m_List.SetItem(i,
		    	             message.getPlayerNumber()+1,
			    						 LVIF_TEXT,
				    					 buffer,
					    				 0,0,0,0);
      }
		}
		else
      for (int i = 0; i < RateableOptions::numOfOptions; ++i){
        tmp = as.ratedOptions[i];
	    	m_List.SetItem(i,
		    	             message.getPlayerNumber()+1,
			    						 LVIF_TEXT,
				    					 AsciiBars[tmp / 10],
					    				 0,0,0,0);
		}
    return true;
  }
	if (message.getMessageID() == idChoosenOption)
	{
    char* buf = (char*)malloc(message.getMessageSize()*2+1);
    message.text.readAll(buf);
	  m_List.SetItem(RateableOptions::numOfOptions+1,
			             message.getPlayerNumber()+1,
									 LVIF_TEXT,
									 buf,
									 0,0,0,0);
    delete[](buf);
    return true;
	}
	if (message.getMessageID() == idChoosenTacticEntry)
	{
    char* buf = (char*)malloc(message.getMessageSize()*2+1);
    message.text.readAll(buf);
	  m_List.SetItem(RateableOptions::numOfOptions+2,
			             message.getPlayerNumber()+1,
									 LVIF_TEXT,
									 buf,
									 0,0,0,0);
    delete[](buf);
    return true;
	}
	if (message.getMessageID() == idTimeWeights)
	{
    char* buf = (char*)malloc(message.getMessageSize()*2+1);
    message.text.readAll(buf);
    m_List.SetItem(RateableOptions::numOfOptions+4,
			             message.getPlayerNumber()+1,
									 LVIF_TEXT,
									 buf,
									 0,0,0,0);
    delete[](buf);
    return true;
	}
  else return false;
}



void COptionRatingDlgBar::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptionRatingDlgBar)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	DDX_Control(pDX, IDC_OPTIONRATING_LIST, m_List);
	DDX_Control(pDX, IDC_OPTIONRATINGT_VISCHECK, m_VisCheck);
	//}}AFX_DATA_MAP
}

BOOL COptionRatingDlgBar::OnInitDialog() 
{
	CDynamicBarDlg::OnInitDialog();

	AddSzControl(m_VisCheck,mdNone,mdNone);
	AddSzControl(m_List,mdResize,mdResize);
  
	m_List.InsertColumn(0,"Option");
	m_List.SetColumnWidth(0,150);

  int j;
  char tmpstr[20];
  for (j = 1; j <= Player::numOfPlayerNumbers; ++j) {
    sprintf(tmpstr,"Dog %i",j);
	  m_List.InsertColumn(j,tmpstr);
    m_List.SetColumnWidth(j,50);
  
  }

  for (int i = 0; i < RateableOptions::numOfOptions; ++i){
		m_List.InsertItem(i,RateableOptions::getOptionName((RateableOptions::OptionID)i));
    for (j = 1; j <= Player::numOfPlayerNumbers; ++j) 
		  m_List.SetItem(i,j,LVIF_TEXT,":0",0,0,0,0);
	}
	int k = RateableOptions::numOfOptions;
	m_List.InsertItem(k++,"---");
	m_List.InsertItem(k,"choosen Option");
  for (j = 1; j <= Player::numOfPlayerNumbers; ++j) 
		m_List.SetItem(k,j,LVIF_TEXT,"x",0,0,0,0);
  
	m_List.InsertItem(++k,"choosen Tactic Entry");
  for (j = 1; j <= Player::numOfPlayerNumbers; ++j) 
		m_List.SetItem(k,j,LVIF_TEXT,"x",0,0,0,0);

	m_List.InsertItem(++k,"---");
	m_List.InsertItem(++k,"timeWeights");
  for (j = 1; j <= Player::numOfPlayerNumbers; ++j) 
		m_List.SetItem(k,j,LVIF_TEXT,"x",0,0,0,0);

  return TRUE;
}



BEGIN_MESSAGE_MAP(COptionRatingDlgBar, CDynamicBarDlg)
	//{{AFX_MSG_MAP(COptionRatingDlgBar)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptionRatingDlgBar message handlers


/*
 *
 * Changelog
 *
 * $Log: OptionRatingDlgBar.cpp,v $
 * Revision 1.10  2004/06/07 22:43:27  kerdels
 * added a dtt-switch for open-challenge,
 * merged a bugfix for optionratingdlgbar from local-cvs to tamara,
 * created tactic-entries for openchallenge
 *
 * Revision 1.9  2004/04/08 15:33:08  wachter
 * GT04 checkin of Microsoft-Hellounds
 *
 * Revision 1.9  2004/03/21 04:36:06  pg_joke
 * added slidingAverage to OptionRatings,
 * added ratingBoost (Hysteresis) to OptionRatings
 *
 * Revision 1.8  2004/01/28 21:54:11  kerdels
 * fixed aging...
 *
 * Revision 1.7  2004/01/28 08:26:36  dueffert
 * include bugs fixed
 *
 * Revision 1.6  2004/01/06 00:01:57  kerdels
 * Aging im TacticChooser hinzugefgt,
 * OptionRatingDlgBar um choosenTacticEntry erweitert
 *
 * Revision 1.5  2004/01/04 01:00:46  kerdels
 * TacticDesigner hinzugefgt
 *
 * Revision 1.4  2004/01/01 00:03:25  kerdels
 * tacticEntryArray Streaming berarbeitet
 *
 * Revision 1.3  2003/12/29 10:41:09  wachter
 * - Fixed absolute Path  (i don't have T:)
 * - Added Changelog
 * 
 *
 */
