/**
* @file PerceptsCounterDlgBar.cpp
* Implementation of class CPerceptsCounterDlgBar.
* @author Jessica Marrufo & Holger Dick
*/

#include <stdafx.h>
#include "PerceptsCounterDlgBar.h"
//#include ".\perceptscounterdlgbar.h"

#include "RobotControlQueues.h"
#include "RobotControlDebugKeyTables.h"
#include "Tools/Debugging/Debugging.h"
#include "MessageViewerDlgBar.h"
#include "Representations/Perception/CameraMatrix.h"
#include "Representations/Perception/CameraInfo.h"
#include "Representations/Perception/BallPercept.h"
#include "Representations/Perception/LandmarksPercept.h"
#include "Representations/Perception/LinesPercept.h"
#include "Representations/Perception/PlayersPercept.h"
#include "Representations/Perception/ObstaclesPercept.h"
#include "Representations/Perception/PSDPercept.h"
#include "Representations/Perception/CollisionPercept.h"
//#include "MessageIDs.h"

bool CPerceptsCounterDlgBar::handleMessage(InMessage& message)
{
    if (message.getMessageID() == idPercepts)
    {
        CameraMatrix matrix;
        CameraInfo info;
        BallPercept ball;
        LandmarksPercept landmark;
        LinesPercept lines;
        PlayersPercept player;
        ObstaclesPercept obstacles;
        PSDPercept psd;
        CollisionPercept collision;
        //RECEIVE_PERCEPTS(matrix, info, ball, landmark, lines, player, obstacles, psd, collision);

        message.bin >> RECEIVE_PERCEPTS(matrix, info, ball, landmark, lines, player, obstacles, psd, collision);

        if (waitForPercepts || (readNtimes>0))
        {
            CString input;
            m_perceptView.GetWindowText(input);

            sprintf(input.GetBuffer(input.GetLength()+200)+input.GetLength(),
                "%d\t%d\t%d\t%d\t%d\t%d\t%d\r\n",
                ball.ballWasSeen,
                landmark.numberOfFlags,
                landmark.numberOfGoals,
                lines.numberOfLineTypes,
                player.numberOfBluePlayers,
                player.numberOfRedPlayers,
                ball.frameNumber);

            /* if (ball.frameNumber == landmark.frameNumber == lines.frameNumber == player.frameNumber)
            {*/
            //input = "gleicher frame!";

            m_perceptView.SetWindowText(input);

            readNtimes--;
            //waitForSensorData = false;
            //}
            //todo: frameNumberCheck, RobotCobtrol Einbindung, schoene ausgabeform
        }
        return true;
    }
    return false;
}


CPerceptsCounterDlgBar::CPerceptsCounterDlgBar()
: CRobotControlDialogBar(IDD)
{
    //{{AFX_DATA_INIT(CPerceptsCounterDlgBar)
    //}}AFX_DATA_INIT
    waitForPercepts = false;
    readNtimes = 0;
}

void CPerceptsCounterDlgBar::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CPerceptsCounterDlgBar)

    DDX_Control(pDX, IDC_PERCEPTSCOUNTER_FRAMECOUNTER, m_frameCounter);
    DDX_Control(pDX, IDC_PERCEPTSCOUNTER_PERCEPTVIEW, m_perceptView);
    DDX_Control(pDX, IDC_PERCEPTSCOUNTER_READ, m_readLines);
    DDX_Control(pDX, IDC_PERCEPTSCOUNTER_STARTREAD, m_startReading);
    DDX_Control(pDX, IDC_PERCEPTSCOUNTER_STOPREAD, m_stopReading);
    DDX_Control(pDX, IDC_PERCEPTSCOUNTER_SAVE, m_save);

    //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPerceptsCounterDlgBar, CDynamicBarDlg)
    //{{AFX_MSG_MAP(CPerceptsCounterDlgBar)
    ON_BN_CLICKED(IDC_PERCEPTSCOUNTER_READ, OnReadButton)
    ON_BN_CLICKED(IDC_PERCEPTSCOUNTER_STARTREAD, OnStartButton)
    ON_BN_CLICKED(IDC_PERCEPTSCOUNTER_STOPREAD, OnStopButton)
    ON_BN_CLICKED(IDC_PERCEPTSCOUNTER_SAVE, OnSaveButton)

    //}}AFX_MSG_MAP
    //    ON_EN_CHANGE(IDC_PERCEPTSCOUNTER_FRAMECOUNTER, OnEnChangeFrameCounter)
    //    ON_EN_CHANGE(IDC_PERCEPTSCOUNTER_PERCEPTVIEW, OnEnChangePerceptview)

END_MESSAGE_MAP()

BOOL CPerceptsCounterDlgBar::OnInitDialog() 
{
    CDynamicBarDlg::OnInitDialog();

    AddSzControl(m_perceptView,mdResize,mdResize);
    AddSzControl(m_frameCounter,mdRepos,mdRepos);
    AddSzControl(m_readLines,mdRepos,mdRepos);
    AddSzControl(m_startReading,mdRepos,mdRepos);
    AddSzControl(m_stopReading,mdRepos,mdRepos);
    AddSzControl(m_save, mdRepos, mdRepos);

    return TRUE;

}


void CPerceptsCounterDlgBar::OnReadButton()
{
    CString numberString;
    int number;
    m_frameCounter.GetWindowText(numberString);
    number = atoi(numberString.GetBuffer(numberString.GetLength()));
    getDebugKeyTables().forPhysicalRobots.set(DebugKeyTable::sendPercepts, DebugKey::n_times, number);
    getDebugKeyTables().sendForPhysicalRobots();
    readNtimes = number;
    //waitForPercepts = true;
}

void CPerceptsCounterDlgBar::OnStartButton()
{
    getDebugKeyTables().forPhysicalRobots.set(DebugKeyTable::sendPercepts, DebugKey::always);
    getDebugKeyTables().sendForPhysicalRobots();

    waitForPercepts = true;
}

void CPerceptsCounterDlgBar::OnStopButton()
{
    getDebugKeyTables().forPhysicalRobots.set(DebugKeyTable::sendPercepts, DebugKey::disabled);
    getDebugKeyTables().sendForPhysicalRobots();

    CString input;
    m_perceptView.GetWindowText(input);

    sprintf(input.GetBuffer(input.GetLength()+200)+input.GetLength(),
        "%s\t%s\t%d\t%s\t%d\r\n",
        "StopTest",
        "waitForPercepts:",
        waitForPercepts,
        "readNtimes:",
        readNtimes);

    m_perceptView.SetWindowText(input);

    waitForPercepts = false;
    readNtimes = 0;
    // TODO: Fgen Sie hier Ihren Kontrollbehandlungscode fr die Benachrichtigung ein.
}

void CPerceptsCounterDlgBar::OnSaveButton() 
{
    CString defaultPath = File::getGTDir();
    defaultPath += "/Config/Logs/";
    defaultPath.Replace('/','\\');
    CString pathName = 
        AfxGetApp()->GetProfileString("PerceptsCounterDlg", "savePath", defaultPath);
    pathName += "*.txt";

    CFileDialog fileDialog(false, ".txt",pathName,
        OFN_HIDEREADONLY | OFN_EXPLORER | OFN_ENABLESIZING | OFN_NOCHANGEDIR | OFN_NONETWORKBUTTON
        , "text file (*.txt)|*.txt|comma seperated value (*.csv)|*.csv||", this);

    if (fileDialog.DoModal()==IDOK)
    {
        CString fileName = fileDialog.GetFileName();
        CString pathAndFileName = fileDialog.GetPathName();
        CString pathName = 
            pathAndFileName.Left(
            pathAndFileName.GetLength() -
            fileName.GetLength()
            );
        AfxGetApp()->WriteProfileString("PerceptsCounterDlg", "savePath", pathName);

        OutTextRawFile fout(pathAndFileName);
        if (fout.exists())
        {
            if ( fileDialog.GetFileExt() == "txt" )
            {   
                CString input;
                m_perceptView.GetWindowText(input);
                fout <<  input;
            }
            else if ( fileDialog.GetFileExt() == "csv" )
            {
                CString input;
                m_perceptView.GetWindowText(input);
                input.Replace("\t", ",");
                //input.Replace("\n", "");
                input.Replace("\r", "");
                //input.Remove("\n");
                fout <<  input;
            }
            else
            {
                CString message;
                message.Format( "Unknown file-extension %s.", fileDialog.GetFileExt());
                AfxMessageBox( message, MB_OK);
            }
        }
        else
        {
            CString message;
            message.Format( "File %s not found.", pathAndFileName);
            AfxMessageBox( message, MB_OK);
        }
    }
}
