/**
* @file TacticDesignerDlgBar.h
*
* Declaration of class CTacticDesignerDlgBar
*
* @author Jochen Kerdels
*/

#ifndef __TacticDesignerDlgBar_h_
#define __TacticDesignerDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"
#include "Tools/DynamicTeamTactic/TacticEntry.h"


/**
* @class CTacticDesignerDlgBar 
* 
* A dialog bar to create and modify TacticEntries for DTT-Behavior
*
* @author Jochen Kerdels
*/
class CTacticDesignerDlgBar : public CRobotControlDialogBar
{
private:
  HTREEITEM root;
  int TECount;

  void fillTacticEntry(TacticEntryArray& tacticEntryArray);
public:
  /** Default constructor.*/
  CTacticDesignerDlgBar();

  /** Destructor */
  ~CTacticDesignerDlgBar();

  //{{AFX_DATA(CTacticDesignerDlgBar)
  enum { IDD = IDD_DIALOG_BAR_TACTICDESIGNER };
	CButton   m_new;
	CButton   m_open;
	CButton   m_save;
	CButton   m_send;
	CButton   m_merge;
	CButton   m_freeze;
	CButton   m_unfreeze;
	CButton   m_add;
	CButton   m_del;
	CTreeCtrl m_Tree;
  CListBox  m_List;
  //}}AFX_DATA

  //{{AFX_VIRTUAL(CTacticDesignerDlgBar)
  protected:
    virtual void DoDataExchange(CDataExchange* pDX);    
    virtual BOOL OnInitDialog();
  //}}AFX_VIRTUAL
  
protected:

  void AddFromFile(bool append);

  void AddTacticEntry(HTREEITEM insertAfter);

  //{{AFX_MSG(CTacticDesignerDlgBar)
  afx_msg void onSelChanged( NMHDR * pNotifyStruct, LRESULT * result );
  afx_msg void onItemTextEdited( NMHDR * pNotifyStruct, LRESULT * result );
  afx_msg void onListSelChanged();
	afx_msg void OnAddButton();
	afx_msg void OnDelButton();
	afx_msg void OnNewButton();
	afx_msg void OnOpenButton();
	afx_msg void OnSaveButton();
	afx_msg void OnMergeButton();
	afx_msg void OnSendButton();
	afx_msg void OnFreezeButton();
	afx_msg void OnUnfreezeButton();
  //}}AFX_MSG
  
  DECLARE_MESSAGE_MAP();
};

//{{AFX_INSERT_LOCATION}}

#endif //__TacticDesignerDlgBar_h_

/*
 * Change log :
 * 
 * $Log: TacticDesignerDlgBar.h,v $
 * Revision 1.6  2004/02/19 18:11:13  kerdels
 * made a backup of default.dtt in tbaseV3.dtt,
 * added insert functionality to TacticDesigner.
 *
 * Revision 1.5  2004/02/09 13:23:46  kerdels
 * added merge-button
 *
 * Revision 1.4  2004/01/19 20:13:08  kerdels
 * added name capability to tacticentrys
 *
 * Revision 1.3  2004/01/12 17:17:52  kerdels
 * added freeze functionality to tacticDesigner
 *
 * Revision 1.2  2004/01/07 14:56:09  kerdels
 * added send functionality to TacticDesigner
 *
 * Revision 1.1  2004/01/04 00:08:56  kerdels
 * TacticDesigner hinzugefgt
 *
*/