/**
* @file UDParameterSetDlgBar.h
* Declaration of class CUDParameterSetDlgBar.
* @author Uwe Dffert 
*/

#ifndef __UDParameterSetDlgBar_h_
#define __UDParameterSetDlgBar_h_

#include "StdAfx.h"
#include "RobotControlDialogBar.h"
#include "Modules/WalkingEngine/UDParameterSet.h"

/** 
* @class UDParameterSetDlgBar
* A dialog bar for working with UDParameterSets
* @author Uwe Dffert
*/
class CUDParameterSetDlgBar : public CRobotControlDialogBar
{
public:
  CUDParameterSetDlgBar();
  bool handleMessage(InMessage& message);

  int currentParametersNumber;
  UDParameters* currentParam;
  UDParameters extraParam;
  double speed;
  double ratio;
  double direction;

  //{{AFX_DATA(CUDParameterSetDlgBar)
	enum { IDD = IDD_DIALOG_BAR_UDPARAMETERSET };
	CStatic	m_correctLabel;
  CStatic m_rotLabel;

	CComboBox	m_FootMode;
	CComboBox	m_ChooseSet;
  CButton m_autoCheck;
  UDParametersSet paramSet;
	//}}AFX_DATA


  //{{AFX_VIRTUAL(CUDParameterSetDlgBar)
protected:
  virtual void DoDataExchange(CDataExchange* pDX);  
  virtual BOOL OnInitDialog();
  //}}AFX_VIRTUAL
  void copyToClipboard();
  void pasteFromClipboard();

  //{{AFX_MSG(CUDParameterSetDlgBar)
	afx_msg void OnSend();
	afx_msg void OnLoad();
	afx_msg void OnSave();
	afx_msg void OnMirror();
	afx_msg void OnMeasure();
	afx_msg void OnChangeSpeed();
	afx_msg void OnChangeRatio();
	afx_msg void OnChangeDirection();
  afx_msg void OnChangeRequest();
	afx_msg void OnSelchangeChooseSet();
  afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	//}}AFX_MSG
  DECLARE_MESSAGE_MAP();
};

#endif // __UDParameterSetDlgBar_h_

/*
* Change log :
* 
* $Log: UDParameterSetDlgBar.h,v $
* Revision 1.10  2004/06/16 13:32:48  dueffert
* mirroring added
*
* Revision 1.9  2004/05/20 17:21:28  dueffert
* UDParametersDialog improved
*
* Revision 1.8  2004/04/01 12:12:18  dueffert
* update bug and copy'n'paste bug fixed
*
* Revision 1.7  2004/03/29 15:33:49  dueffert
* speed change added
*
* Revision 1.6  2004/03/27 08:46:36  dueffert
* copy'n'paste support via context menu added
*
* Revision 1.5  2004/03/16 10:30:43  dueffert
* UI update and output improved
*
* Revision 1.4  2004/03/03 08:29:35  dueffert
* two UDEvolutionRequests added
*
* Revision 1.3  2004/02/27 16:40:56  dueffert
* UDEvolutionRequest introduced
*
* Revision 1.2  2003/12/09 14:20:03  dueffert
* numerous UD improvements
*
* Revision 1.1  2003/12/02 18:07:52  dueffert
* first working not yet calibrated version of UDWalkingEngine added
*
*
*/
