/**
* @file GenericModalBinary.cpp
* 
* Implementation of a generic dialog for confirmation of actions.
*/

#include "StdAfx.h"
#include "GenericModalBinary.h"


#ifndef __CGenericModalBinary_cpp
#define __CGenericModalBinary_cpp


CGenericModalBinary::CGenericModalBinary(CString buttonTrue, CString buttonFalse, CString descriptiveText, CWnd* pParent /*=NULL*/)
	: CDialog(CGenericModalBinary::IDD, pParent)
{
  description = descriptiveText;
  textFalse = buttonFalse;
  textTrue = buttonTrue;

	//{{AFX_DATA_INIT(GenericModalBinary)
	//}}AFX_DATA_INIT
}


void CGenericModalBinary::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGenericModalBinary)
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGenericModalBinary, CDialog)
	//{{AFX_MSG_MAP(CGenericModalBinary)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CGenericModalBinary::OnInitDialog()
{
  CStatic *t;	
  CButton *btn1, *btn2;

	btn1 = (CButton*) GetDlgItem(IDOK);
  btn1->SetWindowText(textTrue);
	btn2 = (CButton*) GetDlgItem(IDCANCEL);
  btn2->SetWindowText(textFalse);
  t = (CStatic*) GetDlgItem(IDC_STATIC_MODAL_BINARY_TEXT);
  t->SetWindowText(description);
  t->ShowWindow(SW_SHOW);

  return false;
}

#endif //__CGenericModalBinary_cpp

/*
 * Change log :
 * 
 * $Log: GenericModalBinary.cpp,v $
 * Revision 1.2  2004/02/24 19:43:20  dueffert
 * include bug fixed
 *
 * Revision 1.1  2004/02/23 13:27:25  jhoffman
 * - changes to Main-menu are shown ... this currently results in one additional menu (!) somebody please fix this!
 * - added GenericModalBinary-dialog: can be used to create a modal dialog where you can specify the button labels and the descriptive text (like APX...ModalDialog but you can specify what is written on the buttons)
 * - CameraToolBar: mode, shutter, gain extracted from dropdown
 * - ToolBarEx: added AddString method to write const. strings on a toolbar
 *
 *
 */
