/**
 * @file WLANConfigurationDialog.h
 * 
 * Declaration of WLAN configuration dialog in the RobotControl project.
 *
 * @author Max Risler, Uwe Dffert, Thomas Kindler
 */

#ifndef __WLANConfigurationDialog_h_ 
#define __WLANConfigurationDialog_h_ 

#include "StdAfx.h"
#include "resource.h"

#include "RobotControlPhysicalRobots.h"

/**
 * @class CWLANConfigurationDialog
 * 
 * Provides the possibility to enter new and change existing WLAN configurations.
 */
class CWLANConfigurationDialog : public CDialog
{
public:
  CWLANConfigurationDialog(CWnd* pParent = NULL);
  void setWLANConfiguration(CRobotControlWLANConfiguration* externConfig);
  
  //{{AFX_DATA(CWLANConfigurationDialog)
  enum { IDD = IDD_DIALOG_WLAN_CONFIGURATION };
  CButton m_updateCheck;
  CButton m_removeCheck;
  CButton m_ejectCheck;
  CButton m_unsafeCheck;
  CButton m_telnetCheck;
  CString m_nameEdit;
  CIPAddressCtrl  m_ipRed1;
  CIPAddressCtrl  m_ipRed2;
  CIPAddressCtrl  m_ipRed3;
  CIPAddressCtrl  m_ipRed4;
  BOOL  m_useRed1;
  BOOL  m_useRed2;
  BOOL  m_useRed3;
  BOOL  m_useRed4;
  CString m_essidRedEdit;
  CIPAddressCtrl  m_netmaskRed;
  CComboBox m_apmodeRedEdit;
  CComboBox m_channelRedEdit;
  CString m_wepkeyRedEdit;
  CIPAddressCtrl  m_ipBlue1;
  CIPAddressCtrl  m_ipBlue2;
  CIPAddressCtrl  m_ipBlue3;
  CIPAddressCtrl  m_ipBlue4;
  BOOL  m_useBlue1;
  BOOL  m_useBlue2;
  BOOL  m_useBlue3;
  BOOL  m_useBlue4;
  CString m_essidBlueEdit;
  CIPAddressCtrl  m_netmaskBlue;
  CComboBox m_apmodeBlueEdit;
  CComboBox m_channelBlueEdit;
  CString m_wepkeyBlueEdit;
  CButton m_isERS7;
  CButton m_isERS210;
  CComboBox m_whichToCopyTo;
  CString m_teamBlueEdit;
  CString m_teamRedEdit;
  CButton m_copyFiles;
  CStatic m_selectionIndicator[8];
  //}}AFX_DATA
  
  
  //{{AFX_VIRTUAL(CWLANConfigurationDialog)
protected:
  virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Untersttzung
  //}}AFX_VIRTUAL
  
protected:
  CRobotControlWLANConfiguration* config;
  void    OnCopy(bool red,int number,unsigned long ip);
  void    OnUpdate();
  CString IPToStr(unsigned long ip);

  //{{AFX_MSG(CWLANConfigurationDialog)
  virtual BOOL OnInitDialog();
  afx_msg void OnOneButtonCopy();
  afx_msg void OnChangeCopyTarget();
  virtual void OnOK();
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP();
private:
};

//{{AFX_INSERT_LOCATION}}

#endif // __WLANConfigurationDialog_h_

/*
* Change log :
* 
* $Log: WLANConfigurationDialog.h,v $
* Revision 1.15  2004/04/08 15:33:08  wachter
* GT04 checkin of Microsoft-Hellounds
*
* Revision 1.15  2004/03/29 17:02:57  pg_thki
* - --unsafe, --ers7 and --rm buttons are disabled when update is checked.
*
* Revision 1.14  2004/03/24 00:06:03  pg_thki
* - added unsafe and telnet options
*
* Revision 1.13  2004/03/16 14:54:51  dueffert
* copyfiles options usable in dialog now
*
* Revision 1.12  2004/02/28 17:34:46  dueffert
* useless includes removed
*
* Revision 1.11  2004/02/03 13:07:18  spranger
* commented include AfxWin.h out to make DSP_Generation work
*
* Revision 1.10  2004/02/02 15:15:53  jhoffman
* UI improvements, user feedback integrated
*
* Revision 1.9  2004/01/29 23:42:32  kindler
* Fixed ERS7/210 radio buttons (using the official button-group way)
*
* Revision 1.7  2004/01/29 17:06:20  dueffert
* inclusion bug fixed
*
* Revision 1.6  2004/01/29 12:03:24  jhoffman
* UI changes:
* - Main menu entries renamed, reordered, added some new icons
* - delete-confirmation in settings and WLAN dialog
* - settings dialog uses icons, radio buttons added
* - WLAN dialog restructured
* - motion tester and head motion tested layout improved, stop button added
* - check boxes replaced by radio buttons where appropriate
*
* Revision 1.5  2004/01/27 23:20:23  wachter
* Added  teamIdentifier to WLANConfigurationDialog
*
* Revision 1.4  2004/01/14 14:43:29  juengel
* state of ers7-chek is stored in registry now
*
* Revision 1.3  2004/01/12 11:30:52  juengel
* Added checkBox "ERS7" to WLANConfigurationDialog.
*
* Revision 1.2  2004/01/03 19:16:29  wachter
* - Debug-communication without router working now
* - Router-IP not longer needed
*
* Revision 1.1  2003/12/14 14:24:34  loetzsch
* renamed WLANNewDialog to WLANConfigurationDialog
*
* Revision 1.2  2003/12/13 11:32:06  loetzsch
* renamed WLANConfiguration to CRobotControlWLANConfiguration
* and moved to RobotControlPhysicalRobots.h
*
* Revision 1.1  2003/10/07 10:09:39  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:26  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.6  2003/06/23 12:05:41  dueffert
* copy does WYSIWYG now, initialization added
*
* Revision 1.5  2003/05/11 23:39:24  dueffert
* Depend now works with RobotControl too
*
* Revision 1.4  2003/03/13 16:39:47  dueffert
* wlan toolbar can handle teams now
*
* Revision 1.3  2002/11/25 12:22:49  dueffert
* doxygen comments added
*
* Revision 1.2  2002/09/22 13:46:09  dueffert
* direct wlan removed (still in code as comments)
*
* Revision 1.1  2002/09/10 15:49:06  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
*
* Revision 1.6  2002/08/30 17:15:39  dueffert
* doxygen parser bugs fixed, docu added
*
* Revision 1.5  2002/08/29 13:56:27  dueffert
* includes in correct case, system includes in <>
*
* Revision 1.4  2002/06/20 23:38:48  dueffert
* player toolbar & wlan toolbar completed
*
* Revision 1.3  2002/06/10 12:00:41  dueffert
* commentation bugs fixed
*
* Revision 1.2  2002/06/08 13:48:17  dueffert
* further wlan config functionality added
*
* Revision 1.1.1.1  2002/05/10 12:40:22  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.5  2002/02/21 15:58:26  dueffert
* direct wlan works! at the moment you can only send 3 pakets (<32K each) and receive any number of pakets (<32K each)
*
* Revision 1.4  2002/02/21 10:37:32  risler
* removed strange bug with m_useRouter
*
* Revision 1.3  2002/02/20 16:08:12  dueffert
* direct wlan connection added, not fully functional yet
*
* Revision 1.2  2002/02/05 03:44:59  loetzsch
* #include "StdAfx.h" eingebaut, damit die Datei nicht so oft kompiliert wird
*
* Revision 1.1  2002/01/24 22:57:22  risler
* finished WLAN Toolbar
*
*
*/
