/**
* @file DynamicBar.h
* 
* Definition of class CDynamicBar, class CDynamicBarDlg and template CDynamicBarT.
*
* Version 2.43
*
* Created: Jan 24, 1998        Last Modified: August 03, 2000
*
* See the official site at www.datamekanix.com for documentation and
* the latest news.
*
* Copyright (C) 1998-2000 by Cristi Posea. All rights reserved.
*
* This code is free for personal and commercial use, providing this 
* notice remains intact in the source files and all eventual changes are
* clearly marked with comments.
*
* You must obtain the author's consent before you can include this code
* in a software library.
*
* No warrantee of any kind, express or implied, is included with this
* software; use at your own risk, responsibility for damages (if any) to
* anyone resulting from the use of this software rests entirely with the
* user.
*
* Send bug reports, bug fixes, enhancements, requests, flames, etc. to
* cristi@datamekanix.com or post them at the message board at the site.
*
* Resizable dialog bars.
*
* The entire bar stuff is handled using
*   CSizingControlBar by Cristi Posea <cristip@datamekanix.com>
*   http://www.datamekanix.com
*
* Usage: 
* ==================
* To use it, the following steps must be performed:
*
* a) Create a new dialog say
*       CMyBarDlg
*
* b) Change its base class from CDialog to CDynamicBarDlg.
*
* c) In your mainframe, add a member variable
*       CDynamicDlgBarT<MyBarDialog> m_wndMyBar;
*
* e) Add the following code to your CMainFrame::OnCreate()
*
*    if (!m_wndMyBar.Create(_T("My Bar"), this, CSize(200, 100),
*         TRUE, AFX_IDW_CONTROLBAR_FIRST + 32))
*    { 
*			 TRACE0("Failed to create mybar\n");
*			 return -1;      // fail to create
*    }
*
*		m_wndMyBar.SetBarStyle(m_wndMyBar.GetBarStyle() |
*			 CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
*
*		m_wndMyBar.EnableDocking(CBRS_ALIGN_ANY);
*		EnableDocking(CBRS_ALIGN_ANY);              // <---- needed only once for the frame
*		DockControlBar(&m_wndMyBar, AFX_IDW_DOCKBAR_LEFT);
*
* f) Refer to URL stated above to learn more about the features of the
*    CSizingControlBar class.
*/

#ifndef __DynamicBar_h_
#define __DynamicBar_h_

#include "StdAfx.h"

//#include "SizingControlBar.h"
//#include "SizingControlBarG.h"
#include "SizingControlBarCF.h"

#include "DynamicDialog.h"


/**
* @class CDynamicBarDlg
*
* The child dialog for dialog bars.
*/
class CDynamicBarDlg : public CDynamicChildDlg
{
  DECLARE_DYNAMIC(CDynamicBarDlg);
  
  friend class CDynamicBar;
  
public:
  const UINT	m_nID;
  
public:
  CDynamicBarDlg(UINT idd, CWnd *pParent = NULL) : m_nID(idd), CDynamicChildDlg(idd,pParent) { }
  virtual ~CDynamicBarDlg() {}
  
	/**
	* Create() without parameters :)
	*/
	virtual bool Create(CDynamicBar *pBar);

protected:
	/**
	* this handler might be used to update things
	*/
	virtual void OnUpdateCmdUI(CFrameWnd* pTarget, BOOL bDisableIfNoHndler) { UpdateDialogControls(pTarget,bDisableIfNoHndler); }

protected:
	/**
	* this catches OnOK, OnCancel and OnClose
	* to protect the dialog from being closed accidentially
	*/
	virtual void OnOK() {}
	virtual void OnCancel() {}
	afx_msg void OnClose() { OnCancel(); }

	DECLARE_MESSAGE_MAP();
};

/**
* @class CDynamicBar
*
* The dialog bar.
*/
class CDynamicBar : public CSizingControlBarCF
{
	DECLARE_DYNAMIC(CDynamicBar);

private:
	CDynamicBarDlg&	m_rDlg;

public:
	CDynamicBar(CDynamicBarDlg & rDlg) : m_rDlg(rDlg) {}
	virtual ~CDynamicBar() {}

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDynamicBar)
	public:
	virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo);
	protected:
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
protected:
    virtual void OnUpdateCmdUI(CFrameWnd* pTarget, BOOL bDisableIfNoHndler);

	// Generated message map functions
protected:
	//{{AFX_MSG(CDynamicBar)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP();
};

/**
* CDynamicBarT
*
* A nice template class to instanciate bars with dialogs
*/
template<class DLG>
class CDynamicBarT : public CDynamicBar
{
public:
	DLG		m_wndDlg;

public:
	CDynamicBarT() : m_wndDlg(), CDynamicBar(m_wndDlg) {}
	virtual ~CDynamicBarT() {  m_wndDlg.DestroyWindow(); CDynamicBar::DestroyWindow(); }
};


//{{AFX_INSERT_LOCATION}}

#endif //__DynamicBar_h_

/*
 * Change log :
 * 
 * $Log: DynamicBar.h,v $
 * Revision 1.1  2003/10/07 10:10:07  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:26  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2003/05/11 23:29:27  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.1  2002/09/10 15:49:09  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.1  2002/09/01 17:19:19  loetzsch
 * tidied up the MfcTools/ directory. Created directories
 * MfcTools/DockingControlBars and MfcTools/IEStyleToolbars.
 *
 * Revision 1.2  2002/08/30 17:17:19  dueffert
 * doxygen parser bugs fixed, docu added
 *
 * Revision 1.1.1.1  2002/05/10 12:40:25  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.2  2001/12/10 17:47:09  risler
 * change log added
 *
 */
