/**
* @file DynamicDialog.h
* 
* Declaration of class CDynamicDialog and class CDynamicChildDialog
*
* Version 2.43
*
* Created: Jan 24, 1998        Last Modified: August 03, 2000
*
* See the official site at www.datamekanix.com for documentation and
* the latest news.
*
* Copyright (C) 1998-2000 by Cristi Posea. All rights reserved.
*
* This code is free for personal and commercial use, providing this 
* notice remains intact in the source files and all eventual changes are
* clearly marked with comments.
*
* You must obtain the author's consent before you can include this code
* in a software library.
*
* No warrantee of any kind, express or implied, is included with this
* software; use at your own risk, responsibility for damages (if any) to
* anyone resulting from the use of this software rests entirely with the
* user.
*
* Send bug reports, bug fixes, enhancements, requests, flames, etc. to
* cristi@datamekanix.com or post them at the message board at the site.

*/ 
#ifndef __DynamicDialog_h_
#define __DynamicDialog_h_

#include "DynamicWndEx.h"

/**
* @class CDynamicDialog
*
* A new resizable dialog.
*
* This should be the base-class for your normal dialogs.
* This class supports:
* - A sizing icon
* - AutoPositioning (stores last position automatically and stuff)
* - Anti-Flickering system.
* - And of course, it provides
*   the Dynamic child control system DcCS by codex design
*/
class CDynamicDialog : public CDialog, public CDynamicWndEx
{
  DECLARE_DYNAMIC(CDynamicDialog);
  
public:
  enum { flDefault = flAntiFlicker|flSizeIcon };
  
public:
  CDynamicDialog(UINT idd = 0, CWnd* pParent = NULL, Freedom fd = fdAll, UINT nFlags = flDefault);
  CDynamicDialog(LPCTSTR lpszTemplateName, CWnd* pParent = NULL, Freedom fd = fdAll, UINT nFlags = flDefault);
  virtual ~CDynamicDialog() { DoOnDestroy(); }
  
public:
  virtual BOOL DestroyWindow();
  
protected:
  virtual BOOL OnInitDialog();
  afx_msg void OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI);
  afx_msg void OnDestroy();
  afx_msg void OnParentNotify(UINT message, LPARAM lParam);
  afx_msg void OnSize(UINT nType, int cx, int cy);
  afx_msg void OnSizing(UINT fwSide, LPRECT pRect);
  afx_msg void OnTimer(UINT nIDEvent);
  
  DECLARE_MESSAGE_MAP();
};

/**
* @class CDynamicChildDlg
*
* Use this dialog class instead of CDynamicDialog if
* you create dialogs which you want to embedd as child
* controls.
* In that case, this dialog is far more straight forward.
* This class provides:
* - NO sizing icon
* - NO auto anti-flickering (since the dialog itself won't be moved by hand)
* - NO auto-positioning
* - But of course, it provides
*   the Dynamic child control system DcCS by codex design
*/
class CDynamicChildDlg : public CDynamicDialog
{
  DECLARE_DYNAMIC(CDynamicChildDlg);
  
public:
  enum { flDefault = flAntiFlicker };
  
public:
  CDynamicChildDlg(UINT idd = 0, CWnd* pParent = NULL, Freedom fd = fdAll, UINT nFlags = flDefault);
  CDynamicChildDlg(LPCTSTR lpszTemplateName, CWnd* pParent = NULL, Freedom fd = fdAll, UINT nFlags = flDefault);
  virtual ~CDynamicChildDlg() { DoOnDestroy(); }
};

/////////////////////////////////////////////////////////////////////////////
// CDynamicDialog Inlines
/////////////////////////////////////////////////////////////////////////////

inline CDynamicDialog::CDynamicDialog(UINT idd, CWnd* pParent, Freedom fd, UINT nFlags)
:	CDialog(idd,pParent),
CDynamicWndEx(fd,nFlags)
{
  if(idd)
    ActivateAutoPos(idd);
}

inline CDynamicDialog::CDynamicDialog(LPCTSTR lpszTemplateName, CWnd* pParent, Freedom fd, UINT nFlags)
:	CDialog(lpszTemplateName,pParent),
CDynamicWndEx(fd,nFlags)
{
  if(lpszTemplateName && *lpszTemplateName)
    ActivateAutoPos(lpszTemplateName);
}

/////////////////////////////////////////////////////////////////////////////
// CDynamicChildDlg Inlines
/////////////////////////////////////////////////////////////////////////////

inline CDynamicChildDlg::CDynamicChildDlg(UINT idd, CWnd* pParent, Freedom fd, UINT nFlags)
:	CDynamicDialog(idd,pParent,fd,nFlags)
{
  m_bUseScrollPos	=	true;		// if you create scollbars I will use them ;)
  NoAutoPos();						// not in this case....
}

inline CDynamicChildDlg::CDynamicChildDlg(LPCTSTR lpszTemplateName, CWnd* pParent, Freedom fd, UINT nFlags)
:	CDynamicDialog(lpszTemplateName,pParent,fd,nFlags)
{
  m_bUseScrollPos	=	true;		// if you create scollbars I will use them ;)
  NoAutoPos();						// not in this case....
}

//{{AFX_INSERT_LOCATION}}

#endif // __DynamicDialog_h_
/*
 * Change log :
 * 
 * $Log: DynamicDialog.h,v $
 * Revision 1.1  2003/10/07 10:10:07  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:26  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.2  2003/05/11 23:29:27  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.1  2002/09/10 15:49:09  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.1  2002/09/01 17:19:19  loetzsch
 * tidied up the MfcTools/ directory. Created directories
 * MfcTools/DockingControlBars and MfcTools/IEStyleToolbars.
 *
 * Revision 1.1.1.1  2002/05/10 12:40:25  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.2  2001/12/10 17:47:09  risler
 * change log added
 *
 */
