/**
* @file RobotControlFieldView.cpp
*
* Implementation of class CRobotControlFieldView
*
* @author Martin Ltzsch
*/


#include "StdAfx.h"
#include "RobotControlFieldView.h"
#include "Visualization/DebugDrawingManager/DebugDrawingManagerUI.h"
#include "Visualization/DebugDrawingManager/DebugDrawingManager.h"

#include "RobotControl.h"

IMPLEMENT_DYNCREATE(CRobotControlFieldView, CMDIChildWnd)

BEGIN_MESSAGE_MAP(CRobotControlFieldView, CMDIChildWnd)
	//{{AFX_MSG_MAP(CRobotControlFieldView)
	ON_WM_CREATE()
  ON_WM_PAINT()
	ON_WM_SIZE()
	ON_WM_CONTEXTMENU()
	ON_WM_MOUSEWHEEL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


CRobotControlFieldView::CRobotControlFieldView()
{
}

CRobotControlFieldView::~CRobotControlFieldView()
{
}

BOOL CRobotControlFieldView::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CMDIChildWnd::PreCreateWindow(cs) )
		return FALSE;

  cs.dwExStyle |= WS_EX_CLIENTEDGE;
  cs.style &= ~WS_BORDER;
  cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
    ::LoadCursor(NULL, IDC_ARROW), HBRUSH(COLOR_WINDOW+1), NULL);

	return TRUE;
}

  

void CRobotControlFieldView::OnPaint() 
{
  CPaintDC dc(this); 

  getRobotControlApp().pMainFrame->debugDrawingManager.paint(
    &dc,
    &rectForMetaFilePlay,
    DrawingPapers::mainWindow
    );
}

int CRobotControlFieldView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
  lpCreateStruct->style |= AFX_WS_DEFAULT_VIEW;
	if (CMDIChildWnd::OnCreate(lpCreateStruct) == -1)
    return -1;

  getRobotControlApp().pMainFrame->debugDrawingManager.setCallBackMethod(DrawingPapers::mainWindow, this);

  return 0;
}


void CRobotControlFieldView::OnSize(UINT nType, int cx, int cy) 
{
	CWnd ::OnSize(nType, cx, cy);
	
  rectForMetaFilePlay.left = 20;
  rectForMetaFilePlay.right = cx - 20;
  rectForMetaFilePlay.top = 20;
  rectForMetaFilePlay.bottom = cy - 20;
  
  RedrawWindow(NULL, NULL, RDW_INVALIDATE);
}

void CRobotControlFieldView::OnContextMenu(CWnd* pWnd, CPoint point) 
{
  DebugDrawingManagerUI::showContextMenu(
    DrawingPapers::mainWindow, point, GetParentFrame()
    );	
}

BOOL CRobotControlFieldView::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt) 
{
  if(zDelta == 120)
    getRobotControlApp().pMainFrame->debugDrawingManager.zoomDrawingPaper(DrawingPapers::mainWindow, 1.1);

  if(zDelta == -120)
    getRobotControlApp().pMainFrame->debugDrawingManager.zoomDrawingPaper(DrawingPapers::mainWindow, 1/1.1);

  RedrawWindow(NULL, NULL, RDW_INVALIDATE);
	
	return CMDIChildWnd::OnMouseWheel(nFlags, zDelta, pt);
}


/*
 * Change log :
 * 
 * $Log: RobotControlFieldView.cpp,v $
 * Revision 1.2  2003/12/15 13:05:04  loetzsch
 * RobotControl now displays a splash screen at the beginning
 *
 * Revision 1.1  2003/10/07 10:09:37  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:25  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.7  2003/05/11 23:51:02  dueffert
 * Depend now works with RobotControl too
 *
 * Revision 1.6  2003/03/22 22:37:52  loetzsch
 * finished GUI and message routing for 8 simulated robots
 * almost all functionallity for simulated robots now is encapsulated in class
 *   CRobotControlSimulatedRobots
 *
 * Revision 1.5  2002/10/13 15:51:05  juengel
 * second debug drawing clean up
 *
 * Revision 1.4  2002/10/10 11:46:54  juengel
 * Added OnMouseWheel(...)
 *
 * Revision 1.3  2002/10/02 15:52:53  juengel
 * The status bar shows the type of the current message in the LogPlayer tool bar.
 *
 * Revision 1.2  2002/09/20 23:28:33  juengel
 * Moved instance of DebugDrawingManager to RobotControlMainFrame.
 *
 * Revision 1.1  2002/09/10 15:49:04  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 *
 * Revision 1.3  2002/09/01 17:20:34  loetzsch
 * tidied up the MfcTools/ directory. Created directories
 * MfcTools/DockingControlBars and MfcTools/IEStyleToolbars.
 *
 * Revision 1.2  2002/08/30 21:08:11  dueffert
 * AboutDlg added
 *
 * Revision 1.1  2002/08/07 10:49:42  loetzsch
 * - simplified field view window
 *
 */

