#include "MoviePlayer.h"
#include <winuser.h>


MoviePlayer::MoviePlayer(HWND parent, HINSTANCE instance)
: m_pfile(0)
//, m_pfi(0)
, hAvi(0)
, m_parent(parent)
, m_parentInstance(instance)
{
// strcpy(m_name ,"T:\\Test.avi");//TEST
 m_x = 122;
 m_y = 248;
 m_w = 110;
 m_status=0;  // 0=stopped, 1=paused, 2=running
 //m_h = 10;
// m_stepwide = 40;

}

MoviePlayer::~MoviePlayer()
{
//	delete m_pfile;
	m_pfile = 0;
	MCIWndDestroy(hAvi);
	hAvi = 0;
//	delete m_pfi;
//	m_pfi = 0;
}


void MoviePlayer::setAppearance(int x, int y, int width)
{

	m_x=x;
    m_y=y;
	m_w=width;
	m_h=(m_w*3)/4;
	SetWindowPos(hAvi,HWND_TOP,m_x,m_y,m_w,m_h,0); 
}

void MoviePlayer::setAppearance(int x, int y, int width, int hight)
{

	m_w=width*3;
	m_h=hight*4;
	if (m_w > m_h)
	{
		m_w = m_h/3;
		m_h = hight;
	}else{
		m_h = m_w/4;
		m_w = width;
	}
	m_x=x+(width-m_w)/2;
    m_y=y+(hight-m_h)/2;

	SetWindowPos(hAvi,HWND_TOP,m_x,m_y,m_w,m_h,0); 
}


void MoviePlayer::open(const char* name)
{
	MCIWndDestroy(hAvi);
	hAvi = 0;
	if (m_status>0)
	  stop();
	m_name[0] = '\0';
	strcpy(m_name, name);
	{
	  AVIFileInit() ;
	  HRESULT hr = AVIFileOpen(&m_pfile,m_name,OF_READ,NULL) ;
	  if (( hr != 0 )||( m_pfile == 0))
	  {
	 	return;
	  }
	  AVIFileInfo(m_pfile,&m_pfi,sizeof(m_pfi)) ;
	  AVIFileRelease(m_pfile);  // closes the file 
      AVIFileExit();          // releases AVIFile library
	}
	hAvi = MCIWndCreate(m_parent ,m_parentInstance,
		WS_CHILD|
		WS_VISIBLE|MCIWNDF_NOMENU
		|MCIWNDF_NOPLAYBAR
//		|MCIWNDF_NOAUTOSIZEMOVIE
	,m_name) ;
	  MCIWndUseTime(hAvi) ; // --use milliseconds as the time format
	SetWindowPos(hAvi,HWND_TOP,m_x,m_y,m_w,(m_w*3)/4,0);
	m_synctime = MCIWndGetStart(hAvi);
}

/*
void MoviePlayer::stepForward()
{
	if (m_status==2 || m_status==0)
      m_status=1;
	long l=MCIWndGetPosition(hAvi);
	if ((l+m_stepwide)>=MCIWndGetEnd(hAvi))
		return;
	MCIWndPlayFromTo(hAvi,l, l+m_stepwide);
}

void MoviePlayer::stepBackward()
{
	if (m_status==2 || m_status==0)
      m_status=1;
	long l=MCIWndGetPosition(hAvi);
	if ((l-m_stepwide*2)<0)
		return;
	MCIWndPlayFromTo(hAvi,l-m_stepwide*2, l-m_stepwide);
}
*/

long MoviePlayer::getLength()
{
	return MCIWndGetLength(hAvi);
}

unsigned long MoviePlayer::getMintime()
{
	return MCIWndGetStart(hAvi);
}
unsigned long MoviePlayer::getMaxtime()
{
	return MCIWndGetEnd(hAvi);
}

void MoviePlayer::seekPosPerCent(int pos)
{
	long aviLength = MCIWndGetLength(hAvi) ;
	long temp = (aviLength/100)*pos ;
	long result = MCIWndSeek(hAvi,temp) ;
	// ::SetWindowText(hWnd,"Playing Movie..." + fileNameDisp) ;
	if (m_status==2) 
	{ 
	  MCIWndPlay(hAvi);
    }
}

void MoviePlayer::seekPos(unsigned long pos)
{
	try{
		if (pos < getMintime())
		{
			MCIWndSeek(hAvi, MCIWndGetStart( hAvi));
		}
		else if ( pos > getMaxtime())
		{
			MCIWndSeek(hAvi, MCIWndGetEnd( hAvi));
		}
		else
			long result = MCIWndSeek(hAvi,pos) ;
		// ::SetWindowText(hWnd,"Playing Movie..." + fileNameDisp) ;
		if (m_status==2) 
		{ 
		  MCIWndPlay(hAvi);
		}
	}catch(void*)
	{}
}

void MoviePlayer::seekPos(long pos)
{
	if (pos < (long)m_synctime)
		seekPos( (unsigned long) 0 );
	else
		seekPos( (unsigned long)(pos + m_synctime));
}


void MoviePlayer::speed(int speed)
{
	// long l = MCIWndGetSpeed(hAvi); l=1000 if speed=100%
	MCIWndSetSpeed(hAvi, speed*10);
}

void MoviePlayer::play()
{
	if (MCIWndGetLength(hAvi)==MCIWndGetPosition(hAvi))
	{
		stop();
	}
	if(m_status==1)         //1=paused
	{
      MCIWndResume(hAvi);
	  m_status=2;           //2=playing
	}
	else
	if(m_status==0)         //0=stopped
	{
 	  MCIWndPlay(hAvi) ;
	  m_status=2;
	}
}

void MoviePlayer::stop()
{
	m_status = 0;
	MCIWndStop(hAvi) ;
    MCIWndSeek(hAvi,0);
	//MCIWndClose(hAvi) ;
	//MCIWndDestroy(hAvi) ;
	
	// Destroys the movie window
//	::DestroyWindow(hWnd) ;

	//hAvi = NULL ;
//	hWnd = NULL ;
}

void MoviePlayer::pause()
{
	if(m_status==2 || m_status == 0) { // Pause the movie if it is playing
		MCIWndPause(hAvi) ;
		m_status=1;
	}
	else { // Play the movie if it is paused
		MCIWndResume(hAvi) ;
		m_status = 2;
	}
}


