/** 
* @file RobotControl/Visualization/MoviePlayer.h
* Declaration of class MoviePlayer
*
* @author <A href=mailto:manueln@gmx.de> Manuel Neubach</A>
*/

#ifndef __MoviePlayer_h_
#define __MoviePlayer_h_

#include <StdAfx.h>
#include <Windows.h>
#include <vfw.h>
#include "resource.h"
#include <stdlib.h>
//using std::string;

/**
* The MoviePlayer class defines a class for playing movies and uses vfw.lib
*
*
* @author Jrn Hamerla & Manuel Neubach
*/
class MoviePlayer 
{
public:
	MoviePlayer(HWND parent,HINSTANCE instance);
	~MoviePlayer();

	void open(const char* name);
	void play();
	void stop();
	void pause();
	void speed(int speed);
	long getLength();
//	void stepForward();
//	void stepBackward();
	void seekPosPerCent(int pos);//per cent
	void seekPos(unsigned long pos);
	void seekPos(long pos);
	void setAppearance(int x, int y, int width);
	void setAppearance(int x, int y, int width, int hight);

	unsigned long getMintime();
	unsigned long getMaxtime();

	unsigned long m_synctime;

private:
//	std::string	m_name;
	char		m_name[1000];
	PAVIFILE	m_pfile ;
	AVIFILEINFO m_pfi ;
	HWND		hAvi ;
	HWND		m_parent;
	HINSTANCE	m_parentInstance;
	int			m_x,m_y,m_w,m_h;
    int         m_status;
//	int			m_stepwide;
	//	int			m_h;

};



#endif