/**
* @file WorldstatePlayer.h
*
* Declaration of class WorldstatePlayer and play functions.
*
* @author 
*/

#ifndef __WORLDSTATEPLAYER_h_
#define __WORLDSTATEPLAYER_h_

#include <string>
using std::string;

#include "RobotControlQueues.h"

#include "Tools/MessageQueue/LogPlayerWithSync.h"
#include "RobotControl/Visualization/MoviePlayer.h"
#include "../Tools/Player.h"
class CWorldstateAnalysisDlgBar;

// Typen deklaration
#define TTIME unsigned long

/**
* @class CMessageHandlerForSync
*
* Declaration of class CMessageHandlerForSync
* the class analysis Massages and find the gamestart
* the least and the greates time
*
*/
/*
class CMessageHandlerForSync: public MessageHandler
{
	public:
		CMessageHandlerForSync();
		~CMessageHandlerForSync();
		virtual bool handleMessage(InMessage& message);

		virtual TTIME	getStartTime();
		virtual TTIME	getMinTime();
		virtual TTIME	getMaxTime();

	private:
		TTIME	m_timeStartgame;
		TTIME	m_timeMin;
		TTIME	m_timeMax;

};

/**
* @class WorldstatePlayer
*
* @author 
*/
class WorldstatePlayer: public MessageHandler
{
	public:

		virtual bool handleMessage(InMessage& message);

		enum PlayerState
		{
			deleted,
			empty,
			initial,
			recording,
			paused,
			playing
		};

	public:
//		WorldstatePlayer(CRobotControlQueues& queues,HWND hwnd, HINSTANCE instance);
		WorldstatePlayer(CRobotControlQueues& queues,HWND hwnd, HINSTANCE instance, CWorldstateAnalysisDlgBar* bar=0);
		~WorldstatePlayer();

		// play all Files
		void play();

		// stop all Files
		void stop();

		void pause();

		void stepForward();

		void stepBackward();

		void OnIdle();

		// load all Files
		void load();

		void speed(int sp);
		bool hasTimeDelay();

		void seekPos(int pos);
		void seekPosPerCent(int pos);

		/**
		* sets the reckangle where the movieplayer is showing
		*/
		void setAppearanceMovieplayer(int x, int y, int w){if (m_movieplayer!=0)m_movieplayer->setAppearance(x,y,w);}
		void setAppearanceMovieplayer(int left, int top, int right, int bottom){if (m_movieplayer!=0)m_movieplayer->setAppearance(left,top,right,bottom);}

		void updatePlaytime();

		/**
		* @param num  0 - n n LogPlayer (n+1) - (n+m) m movieplayer
		* m = 1
		* return the Time of an Logfile wenn the Game started
		*/
		TTIME getStarttime(int num);

		/**
		* @param num  0 - n  n LogPlayer (n+1) - (n+m) m movieplayer
		* m = 1
		* set the StartTime of an Logfile
		*/
		bool setStarttime(int num, string value);

		/**
		* return the gamepos.
		* gamepos 0  = kickoff
		*
		* @return position of the gametime
		*/
		long getPos();
		
		/**
		* return the gamepos.
		* gamepos 0   = kickoff
		* gamepos 100 = finisch
		*
		* @return position of the game per cent
		*/
		double getPosPerCent();

		/**
		*
		* @param num Number of the logfile
		* @return position of the logfile
		* @see getPos
		*/
		inline long getLogfilePos(Player::playerNumber num);

		/**
		*
		* @param num Number of the logfile
		* @return position of the logfile
		* @see getPos
		*/
		inline long getLastLogfilePos(Player::playerNumber num);

		/**
		* @param num Number of the logfile
		* @return true if the logfile is playing or recording or initial or paused
		*/
		inline bool isLogfileActive(Player::playerNumber num);

		int	getStatus();

		void syncLogfile(Player::playerNumber num);


	private:

		double			m_speed;

		// PlayTime
		long			m_timeMin;
		long			m_timeMax;
		long			m_playTime;
		TTIME			m_lasttimeSystem;


		// Start Time
//		TTIME			m_starttimeCam;
		
		// Status
		PlayerState		m_statusCam;
		PlayerState		m_statusPlayer;

		// Player
		LogPlayerWithSync*	m_logplayer[Player::numOfPlayerNumbers];
		MoviePlayer*		m_movieplayer;
		
		CWorldstateAnalysisDlgBar* m_bar;

		//tmp hilf ...
		// Send ohne nderungen
		Player m_player[Player::numOfPlayerNumbers];
		MessageQueue m_queue[Player::numOfPlayerNumbers];

		Player::playerNumber m_actMessage;


};

#endif

/*
 * Change log :
 * 
 * $Log: WorldstatePlayer.h,v $
 * Revision 1.14  2004/01/28 08:26:13  dueffert
 * doxygen bug fixed
 *
 * Revision 1.13  2003/12/25 13:25:46  hamerla
 * Logplayer extension to LogPlayerWithSync
 *
 * Revision 1.12  2003/12/14 10:42:12  hamerla
 * bug resize movieplayer
 *
 * Revision 1.11  2003/12/11 17:33:31  hamerla
 * *** empty log message ***
 *
 * Revision 1.10  2003/12/06 14:26:53  hamerla
 * *** empty log message ***
 *
 * Revision 1.9  2003/12/04 17:37:12  juengel
 * comment corrected
 *
 * Revision 1.8  2003/12/04 10:30:18  hamerla
 * no message
 *
 * Revision 1.7  2003/12/03 12:31:34  hamerla
 * no message
 *
 * Revision 1.6  2003/12/02 11:25:39  hamerla
 * Memory leaks WorldstatePlayer
 *
 * Revision 1.5  2003/12/02 10:41:42  lohmann
 * WorldstatePlayer Dialog changes
 *
 * Revision 1.4  2003/11/28 14:47:18  dueffert
 * bugs and warnings fixed
 *
 *
 *
 */
