/**
* @file RobotRemoteDlg.h
*
* Definition of the RobotRemote dialogs
*
* @author Martin Ltzsch
*/

#ifndef __RobotRemoteDlg_h_
#define __RobotRemoteDlg_h_

/**
* @class CRobotRemoteDlg1
* 
* The first configuration dialog which appaers before the main dialog
*
* @author Martin Ltzsch
*/
class CRobotRemoteDlg1 : public CDialog
{
public:
	CRobotRemoteDlg1(CWnd* pParent = NULL);

  /** Updates the buttons and bitmaps */
  void update();

	//{{AFX_DATA(CRobotRemoteDlg1)
	enum { IDD = IDD_ROBOTREMOTE_DIALOG };
	CComboBox	m_joystickCombo;
	CComboBox	m_configurationCombo;
	CStatic	m_JoystickBitmap2;
	CStatic	m_ConnectBitmap2;
	CStatic	m_ConnectBitmap;
	CStatic	m_JoystickBitmap;
	CIPAddressCtrl	m_IpControl;
	CButton	m_ConnectButton;
	//}}AFX_DATA

	//{{AFX_VIRTUAL(CRobotRemoteDlg1)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	//}}AFX_VIRTUAL

protected:
	HICON m_hIcon;

	//{{AFX_MSG(CRobotRemoteDlg1)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg void OnConnectButton();
	afx_msg void OnFieldchangedIpaddress(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnDestroy();
	afx_msg void OnSelchangeJoystickCombo();
	afx_msg void OnSelchangeConfigurationCombo();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/**
* @class CRobotRemoteDlg2
* 
* The main dialog
*
* @author Martin Ltzsch
*/
class CRobotRemoteDlg2 : public CDialog
{
public:
	CRobotRemoteDlg2(CWnd* pParent = NULL);

  /** Updates the buttons and bitmaps */
  void update();

	//{{AFX_DATA(CRobotRemoteDlg2)
	enum { IDD = IDD_ROBOTREMOTE_DIALOG2 };
	//}}AFX_DATA

	//{{AFX_VIRTUAL(CRobotRemoteDlg2)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	//}}AFX_VIRTUAL

protected:
	HICON m_hIcon;

	//{{AFX_MSG(CRobotRemoteDlg2)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


#endif // __RobotRemoteDlg_h_

/** 
* Change Log:
*
* $Log: RobotRemoteDlg.h,v $
* Revision 1.2  2004/05/24 15:40:41  thomas
* added combo-box to support for multiple joysticks
*
* Revision 1.1  2004/04/26 15:58:59  thomas
* added new project RobotRemote based on ATHAiboControl
*
* Revision 1.2  2004/01/26 13:35:02  loetzsch
* improved
*
* Revision 1.1  2004/01/24 14:55:28  loetzsch
* created ATH AiboControl
*
*/
